/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.impl;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.IResourceServiceProviderExtension;

public class SourceLevelURICache {
    private Set<URI> archives = Sets.newHashSet();
    private Set<URI> sources = Sets.newHashSet();

    public Set<URI> getSources() {
        return this.sources;
    }

    public Set<URI> getSourcesFrom(Collection<URI> allURIs, IResourceServiceProvider.Registry resourceServiceProviderRegistry) {
        for (URI uri : allURIs) {
            this.getOrComputeIsSource(uri, resourceServiceProviderRegistry);
        }
        return this.sources;
    }

    public void cacheAsSourceURIs(Collection<URI> uris) {
        this.sources.addAll(uris);
    }

    public boolean getOrComputeIsSource(URI uri, IResourceServiceProvider.Registry resourceServiceProviderRegistry) {
        if (this.archives.contains(uri)) {
            return false;
        }
        if (this.sources.contains(uri)) {
            return true;
        }
        IResourceServiceProvider provider = resourceServiceProviderRegistry.getResourceServiceProvider(uri);
        if (provider instanceof IResourceServiceProviderExtension && !((IResourceServiceProviderExtension)provider).isSource(uri)) {
            this.archives.add(uri);
            return false;
        }
        this.sources.add(uri);
        return true;
    }
}

