/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import java.util.ArrayList;
import java.util.Date;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.update.configuration.IActivity;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.InstallConfiguration;
import org.eclipse.update.internal.core.InstallLogParser;
import org.eclipse.update.internal.ui.UpdateLabelProvider;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIImages;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.internal.ui.parts.DefaultContentProvider;

public class ActivitiesTableViewer {
    private static InstallLogParser parser;

    public static TableViewer createViewer(Composite parent, boolean showCurrentOnly) {
        parser = new InstallLogParser();
        parser.parseInstallationLog();
        Table table = new Table(parent, 2048);
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(true);
        TableColumn column = new TableColumn(table, 0);
        column = new TableColumn(table, 0);
        column.setText(UpdateUIMessages.ActivitiesTableViewer_date);
        column = new TableColumn(table, 0);
        column.setText(UpdateUIMessages.ActivitiesTableViewer_target);
        column = new TableColumn(table, 0);
        column.setText(UpdateUIMessages.ActivitiesTableViewer_action);
        TableViewer activitiesViewer = new TableViewer(table);
        activitiesViewer.setLabelProvider((IBaseLabelProvider)new ActivitiesLabelProvider());
        activitiesViewer.setContentProvider((IContentProvider)new ActivitiesContentProvider(showCurrentOnly));
        return activitiesViewer;
    }

    static class ActivitiesContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        private boolean showCurrentOnly;

        public ActivitiesContentProvider(boolean showCurrentOnly) {
            this.showCurrentOnly = showCurrentOnly;
        }

        public Object[] getElements(Object element) {
            InstallConfiguration currentConfig = (InstallConfiguration)element;
            InstallConfiguration[] configs = parser.getConfigurations();
            boolean hitCurrentConfig = false;
            ArrayList<IActivity> activitiesList = new ArrayList<IActivity>();
            int i = 0;
            while (i < configs.length) {
                if (configs[i].equals((Object)currentConfig) && !hitCurrentConfig) {
                    hitCurrentConfig = true;
                }
                if (hitCurrentConfig && this.showCurrentOnly) {
                    return configs[i].getActivities();
                }
                if (hitCurrentConfig) {
                    IActivity[] activities = configs[i].getActivities();
                    int j = 0;
                    while (j < activities.length) {
                        activitiesList.add(activities[j]);
                        ++j;
                    }
                }
                ++i;
            }
            return activitiesList.toArray(new IActivity[activitiesList.size()]);
        }
    }

    static class ActivitiesLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ActivitiesLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                UpdateLabelProvider provider = UpdateUI.getDefault().getLabelProvider();
                switch (((IActivity)element).getStatus()) {
                    case 0: {
                        return provider.get(UpdateUIImages.DESC_OK_ST_OBJ, 0);
                    }
                    case 1: {
                        return provider.get(UpdateUIImages.DESC_ERR_ST_OBJ, 0);
                    }
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IActivity activity = (IActivity)element;
            switch (columnIndex) {
                case 1: {
                    return Utilities.format((Date)activity.getDate());
                }
                case 2: {
                    return activity.getLabel();
                }
                case 3: {
                    return this.getActionLabel(activity);
                }
            }
            return "";
        }

        private String getActionLabel(IActivity activity) {
            int action = activity.getAction();
            switch (action) {
                case 6: {
                    return UpdateUIMessages.ActivitiesTableViewer_enabled;
                }
                case 1: {
                    return UpdateUIMessages.ActivitiesTableViewer_featureInstalled;
                }
                case 2: {
                    return UpdateUIMessages.ActivitiesTableViewer_featureRemoved;
                }
                case 3: {
                    return UpdateUIMessages.ActivitiesTableViewer_siteInstalled;
                }
                case 4: {
                    return UpdateUIMessages.ActivitiesTableViewer_siteRemoved;
                }
                case 5: {
                    return UpdateUIMessages.ActivitiesTableViewer_disabled;
                }
                case 7: {
                    return UpdateUIMessages.ActivitiesTableViewer_revert;
                }
                case 8: {
                    return UpdateUIMessages.ActivitiesTableViewer_reconcile;
                }
            }
            return UpdateUIMessages.ActivitiesTableViewer_unknown;
        }
    }
}

