/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.common.presentation.CoreEditorAdvisor;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.impl.LabelImpl;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.Utility;
import org.eclipse.stem.ui.views.explorer.IdentifiableTreeNode;
import org.eclipse.stem.ui.wizards.Messages;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class NewIdentifiablePage
extends WizardPage {
    protected Combo projectNamesCombo;
    protected Text serializationFileNameField;
    protected List<IProject> stemProjects = null;
    static IProject lastProject = null;
    protected ModifyListener projectValidator = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            NewIdentifiablePage.this.setPageComplete(NewIdentifiablePage.this.validatePage());
        }
    };

    protected NewIdentifiablePage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        final ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        final Composite pageComposite = new Composite((Composite)scrollComposite, 0);
        GridLayout pageLayout = new GridLayout();
        pageLayout.numColumns = 1;
        pageLayout.verticalSpacing = 12;
        pageComposite.setLayout((Layout)pageLayout);
        scrollComposite.setContent((Control)pageComposite);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        this.createProjectComposite(pageComposite);
        Label seperator = new Label(pageComposite, 258);
        seperator.setLayoutData((Object)new GridData(768));
        Composite identifiableComposite = this.createSerializationComposite(pageComposite);
        identifiableComposite.setLayoutData((Object)new GridData(768));
        Composite specificComposite = this.createSpecificComposite(pageComposite);
        if (specificComposite != null) {
            GridData gd = new GridData(768);
            gd.grabExcessHorizontalSpace = true;
            specificComposite.setLayoutData((Object)gd);
            specificComposite.addControlListener(new ControlListener(){

                public void controlResized(ControlEvent e) {
                    scrollComposite.setMinSize(pageComposite.computeSize(-1, -1));
                }

                public void controlMoved(ControlEvent e) {
                }
            });
        }
        this.setPageComplete(this.validatePage());
        this.setControl((Control)scrollComposite);
        scrollComposite.setMinSize(pageComposite.computeSize(-1, -1));
    }

    private void createProjectComposite(Composite parent) {
        Composite projectComposite = new Composite(parent, 0);
        GridLayout projectCompositeLayout = new GridLayout();
        projectCompositeLayout.numColumns = 3;
        projectCompositeLayout.verticalSpacing = 12;
        projectCompositeLayout.marginHeight = 0;
        projectCompositeLayout.marginWidth = 0;
        projectComposite.setLayout((Layout)projectCompositeLayout);
        GridData projectCompositeLayoutData = new GridData();
        projectCompositeLayoutData.horizontalAlignment = 4;
        projectComposite.setLayoutData((Object)projectCompositeLayoutData);
        Label projectLabel = new Label(projectComposite, 16384);
        projectLabel.setText(String.valueOf(Messages.getString("NIdWiz.project")) + ":");
        GridData projectLabelLayoutData = new GridData();
        projectLabelLayoutData.horizontalSpan = 1;
        projectLabelLayoutData.horizontalAlignment = 4;
        projectLabel.setLayoutData((Object)projectLabelLayoutData);
        this.projectNamesCombo = new Combo(projectComposite, 2056);
        GridData projectFieldLayoutData = new GridData();
        projectFieldLayoutData.horizontalAlignment = 4;
        projectFieldLayoutData.grabExcessHorizontalSpace = true;
        projectFieldLayoutData.horizontalSpan = 1;
        this.projectNamesCombo.setLayoutData((Object)projectFieldLayoutData);
        this.initializeProjectCombo(this.projectNamesCombo);
        this.projectNamesCombo.addModifyListener(this.projectValidator);
        this.projectNamesCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                lastProject = NewIdentifiablePage.this.getSelectedProject();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button projectFieldBrowseButton = new Button(projectComposite, 8);
        projectFieldBrowseButton.setText(Messages.getString("NIdWiz.browse"));
        projectFieldBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String filePath = CoreEditorAdvisor.openFilePathDialog(NewIdentifiablePage.this.getShell(), "*", 4096);
                if (filePath != null) {
                    NewIdentifiablePage.this.projectNamesCombo.setText(filePath);
                }
            }
        });
    }

    private Composite createSerializationComposite(Composite parent) {
        Composite retValue = new Composite(parent, 0);
        GridLayout identifableCompositeLayout = new GridLayout();
        identifableCompositeLayout.numColumns = 3;
        identifableCompositeLayout.verticalSpacing = 12;
        identifableCompositeLayout.marginHeight = 0;
        identifableCompositeLayout.marginWidth = 0;
        retValue.setLayout((Layout)identifableCompositeLayout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        retValue.setLayoutData((Object)gridData);
        Label serializationFileNameLabel = new Label(retValue, 0);
        serializationFileNameLabel.setText(String.valueOf(Messages.getString("NIdWiz.name")) + ":");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 16384;
        serializationFileNameLabel.setLayoutData((Object)gridData);
        this.serializationFileNameField = new Text(retValue, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        this.serializationFileNameField.setLayoutData((Object)gridData);
        this.serializationFileNameField.addModifyListener(this.projectValidator);
        return retValue;
    }

    protected Composite createSpecificComposite(Composite parent) {
        return null;
    }

    public IProject getSelectedProject() {
        int ind = this.projectNamesCombo.getSelectionIndex();
        if (ind != -1) {
            return this.stemProjects.get(this.projectNamesCombo.getSelectionIndex());
        }
        return null;
    }

    private void initializeProjectCombo(Combo projectCombo) {
        IProject selectedProject = this.getWorkSpaceSelectedProject();
        if (selectedProject == null) {
            selectedProject = lastProject;
        }
        int index = 0;
        int i = 0;
        for (IProject project : this.getSTEMProjects()) {
            if (project.equals((Object)selectedProject)) {
                index = i;
            }
            String projectName = project.getName();
            projectCombo.add(projectName);
            ++i;
        }
        projectCombo.setFocus();
        projectCombo.select(index);
        lastProject = this.getSelectedProject();
    }

    private IProject getWorkSpaceSelectedProject() {
        IProject retValue = null;
        ISelection selection = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            for (Object obj : ((IStructuredSelection)selection).toList()) {
                if (obj instanceof IProject) {
                    retValue = (IProject)obj;
                    break;
                }
                if (obj instanceof IResource) {
                    retValue = ((IResource)obj).getProject();
                    break;
                }
                if (obj instanceof Identifiable) {
                    Graph g;
                    String labelURI;
                    String uriS = ((Identifiable)obj).getURI().toPlatformString(true);
                    if (uriS != null) {
                        Path path = new Path(uriS);
                        retValue = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path).getProject();
                        break;
                    }
                    if (!(obj instanceof LabelImpl) || !(((LabelImpl)obj).eContainer().eContainer() instanceof Graph) || (labelURI = (g = (Graph)((LabelImpl)obj).eContainer().eContainer()).getURI().toPlatformString(true)) == null) break;
                    Path path = new Path(g.getURI().toPlatformString(true));
                    retValue = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path).getProject();
                    break;
                }
                if (!(obj instanceof IdentifiableTreeNode)) continue;
                retValue = ((IdentifiableTreeNode)obj).getProject();
                break;
            }
        }
        return retValue;
    }

    private List<IProject> getSTEMProjects() {
        this.stemProjects = Utility.getSTEMProjectsFromWorkspace();
        return this.stemProjects;
    }

    protected boolean validatePage() {
        boolean retValue = true;
        this.setErrorMessage(null);
        if (this.getSTEMProjects().size() == 0) {
            this.setErrorMessage(Messages.getString("NIdWiz.noProjErr"));
            retValue = false;
        }
        if (retValue && this.serializationFileNameField.getText() == null || "".equals(this.serializationFileNameField.getText().trim())) {
            this.setErrorMessage(Messages.getString("NIdWiz.nameMissingErr"));
            retValue = false;
        }
        if (retValue && !this.serializationFileNameIsValid()) {
            this.setErrorMessage(Messages.getString("NIdWiz.nameErr"));
            retValue = false;
        }
        return retValue;
    }

    private boolean serializationFileNameIsValid() {
        String name = this.serializationFileNameField.getText();
        if (name == null) {
            return false;
        }
        String trimedName = name.trim();
        return !trimedName.equals("") && !trimedName.contains(" ");
    }
}

