/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.xtext.ui;

import org.eclipse.jdt.core.Flags;
import org.eclipse.xtext.common.types.xtext.ui.ITypesProposalProvider;

public final class TypeMatchFilters {
    private TypeMatchFilters() {
        throw new AssertionError((Object)"May not be instantiated.");
    }

    public static ITypesProposalProvider.Filter all() {
        return new All();
    }

    public static ITypesProposalProvider.Filter all(int searchFor) {
        return new All(searchFor);
    }

    public static ITypesProposalProvider.Filter none() {
        return new None();
    }

    public static ITypesProposalProvider.Filter not(ITypesProposalProvider.Filter filter) {
        return new Not(filter);
    }

    public static ITypesProposalProvider.Filter and(ITypesProposalProvider.Filter ... filter) {
        return new And(filter);
    }

    public static ITypesProposalProvider.Filter or(ITypesProposalProvider.Filter ... filter) {
        return new Or(filter);
    }

    public static ITypesProposalProvider.Filter canInstantiate() {
        return new CanInstantiate();
    }

    public static ITypesProposalProvider.Filter isPublic() {
        return new IsPublic();
    }

    public static boolean isInternalClass(char[] simpleTypeName, char[][] enclosingTypeNames) {
        if (simpleTypeName[0] == '$') {
            return true;
        }
        return enclosingTypeNames.length >= 1 && enclosingTypeNames[0][0] == '$';
    }

    public static class All
    implements ITypesProposalProvider.Filter {
        private final int searchFor;

        public All(int searchFor) {
            this.searchFor = searchFor;
        }

        public All() {
            this(0);
        }

        public boolean accept(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
            return !TypeMatchFilters.isInternalClass(simpleTypeName, enclosingTypeNames);
        }

        public int getSearchFor() {
            return this.searchFor;
        }
    }

    public static class And
    implements ITypesProposalProvider.Filter {
        private final ITypesProposalProvider.Filter[] delegates;

        public And(ITypesProposalProvider.Filter[] delegates) {
            this.delegates = delegates;
            if (delegates.length < 1) {
                throw new IllegalArgumentException("Cannot 'and' empty delegates");
            }
        }

        public boolean accept(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
            boolean result = true;
            int i = 0;
            while (result && i < this.delegates.length) {
                result = this.delegates[i].accept(modifiers, packageName, simpleTypeName, enclosingTypeNames, path);
                ++i;
            }
            return result;
        }

        public int getSearchFor() {
            return this.delegates[0].getSearchFor();
        }
    }

    public static class CanInstantiate
    implements ITypesProposalProvider.Filter {
        public boolean accept(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
            if (TypeMatchFilters.isInternalClass(simpleTypeName, enclosingTypeNames)) {
                return false;
            }
            return !Flags.isAbstract((int)modifiers) && !Flags.isInterface((int)modifiers);
        }

        public int getSearchFor() {
            return 5;
        }
    }

    public static class IsPublic
    implements ITypesProposalProvider.Filter {
        public boolean accept(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
            if (TypeMatchFilters.isInternalClass(simpleTypeName, enclosingTypeNames)) {
                return false;
            }
            return Flags.isPublic((int)modifiers);
        }

        public int getSearchFor() {
            return 0;
        }
    }

    public static class None
    implements ITypesProposalProvider.Filter {
        public boolean accept(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
            return false;
        }

        public int getSearchFor() {
            return 0;
        }
    }

    public static class Not
    implements ITypesProposalProvider.Filter {
        private final ITypesProposalProvider.Filter delegate;

        public Not(ITypesProposalProvider.Filter delegate) {
            this.delegate = delegate;
        }

        public boolean accept(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
            return !this.delegate.accept(modifiers, packageName, simpleTypeName, enclosingTypeNames, path);
        }

        public int getSearchFor() {
            return this.delegate.getSearchFor();
        }
    }

    public static class Or
    implements ITypesProposalProvider.Filter {
        private final ITypesProposalProvider.Filter[] delegates;

        public Or(ITypesProposalProvider.Filter[] delegates) {
            this.delegates = delegates;
            if (delegates.length < 1) {
                throw new IllegalArgumentException("Cannot 'or' empty delegates");
            }
        }

        public boolean accept(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
            boolean result = false;
            int i = 0;
            while (!result && i < this.delegates.length) {
                result = this.delegates[i].accept(modifiers, packageName, simpleTypeName, enclosingTypeNames, path);
                ++i;
            }
            return result;
        }

        public int getSearchFor() {
            return this.delegates[0].getSearchFor();
        }
    }
}

