/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.ui.query;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.ui.search.IMatchPresentation;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.ui.editor.IURIEditorOpener;
import org.eclipse.xtext.ui.label.GlobalDescriptionLabelProvider;

public class UIParticipant
implements IMatchPresentation {
    @Inject
    private GlobalDescriptionLabelProvider globalDescriptionsLabelProvider;
    @Inject
    private IURIEditorOpener uriEditorOpener;
    @Inject
    private IResourceDescriptions resourceDescriptions;

    public ILabelProvider createLabelProvider() {
        return new ILabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getText(Object element) {
                IReferenceDescription referenceDescription = (IReferenceDescription)element;
                URI containerEObjectURI = referenceDescription.getContainerEObjectURI();
                URI eObjectURI = containerEObjectURI == null ? referenceDescription.getSourceEObjectUri() : containerEObjectURI;
                IResourceDescription resourceDescription = UIParticipant.this.resourceDescriptions.getResourceDescription(eObjectURI.trimFragment());
                if (resourceDescription != null) {
                    for (IEObjectDescription eObjectDescription : resourceDescription.getExportedObjects()) {
                        if (!eObjectDescription.getEObjectURI().equals((Object)eObjectURI)) continue;
                        return UIParticipant.this.globalDescriptionsLabelProvider.getText((Object)eObjectDescription);
                    }
                }
                return "unknown";
            }

            public Image getImage(Object element) {
                IReferenceDescription referenceDescription = (IReferenceDescription)element;
                URI containerEObjectURI = referenceDescription.getContainerEObjectURI();
                URI eObjectURI = containerEObjectURI == null ? referenceDescription.getSourceEObjectUri() : containerEObjectURI;
                IResourceDescription resourceDescription = UIParticipant.this.resourceDescriptions.getResourceDescription(eObjectURI.trimFragment());
                if (resourceDescription != null) {
                    for (IEObjectDescription eObjectDescription : resourceDescription.getExportedObjects()) {
                        if (!eObjectDescription.getEObjectURI().equals((Object)eObjectURI)) continue;
                        return UIParticipant.this.globalDescriptionsLabelProvider.getImage((Object)eObjectDescription);
                    }
                }
                return null;
            }
        };
    }

    public void showMatch(Match match, int currentOffset, int currentLength, boolean activate) {
        Object o = match.getElement();
        if (o instanceof IReferenceDescription) {
            IReferenceDescription descr = (IReferenceDescription)o;
            if (activate) {
                this.uriEditorOpener.open(descr.getSourceEObjectUri(), descr.getEReference(), descr.getIndexInList(), true);
            }
        }
    }
}

