/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.internal.debug.core.refactoring.BreakpointChange;
import org.eclipse.jdt.internal.debug.core.refactoring.BreakpointRenameParticipant;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.ltk.core.refactoring.Change;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BreakpointRenameProjectParticipant
extends BreakpointRenameParticipant {
    @Override
    protected boolean accepts(IJavaElement element) {
        return element instanceof IJavaProject;
    }

    @Override
    protected void gatherChanges(IMarker[] markers, List<Change> changes, String destProjectName) throws CoreException, OperationCanceledException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(destProjectName);
        IJavaProject destProject = JavaCore.create((IProject)project);
        int i = 0;
        while (i < markers.length) {
            IJavaBreakpoint javaBreakpoint;
            IType breakpointType;
            IMarker marker = markers[i];
            IBreakpoint breakpoint = this.getBreakpoint(marker);
            if (breakpoint instanceof IJavaBreakpoint && (breakpointType = BreakpointUtils.getType(javaBreakpoint = (IJavaBreakpoint)breakpoint)) != null) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)breakpointType.getPackageFragment().getParent();
                Object rootResource = null;
                rootResource = root.getCorrespondingResource().equals((Object)this.getOriginalElement().getCorrespondingResource()) ? project : (root.isArchive() ? project.getFile(root.getElementName()) : project.getFolder(root.getElementName()));
                IPackageFragmentRoot destRoot = destProject.getPackageFragmentRoot((IResource)rootResource);
                IPackageFragment destPackage = destRoot.getPackageFragment(breakpointType.getPackageFragment().getElementName());
                Object parentElement = null;
                parentElement = breakpointType.isBinary() ? destPackage.getClassFile(breakpointType.getClassFile().getElementName()) : destPackage.getCompilationUnit(breakpointType.getCompilationUnit().getElementName());
                IJavaElement element = BreakpointChange.findElement((IJavaElement)parentElement, (IJavaElement)breakpointType);
                if (element != null && element instanceof IType) {
                    IType destType = (IType)element;
                    changes.add(this.createTypeChange(javaBreakpoint, destType, breakpointType));
                }
            }
            ++i;
        }
    }
}

