/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.internal.launching.PListParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacInstalledJREs {
    private static final String JAVA_HOME_PLIST = "/usr/libexec/java_home";
    private static final String PLIST_JVM_HOME_PATH = "JVMHomePath";
    private static final String PLIST_JVM_NAME = "JVMName";
    private static final String PLIST_JVM_VERSION = "JVMVersion";
    private static final String PLIST_JVM_BUNDLE_ID = "JVMBundleID";
    static final JREDescriptor[] NO_DESCRIPTORS = new JREDescriptor[0];

    public JREDescriptor[] getInstalledJREs() throws CoreException {
        File java_home = new File(JAVA_HOME_PLIST);
        if (!java_home.exists()) {
            throw new CoreException((IStatus)new Status(2, LaunchingPlugin.getUniqueIdentifier(), "The java_home executable does not exist"));
        }
        String[] cmdLine = new String[]{JAVA_HOME_PLIST, "-X"};
        Process p = null;
        try {
            p = DebugPlugin.exec((String[])cmdLine, null);
            IProcess process = DebugPlugin.newProcess((ILaunch)new Launch(null, "run", null), (Process)p, (String)"JRE Install Detection");
            int i = 0;
            while (i < 600) {
                if (process.isTerminated()) break;
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
                ++i;
            }
            JREDescriptor[] jREDescriptorArray = this.parseJREInfo(process);
            return jREDescriptorArray;
        }
        finally {
            if (p != null) {
                p.destroy();
            }
        }
    }

    private JREDescriptor[] parseJREInfo(IProcess process) throws CoreException {
        IStreamsProxy streamsProxy = process.getStreamsProxy();
        String text = null;
        if (streamsProxy != null) {
            text = streamsProxy.getOutputStreamMonitor().getContents();
        }
        if (text != null && text.length() > 0) {
            ByteArrayInputStream stream = new ByteArrayInputStream(text.getBytes());
            return this.parseJREInfo(stream);
        }
        return NO_DESCRIPTORS;
    }

    public JREDescriptor[] parseJREInfo(InputStream stream) {
        try {
            Object result = new PListParser().parse(stream);
            if (result instanceof Object[]) {
                Object[] maps = (Object[])result;
                ArrayList<JREDescriptor> jres = new ArrayList<JREDescriptor>();
                int i = 0;
                while (i < maps.length) {
                    Object object = maps[i];
                    if (object instanceof Map) {
                        String ver;
                        JREDescriptor descriptor;
                        Map map = (Map)object;
                        Object home = map.get(PLIST_JVM_HOME_PATH);
                        Object name = map.get(PLIST_JVM_NAME);
                        Object version = map.get(PLIST_JVM_VERSION);
                        if (home instanceof String && name instanceof String && version instanceof String && !jres.contains(descriptor = new JREDescriptor(new File((String)home), (String)name, (String)version, this.computeId(map, ver = (String)version)))) {
                            jres.add(descriptor);
                        }
                    }
                    ++i;
                }
                return jres.toArray(new JREDescriptor[jres.size()]);
            }
        }
        catch (CoreException ce) {
            LaunchingPlugin.log(ce);
        }
        return NO_DESCRIPTORS;
    }

    String computeId(Map<?, ?> map, String version) {
        Object o = map.get(PLIST_JVM_BUNDLE_ID);
        if (o instanceof String) {
            return (String)o;
        }
        return version;
    }

    public class JREDescriptor {
        String fName;
        File fHome;
        String fVersion;
        String fId;

        public JREDescriptor(File home, String name, String version, String id) {
            this.fHome = home;
            this.fName = name;
            this.fVersion = version;
            this.fId = id;
        }

        public File getHome() {
            return this.fHome;
        }

        public String getName() {
            return this.fName;
        }

        public String getVersion() {
            return this.fVersion;
        }

        public String getId() {
            return this.fId;
        }

        public boolean equals(Object obj) {
            if (obj instanceof JREDescriptor) {
                JREDescriptor jre = (JREDescriptor)obj;
                return jre.fHome.equals(this.fHome) && jre.fName.equals(this.fName) && jre.fVersion.equals(this.fVersion) && this.fId.equals(jre.fId);
            }
            return false;
        }

        public int hashCode() {
            return this.fHome.hashCode() + this.fName.hashCode() + this.fVersion.hashCode();
        }
    }
}

