/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.definitions.labels.provider;

import java.text.NumberFormat;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.stem.core.graph.provider.LabelValueItemProvider;
import org.eclipse.stem.definitions.edges.provider.DefinitionsEditPlugin;
import org.eclipse.stem.definitions.labels.AreaLabelValue;
import org.eclipse.stem.definitions.labels.LabelsPackage;

public class AreaLabelValueItemProvider
extends LabelValueItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    private static final int NUMBER_OF_FACTIONAL_DIGITS = 2;
    private static NumberFormat formatter;

    public AreaLabelValueItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    static NumberFormat getFormatter() {
        if (formatter == null) {
            formatter = NumberFormat.getNumberInstance();
            formatter.setMaximumFractionDigits(2);
            formatter.setMinimumFractionDigits(2);
        }
        return formatter;
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addAreaPropertyDescriptor(object);
            this.addAverageExtentPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addAreaPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_AreaLabelValue_area_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_AreaLabelValue_area_feature", "_UI_AreaLabelValue_type"), (EStructuralFeature)LabelsPackage.Literals.AREA_LABEL_VALUE__AREA, true, false, false, ItemPropertyDescriptor.REAL_VALUE_IMAGE, null, null));
    }

    protected void addAverageExtentPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_AreaLabelValue_averageExtent_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_AreaLabelValue_averageExtent_feature", "_UI_AreaLabelValue_type"), (EStructuralFeature)LabelsPackage.Literals.AREA_LABEL_VALUE__AVERAGE_EXTENT, true, false, false, ItemPropertyDescriptor.REAL_VALUE_IMAGE, null, null));
    }

    public String getText(Object object) {
        StringBuilder sb = new StringBuilder(AreaLabelValueItemProvider.getFormatter().format(((AreaLabelValue)object).getArea()));
        sb.append(" km^2");
        return sb.toString();
    }

    public String getTextGen(Object object) {
        AreaLabelValue areaLabelValue = (AreaLabelValue)object;
        return String.valueOf(this.getString("_UI_AreaLabelValue_type")) + " " + areaLabelValue.getArea();
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(AreaLabelValue.class)) {
            case 0: 
            case 1: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public ResourceLocator getResourceLocator() {
        return DefinitionsEditPlugin.INSTANCE;
    }
}

