/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.stem.analysis.LogInitializationException;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;
import org.eclipse.stem.analysis.util.CSVscenarioLoader;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.model.NodeDecorator;
import org.eclipse.stem.diseasemodels.Activator;
import org.eclipse.stem.diseasemodels.standard.InfectorInoculatorCollection;
import org.eclipse.stem.diseasemodels.standard.SIInfector;
import org.eclipse.stem.diseasemodels.standard.SIRInoculator;
import org.eclipse.stem.diseasemodels.standard.StandardFactory;
import org.eclipse.stem.diseasemodels.standard.impl.SIRInoculatorImpl;
import org.eclipse.stem.ui.wizards.DiseaseWizardMessages;
import org.eclipse.stem.ui.wizards.DublinCorePage;
import org.eclipse.stem.ui.wizards.InfectorDefinitionComposite;
import org.eclipse.stem.ui.wizards.NewIdentifiablePage;
import org.eclipse.stem.ui.wizards.NewIdentifiableWizard;
import org.eclipse.stem.ui.wizards.STEMWizardDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class NewInfectorWizard
extends NewIdentifiableWizard {
    private NewInfectorPage nip = null;

    protected String getWizardTitle() {
        return DiseaseWizardMessages.getString("NInfectorWiz.wizard_title");
    }

    protected NewIdentifiablePage createNewIdentifiablePage() {
        this.nip = new NewInfectorPage(DiseaseWizardMessages.getString("NInfectorWiz.page_title"));
        this.nip.setTitle(DiseaseWizardMessages.getString("NInfectorWiz.page_title"));
        this.nip.setDescription(DiseaseWizardMessages.getString("NInfectorWiz.page_description"));
        this.setHelpContextId("org.eclipse.stem.doc.newinfectorinoculator_contextid");
        return this.nip;
    }

    protected DublinCorePage createDublinCorePage() {
        return new DublinCorePage(){

            protected void initializeDCAttributes() {
                super.initializeDCAttributes();
                this.format.setText("http:///org/eclipse/stem/diseasemodels/standard.ecore");
                this.format.setEnabled(false);
                this.type.setEnabled(false);
            }
        };
    }

    protected Identifiable createIdentifiable() {
        NodeDecorator retValue = this.nip.getInfector();
        retValue.setDublinCore(this.newDublinCorePage.createDublinCore());
        return retValue;
    }

    protected String getSerializationFolderName() {
        return "decorators";
    }

    protected String getSerializationFileNameExtension() {
        return "standard";
    }

    protected static class NewInfectorPage
    extends NewIdentifiablePage {
        private InfectorDefinitionComposite idc;

        protected NewInfectorPage(String pageName) {
            super(pageName);
        }

        public NodeDecorator getInfector() {
            if (!this.idc.isFromFile()) {
                SIInfector retValue = null;
                if (this.idc.isInfectorMode()) {
                    retValue = StandardFactory.eINSTANCE.createSIInfector();
                    retValue.setTargetFeature("i");
                } else {
                    retValue = StandardFactory.eINSTANCE.createSIRInoculator();
                    retValue.setTargetFeature("r");
                }
                retValue.setDiseaseName(this.idc.getDiseaseName());
                retValue.setPopulationIdentifier(this.idc.getPopulation());
                retValue.setTargetISOKey(this.idc.getIsoKey());
                retValue.setTargetURI(this.idc.getTargetURI());
                if (this.idc.isInfectorMode() && this.idc.isPercentage()) {
                    retValue.setInfectPercentage(true);
                    retValue.setInfectiousCount(this.idc.getNumber());
                } else if (this.idc.isInfectorMode() && !this.idc.isPercentage()) {
                    retValue.setInfectPercentage(false);
                    retValue.setInfectiousCount(this.idc.getNumber());
                } else if (this.idc.isPercentage()) {
                    ((SIRInoculatorImpl)retValue).setInoculatedPercentage(this.idc.getNumber());
                    ((SIRInoculatorImpl)retValue).setInoculatePercentage(true);
                    retValue.setInfectiousCount(0.0);
                } else {
                    ((SIRInoculatorImpl)retValue).setInoculatedPercentage(this.idc.getNumber());
                    ((SIRInoculatorImpl)retValue).setInoculatePercentage(false);
                    retValue.setInfectiousCount(0.0);
                }
                return retValue;
            }
            String folder = this.idc.getImportFolder();
            ReferenceScenarioDataMapImpl map = null;
            try {
                CSVscenarioLoader loader = new CSVscenarioLoader(folder);
                map = loader.parseAllFiles();
            }
            catch (LogInitializationException sie) {
                Activator.logError((String)sie.getMessage(), (Throwable)sie);
                return null;
            }
            InfectorInoculatorCollection iic = StandardFactory.eINSTANCE.createInfectorInoculatorCollection();
            iic.setImportFolder(folder);
            for (String location : map.getLocations()) {
                ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance instance = map.getLocation(location);
                List counts = null;
                List denom = null;
                counts = this.idc.isInfectorMode() ? instance.getData("I") : instance.getData("R");
                if (this.idc.isPercentage()) {
                    denom = instance.getData("Population Count");
                }
                double dcount = 0.0;
                dcount = this.idc.isFirstRow() ? Double.parseDouble((String)counts.get(0)) : (this.idc.isLastRow() ? Double.parseDouble((String)counts.get(counts.size() - 1)) : Double.parseDouble((String)counts.get(this.idc.getSelectecRow())));
                double ddenom = 1.0;
                if (this.idc.isPercentage()) {
                    ddenom = this.idc.isFirstRow() ? Double.parseDouble((String)denom.get(0)) / 100.0 : (this.idc.isLastRow() ? Double.parseDouble((String)denom.get(counts.size() - 1)) / 100.0 : Double.parseDouble((String)denom.get(this.idc.getSelectecRow())) / 100.0);
                }
                SIInfector infector = null;
                if (this.idc.isInfectorMode()) {
                    infector = StandardFactory.eINSTANCE.createSIInfector();
                    infector.setInfectPercentage(this.idc.isPercentage());
                    infector.setInfectiousCount(dcount / ddenom);
                    infector.setURI(STEMURI.createURI((String)(String.valueOf(STEMURI.generateUniquePart()) + "/infect_" + location)));
                } else {
                    infector = StandardFactory.eINSTANCE.createSIRInoculator();
                    ((SIRInoculator)infector).setInoculatePercentage(this.idc.isPercentage());
                    ((SIRInoculator)infector).setInoculatedPercentage(dcount / ddenom);
                    infector.setURI(STEMURI.createURI((String)(String.valueOf(STEMURI.generateUniquePart()) + "/inoculate_" + location)));
                }
                infector.setDiseaseName(this.idc.getDiseaseName());
                infector.setPopulationIdentifier(this.idc.getPopulation());
                infector.setTargetISOKey(location);
                iic.getList().add((Object)infector);
            }
            return iic;
        }

        protected Composite createSpecificComposite(Composite parent) {
            this.idc = new InfectorDefinitionComposite(parent, 0, this.projectValidator, super.getSelectedProject());
            final NewInfectorPage self = this;
            this.projectNamesCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    NewInfectorPage.this.idc.setProject(self.getSelectedProject());
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }
            });
            return this.idc;
        }

        protected boolean validatePage() {
            boolean retValue = super.validatePage();
            if (retValue) {
                this.setErrorMessage(null);
                retValue = this.idc.validate();
                if (!retValue) {
                    this.setErrorMessage(this.idc.getErrorMessage());
                }
            }
            return retValue;
        }
    }

    public static class NewInfectorWizardCommandHandler
    extends AbstractHandler
    implements IHandler {
        public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
            IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)executionEvent);
            NewInfectorWizard wizard = new NewInfectorWizard();
            wizard.init(window.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
            STEMWizardDialog wizardDialog = new STEMWizardDialog(window.getShell(), (IWizard)wizard);
            wizardDialog.open();
            return null;
        }
    }
}

