/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.CollectingSearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.util.SearchUtils;
import org.eclipse.ltk.core.refactoring.IRefactoringStatusEntryComparator;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefactoringSearchEngine {
    private RefactoringSearchEngine() {
    }

    public static ICompilationUnit[] findAffectedCompilationUnits(SearchPattern pattern, IJavaSearchScope scope, IProgressMonitor pm, RefactoringStatus status, boolean tolerateInAccurateMatches) throws JavaModelException {
        boolean hasNonCuMatches = false;
        class ResourceSearchRequestor
        extends SearchRequestor {
            boolean hasPotentialMatches = false;
            Set<IResource> resources = new HashSet<IResource>(5);
            private IResource fLastResource;
            private final /* synthetic */ boolean val$tolerateInAccurateMatches;

            ResourceSearchRequestor(boolean bl) {
                this.val$tolerateInAccurateMatches = bl;
            }

            public void acceptSearchMatch(SearchMatch match) {
                if (!this.val$tolerateInAccurateMatches && match.getAccuracy() == 1) {
                    this.hasPotentialMatches = true;
                }
                if (this.fLastResource != match.getResource()) {
                    this.fLastResource = match.getResource();
                    this.resources.add(this.fLastResource);
                }
            }
        }
        ResourceSearchRequestor requestor = new ResourceSearchRequestor(tolerateInAccurateMatches);
        try {
            new SearchEngine().search(pattern, SearchUtils.getDefaultSearchParticipants(), scope, (SearchRequestor)requestor, pm);
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
        ArrayList<IJavaElement> result = new ArrayList<IJavaElement>(requestor.resources.size());
        for (IResource resource : requestor.resources) {
            IJavaElement element = JavaCore.create((IResource)resource);
            if (element instanceof ICompilationUnit) {
                result.add(element);
                continue;
            }
            hasNonCuMatches = true;
        }
        RefactoringSearchEngine.addStatusErrors(status, requestor.hasPotentialMatches, hasNonCuMatches);
        return result.toArray(new ICompilationUnit[result.size()]);
    }

    public static ICompilationUnit[] findAffectedCompilationUnits(SearchPattern pattern, IJavaSearchScope scope, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        return RefactoringSearchEngine.findAffectedCompilationUnits(pattern, scope, pm, status, false);
    }

    public static SearchResultGroup[] search(SearchPattern pattern, IJavaSearchScope scope, IProgressMonitor monitor, RefactoringStatus status) throws JavaModelException {
        return RefactoringSearchEngine.internalSearch(new SearchEngine(), pattern, scope, new CollectingSearchRequestor(), monitor, status);
    }

    public static SearchResultGroup[] search(SearchPattern pattern, WorkingCopyOwner owner, IJavaSearchScope scope, IProgressMonitor monitor, RefactoringStatus status) throws JavaModelException {
        return RefactoringSearchEngine.internalSearch(owner != null ? new SearchEngine(owner) : new SearchEngine(), pattern, scope, new CollectingSearchRequestor(), monitor, status);
    }

    public static SearchResultGroup[] search(SearchPattern pattern, IJavaSearchScope scope, CollectingSearchRequestor requestor, IProgressMonitor monitor, RefactoringStatus status) throws JavaModelException {
        return RefactoringSearchEngine.internalSearch(new SearchEngine(), pattern, scope, requestor, monitor, status);
    }

    public static SearchResultGroup[] search(SearchPattern pattern, WorkingCopyOwner owner, IJavaSearchScope scope, CollectingSearchRequestor requestor, IProgressMonitor monitor, RefactoringStatus status) throws JavaModelException {
        return RefactoringSearchEngine.internalSearch(owner != null ? new SearchEngine(owner) : new SearchEngine(), pattern, scope, requestor, monitor, status);
    }

    private static SearchResultGroup[] internalSearch(SearchEngine searchEngine, SearchPattern pattern, IJavaSearchScope scope, CollectingSearchRequestor requestor, IProgressMonitor monitor, RefactoringStatus status) throws JavaModelException {
        try {
            searchEngine.search(pattern, SearchUtils.getDefaultSearchParticipants(), scope, (SearchRequestor)requestor, monitor);
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
        return RefactoringSearchEngine.groupByCu(requestor.getResults(), status);
    }

    public static SearchResultGroup[] groupByCu(SearchMatch[] matches, RefactoringStatus status) {
        return RefactoringSearchEngine.groupByCu(Arrays.asList(matches), status);
    }

    public static SearchResultGroup[] groupByCu(List<SearchMatch> matchList, RefactoringStatus status) {
        HashMap grouped = new HashMap();
        boolean hasPotentialMatches = false;
        boolean hasNonCuMatches = false;
        for (SearchMatch searchMatch : matchList) {
            if (searchMatch.getAccuracy() == 1) {
                hasPotentialMatches = true;
            }
            if (!grouped.containsKey(searchMatch.getResource())) {
                grouped.put(searchMatch.getResource(), new ArrayList(1));
            }
            ((List)grouped.get(searchMatch.getResource())).add(searchMatch);
        }
        Iterator<Object> iter = grouped.keySet().iterator();
        while (iter.hasNext()) {
            IResource resource = (IResource)iter.next();
            IJavaElement element = JavaCore.create((IResource)resource);
            if (element instanceof ICompilationUnit) continue;
            iter.remove();
            hasNonCuMatches = true;
        }
        SearchResultGroup[] result = new SearchResultGroup[grouped.keySet().size()];
        int i = 0;
        for (IResource resource : grouped.keySet()) {
            List searchMatches = (List)grouped.get(resource);
            SearchMatch[] matchArray = searchMatches.toArray(new SearchMatch[searchMatches.size()]);
            result[i] = new SearchResultGroup(resource, matchArray);
            ++i;
        }
        RefactoringSearchEngine.addStatusErrors(status, hasPotentialMatches, hasNonCuMatches);
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static SearchPattern createOrPattern(IJavaElement[] elements, int limitTo) {
        if (elements == null || elements.length == 0) {
            return null;
        }
        set = new HashSet<IJavaElement>(Arrays.asList(elements));
        iter = set.iterator();
        first = (IJavaElement)iter.next();
        pattern = SearchPattern.createPattern((IJavaElement)first, (int)limitTo, (int)24);
        if (pattern != null) ** GOTO lbl14
        throw new IllegalArgumentException("Invalid java element: " + first.getHandleIdentifier() + "\n" + first.toString());
lbl-1000:
        // 1 sources

        {
            each = (IJavaElement)iter.next();
            nextPattern = SearchPattern.createPattern((IJavaElement)each, (int)limitTo, (int)24);
            if (nextPattern == null) {
                throw new IllegalArgumentException("Invalid java element: " + each.getHandleIdentifier() + "\n" + each.toString());
            }
            pattern = SearchPattern.createOrPattern((SearchPattern)pattern, (SearchPattern)nextPattern);
lbl14:
            // 2 sources

            ** while (iter.hasNext())
        }
lbl15:
        // 1 sources

        return pattern;
    }

    private static boolean containsStatusEntry(RefactoringStatus status, RefactoringStatusEntry other) {
        return status.getEntries(new IRefactoringStatusEntryComparator(){

            public final int compare(RefactoringStatusEntry entry1, RefactoringStatusEntry entry2) {
                return entry1.getMessage().compareTo(entry2.getMessage());
            }
        }, other).length > 0;
    }

    private static void addStatusErrors(RefactoringStatus status, boolean hasPotentialMatches, boolean hasNonCuMatches) {
        RefactoringStatusEntry entry;
        if (hasPotentialMatches && !RefactoringSearchEngine.containsStatusEntry(status, entry = new RefactoringStatusEntry(3, RefactoringCoreMessages.RefactoringSearchEngine_potential_matches))) {
            status.addEntry(entry);
        }
        if (hasNonCuMatches && !RefactoringSearchEngine.containsStatusEntry(status, entry = new RefactoringStatusEntry(3, RefactoringCoreMessages.RefactoringSearchEngine_non_cu_matches))) {
            status.addEntry(entry);
        }
    }
}

