/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.product.FeatureSection;
import org.eclipse.pde.internal.ui.editor.product.PluginSection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class DependenciesPage
extends PDEFormPage {
    public static final String PLUGIN_ID = "plugin-dependencies";
    public static final String FEATURE_ID = "feature-dependencies";
    private boolean fUseFeatures;
    private PluginSection fPluginSection = null;

    public DependenciesPage(FormEditor editor, boolean useFeatures) {
        super(editor, useFeatures ? FEATURE_ID : PLUGIN_ID, PDEUIMessages.Product_DependenciesPage_title);
        this.fUseFeatures = useFeatures;
    }

    protected String getHelpResource() {
        return "org.eclipse.pde.doc.user.configuration_page";
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        form.setImage(PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_REQ_PLUGINS_OBJ));
        form.setText(PDEUIMessages.Product_DependenciesPage_title);
        this.fillBody(managedForm, toolkit);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form.getBody(), "org.eclipse.pde.doc.user.configuration_page");
    }

    private void fillBody(IManagedForm managedForm, FormToolkit toolkit) {
        Composite body = managedForm.getForm().getBody();
        body.setLayout((Layout)FormLayoutFactory.createFormGridLayout(false, 1));
        if (this.fUseFeatures) {
            managedForm.addPart((IFormPart)new FeatureSection(this, body));
        } else {
            this.fPluginSection = new PluginSection(this, body);
            managedForm.addPart((IFormPart)this.fPluginSection);
        }
    }

    public boolean includeOptionalDependencies() {
        return this.fPluginSection != null ? this.fPluginSection.includeOptionalDependencies() : false;
    }
}

