/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.feature.FeatureEditor;
import org.eclipse.pde.internal.ui.editor.feature.FeatureEditorContributor;
import org.eclipse.pde.internal.ui.editor.feature.FeatureSpecSection;
import org.eclipse.pde.internal.ui.editor.feature.PortabilitySection;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class FeatureFormPage
extends PDEFormPage
implements IHyperlinkListener {
    public static final String PAGE_ID = "feature";
    private FeatureSpecSection fSpecSection;
    private PortabilitySection fPortabilitySection;

    public FeatureFormPage(PDEFormEditor editor, String title) {
        super(editor, PAGE_ID, title);
    }

    protected String getHelpResource() {
        return "org.eclipse.pde.doc.user.manifest_feature_overview";
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        form.getBody().setLayout((Layout)FormLayoutFactory.createFormTableWrapLayout(true, 2));
        form.setImage(PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_FTR_XML_OBJ));
        Composite left = toolkit.createComposite(form.getBody());
        left.setLayout((Layout)FormLayoutFactory.createFormPaneTableWrapLayout(false, 1));
        TableWrapData twd = new TableWrapData(256);
        left.setLayoutData((Object)twd);
        Composite right = toolkit.createComposite(form.getBody());
        right.setLayout((Layout)FormLayoutFactory.createFormPaneTableWrapLayout(false, 1));
        twd = new TableWrapData(256);
        right.setLayoutData((Object)twd);
        this.fSpecSection = new FeatureSpecSection(this, left);
        this.fPortabilitySection = new PortabilitySection(this, left);
        twd = new TableWrapData();
        twd.grabHorizontal = true;
        this.fPortabilitySection.getSection().setLayoutData((Object)twd);
        this.createContentSection(managedForm, right, toolkit);
        this.createPackagingSection(managedForm, right, toolkit);
        this.createPublishingSection(managedForm, right, toolkit);
        managedForm.addPart((IFormPart)this.fSpecSection);
        managedForm.addPart((IFormPart)this.fPortabilitySection);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form.getBody(), "org.eclipse.pde.doc.user.manifest_feature_overview");
        this.initialize();
    }

    public void initialize() {
        IFeatureModel model = (IFeatureModel)this.getModel();
        IFeature feature = model.getFeature();
        this.getManagedForm().getForm().setText(model.getResourceString(feature.getLabel()));
    }

    private Section createContentSection(IManagedForm managedForm, Composite parent, FormToolkit toolkit) {
        Section section = this.createStaticSection(parent, toolkit);
        section.setText(PDEUIMessages.FeatureEditor_InfoPage_ContentSection_title);
        FormText text = this.createClient(section, PDEUIMessages.FeatureEditor_InfoPage_ContentSection_text, toolkit);
        PDELabelProvider lp = PDEPlugin.getDefault().getLabelProvider();
        text.setImage("page", lp.get(PDEPluginImages.DESC_PAGE_OBJ, 8));
        return section;
    }

    private Section createPackagingSection(IManagedForm managedForm, Composite parent, FormToolkit toolkit) {
        Section section = this.createStaticSection(parent, toolkit);
        section.setText(PDEUIMessages.FeatureEditor_InfoPage_PackagingSection_title);
        this.createClient(section, PDEUIMessages.FeatureEditor_InfoPage_PackagingSection_text, toolkit);
        return section;
    }

    private Section createPublishingSection(IManagedForm managedForm, Composite parent, FormToolkit toolkit) {
        Section section = this.createStaticSection(parent, toolkit);
        section.setText(PDEUIMessages.FeatureEditor_InfoPage_PublishingSection_title);
        this.createClient(section, PDEUIMessages.FeatureEditor_InfoPage_PublishingSection_text, toolkit);
        return section;
    }

    private FormText createClient(Section section, String content, FormToolkit toolkit) {
        FormText text = toolkit.createFormText((Composite)section, true);
        try {
            text.setText(content, true, false);
        }
        catch (SWTException e) {
            text.setText(e.getMessage(), false, false);
        }
        section.setClient((Control)text);
        section.setLayoutData((Object)new TableWrapData(256));
        text.addHyperlinkListener((IHyperlinkListener)this);
        return text;
    }

    private Section createStaticSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 256);
        section.clientVerticalSpacing = 6;
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(768);
        section.setLayoutData((Object)data);
        return section;
    }

    public void linkActivated(HyperlinkEvent e) {
        String href = (String)e.getHref();
        if (href.equals("info")) {
            this.getEditor().setActivePage("info");
        }
        if (href.equals("plugins")) {
            this.getEditor().setActivePage("reference");
        } else if (href.equals("features")) {
            this.getEditor().setActivePage("includes");
        } else if (href.equals("dependencies")) {
            this.getEditor().setActivePage("dependencies");
        } else if (href.equals("installHandler")) {
            this.getEditor().setActivePage("advanced");
        } else if (href.equals("build")) {
            this.getEditor().setActivePage("build");
        } else if (href.equals("synchronize")) {
            this.getEditor().setActivePage("reference");
            final FeatureEditorContributor contributor = (FeatureEditorContributor)this.getPDEEditor().getContributor();
            BusyIndicator.showWhile((Display)e.display, (Runnable)new Runnable(){

                public void run() {
                    contributor.getSynchronizeAction().run();
                }
            });
        } else if (href.equals("export")) {
            ((FeatureEditor)this.getPDEEditor()).getFeatureExportAction().run();
        } else if (href.equals("siteProject")) {
            this.getEditor().doSave(null);
            final FeatureEditorContributor contributor = (FeatureEditorContributor)this.getPDEEditor().getContributor();
            BusyIndicator.showWhile((Display)e.display, (Runnable)new Runnable(){

                public void run() {
                    contributor.getNewSiteAction().run();
                }
            });
        }
    }

    public void linkEntered(HyperlinkEvent e) {
        IStatusLineManager mng = this.getEditor().getEditorSite().getActionBars().getStatusLineManager();
        mng.setMessage(e.getLabel());
    }

    public void linkExited(HyperlinkEvent e) {
        IStatusLineManager mng = this.getEditor().getEditorSite().getActionBars().getStatusLineManager();
        mng.setMessage(null);
    }
}

