/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import com.google.inject.Inject;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.resource.IGlobalServiceProvider;
import org.eclipse.xtext.ui.refactoring.impl.DisplayChangeWrapper;
import org.eclipse.xtext.ui.refactoring.impl.IRefactoringDocument;
import org.eclipse.xtext.ui.refactoring.impl.ProjectUtil;
import org.eclipse.xtext.ui.refactoring.impl.StatusWrapper;
import org.eclipse.xtext.ui.util.DisplayRunnableWithResult;

public class DefaultRefactoringDocumentProvider
implements IRefactoringDocument.Provider {
    @Inject(optional=true)
    private IWorkbench workbench;
    @Inject
    private ProjectUtil projectUtil;
    @Inject
    private IGlobalServiceProvider globalServiceProvider;

    protected IFileEditorInput getEditorInput(URI resourceURI, StatusWrapper status) {
        IFile file = this.projectUtil.findFileStorage(resourceURI, true);
        if (file == null) {
            status.add(3, "No suitable storage found for resource {0}.", resourceURI);
            return null;
        }
        return new FileEditorInput(file);
    }

    public IRefactoringDocument get(URI uri, final StatusWrapper status) {
        URI resourceURI = uri.trimFragment();
        final IFileEditorInput fileEditorInput = this.getEditorInput(resourceURI, status);
        if (fileEditorInput != null) {
            IDocument document;
            ITextEditor editor = (ITextEditor)new DisplayRunnableWithResult<ITextEditor>(){

                @Override
                protected ITextEditor run() throws Exception {
                    IWorkbenchWindow activeWorkbenchWindow = DefaultRefactoringDocumentProvider.this.workbench.getActiveWorkbenchWindow();
                    IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
                    IEditorPart editor = activePage.findEditor((IEditorInput)fileEditorInput);
                    if (editor instanceof ITextEditor) {
                        if (editor instanceof ITextEditorExtension && ((ITextEditorExtension)editor).isEditorInputReadOnly()) {
                            status.add(3, "Editor for {0} is read only", fileEditorInput.getName());
                        }
                        return (ITextEditor)editor;
                    }
                    return null;
                }
            }.syncExec();
            if (editor != null && (document = editor.getDocumentProvider().getDocument((Object)fileEditorInput)) != null && editor.isDirty()) {
                return new EditorDocument(resourceURI, document);
            }
            return new FileDocument(resourceURI, fileEditorInput.getFile(), (IEncodingProvider)this.globalServiceProvider.findService(resourceURI, IEncodingProvider.class));
        }
        return null;
    }

    public static abstract class AbstractRefactoringDocument
    implements IRefactoringDocument {
        private URI resourceURI;

        public AbstractRefactoringDocument(URI resourceURI) {
            this.resourceURI = resourceURI;
        }

        public abstract Change createChange(String var1, TextEdit var2);

        public URI getURI() {
            return this.resourceURI;
        }

        public boolean equals(Object obj) {
            return this.getClass().isInstance(obj) && ((IRefactoringDocument)obj).getURI().equals((Object)this.resourceURI);
        }

        public int hashCode() {
            return this.resourceURI.hashCode();
        }
    }

    public static class EditorDocument
    extends AbstractRefactoringDocument {
        private IDocument document;

        public EditorDocument(URI resourceURI, IDocument document) {
            super(resourceURI);
            this.document = document;
        }

        public IDocument getDocument() {
            return this.document;
        }

        public Change createChange(String name, TextEdit textEdit) {
            DocumentChange documentChange = new DocumentChange(this.getName(), this.document);
            documentChange.setEdit(textEdit);
            documentChange.setTextType(this.getURI().fileExtension());
            return new DisplayChangeWrapper((Change)documentChange);
        }

        protected String getName() {
            StringBuilder buffer = new StringBuilder(this.getURI().lastSegment());
            buffer.append(" - ");
            buffer.append(this.getURI().segment(1));
            int i = 2;
            while (i < this.getURI().segmentCount() - 1) {
                buffer.append("/");
                buffer.append(this.getURI().segment(i));
                ++i;
            }
            return buffer.toString();
        }

        public String getOriginalContents() {
            return this.document.get();
        }
    }

    public static class FileDocument
    extends AbstractRefactoringDocument {
        private IFile file;
        private IEncodingProvider encodingProvider;

        public FileDocument(URI resourceURI, IFile file, IEncodingProvider encodingProvider) {
            super(resourceURI);
            this.file = file;
            this.encodingProvider = encodingProvider;
        }

        public IFile getFile() {
            return this.file;
        }

        public Change createChange(String name, TextEdit textEdit) {
            TextFileChange textFileChange = new TextFileChange(name, this.file);
            textFileChange.setSaveMode(2);
            textFileChange.setEdit(textEdit);
            textFileChange.setTextType(this.getURI().fileExtension());
            return textFileChange;
        }

        public String getOriginalContents() {
            String string;
            InputStream inputStream = this.file.getContents();
            try {
                int read;
                String charset = this.encodingProvider != null ? this.encodingProvider.getEncoding(this.getURI()) : this.file.getCharset();
                InputStreamReader input = new InputStreamReader(inputStream, charset);
                char[] buffer = new char[4096];
                StringBuilder output = new StringBuilder(4096);
                while ((read = input.read(buffer, 0, buffer.length)) != -1) {
                    output.append(buffer, 0, read);
                }
                string = output.toString();
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (Exception e) {
                    throw new WrappedException(e);
                }
            }
            inputStream.close();
            return string;
        }
    }

    @Deprecated
    public static class SaveEditorDocument
    extends EditorDocument {
        private final ITextEditor editor;

        public SaveEditorDocument(URI uri, ITextEditor editor, IDocument document) {
            super(uri, document);
            this.editor = editor;
        }

        public Change createChange(String name, TextEdit textEdit) {
            DocumentChange documentChange = new DocumentChange(this.getName(), this.getDocument());
            documentChange.setEdit(textEdit);
            documentChange.setTextType(this.getURI().fileExtension());
            return new DisplayChangeWrapper((TextEditBasedChange)documentChange, this.editor);
        }
    }
}

