/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ant.core.IAntClasspathEntry;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.launchConfigurations.VariableInputDialog;
import org.eclipse.ant.internal.ui.preferences.AntClasspathContentProvider;
import org.eclipse.ant.internal.ui.preferences.AntClasspathLabelProvider;
import org.eclipse.ant.internal.ui.preferences.AntPreferencesMessages;
import org.eclipse.ant.internal.ui.preferences.ClasspathEntry;
import org.eclipse.ant.internal.ui.preferences.ClasspathModel;
import org.eclipse.ant.internal.ui.preferences.GlobalClasspathEntries;
import org.eclipse.ant.internal.ui.preferences.IAntBlockContainer;
import org.eclipse.ant.internal.ui.preferences.IClasspathEntry;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class AntClasspathBlock {
    private static final String[] TOOLS = new String[]{"tools.jar"};
    private TreeViewer treeViewer;
    private AntClasspathContentProvider antContentProvider;
    private Button upButton;
    private Button downButton;
    private Button removeButton;
    private AntClasspathLabelProvider labelProvider = new AntClasspathLabelProvider(this);
    private Button addFolderButton;
    private Button addJARButton;
    private Button addExternalJARButton;
    private Button addVariableButton;
    private Button antHomeButton;
    private String antHome;
    private IDialogSettings dialogSettings = AntUIPlugin.getDefault().getDialogSettings();
    private IAntBlockContainer container;
    private int validated = 2;
    private IClasspathEntry currentParent;
    private SelectionListener selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == AntClasspathBlock.this.addJARButton) {
                AntClasspathBlock.this.addJars();
            } else if (source == AntClasspathBlock.this.addExternalJARButton) {
                AntClasspathBlock.this.addExternalJars();
            } else if (source == AntClasspathBlock.this.addFolderButton) {
                AntClasspathBlock.this.addFolder();
            } else if (AntClasspathBlock.this.upButton == source) {
                AntClasspathBlock.this.handleMoveUp();
            } else if (AntClasspathBlock.this.downButton == source) {
                AntClasspathBlock.this.handleMoveDown();
            } else if (AntClasspathBlock.this.removeButton == source) {
                AntClasspathBlock.this.remove();
            } else if (AntClasspathBlock.this.addVariableButton == source) {
                AntClasspathBlock.this.addVariable();
            } else if (AntClasspathBlock.this.antHomeButton == source) {
                AntClasspathBlock.this.browseAntHome();
            }
        }
    };

    public void setContainer(IAntBlockContainer container) {
        this.container = container;
    }

    private void addButtonsToButtonGroup(Composite parent) {
        this.addJARButton = this.container.createPushButton(parent, AntPreferencesMessages.AntClasspathBlock_addJarButtonTitle);
        this.addJARButton.addSelectionListener(this.selectionListener);
        this.addExternalJARButton = this.container.createPushButton(parent, AntPreferencesMessages.AntClasspathBlock_42);
        this.addExternalJARButton.addSelectionListener(this.selectionListener);
        this.addFolderButton = this.container.createPushButton(parent, AntPreferencesMessages.AntClasspathBlock_addFolderButtonTitle);
        this.addFolderButton.addSelectionListener(this.selectionListener);
        this.addVariableButton = this.container.createPushButton(parent, AntPreferencesMessages.AntClasspathBlock_2);
        this.addVariableButton.addSelectionListener(this.selectionListener);
        this.antHomeButton = this.container.createPushButton(parent, AntPreferencesMessages.AntClasspathBlock_30);
        this.antHomeButton.addSelectionListener(this.selectionListener);
        this.removeButton = this.container.createPushButton(parent, AntPreferencesMessages.AntClasspathBlock_removeButtonTitle);
        this.removeButton.addSelectionListener(this.selectionListener);
        this.upButton = this.container.createPushButton(parent, AntPreferencesMessages.AntClasspathBlock_upButtonTitle);
        this.upButton.addSelectionListener(this.selectionListener);
        this.downButton = this.container.createPushButton(parent, AntPreferencesMessages.AntClasspathBlock_downButtonTitle);
        this.downButton.addSelectionListener(this.selectionListener);
    }

    private List getOrderedSelection(IClasspathEntry parent) {
        ArrayList<IAntClasspathEntry> targets = new ArrayList<IAntClasspathEntry>();
        List selection = ((IStructuredSelection)this.treeViewer.getSelection()).toList();
        IAntClasspathEntry[] entries = parent.getEntries();
        int i = 0;
        while (i < entries.length) {
            IAntClasspathEntry target = entries[i];
            if (selection.contains(target)) {
                targets.add(target);
            }
            ++i;
        }
        return targets;
    }

    private void handleMoveDown() {
        List targets = this.getOrderedSelection(this.currentParent);
        ArrayList<IAntClasspathEntry> list = new ArrayList<IAntClasspathEntry>(Arrays.asList(this.currentParent.getEntries()));
        int bottom = list.size() - 1;
        int index = 0;
        int i = targets.size() - 1;
        while (i >= 0) {
            Object target = targets.get(i);
            index = list.indexOf(target);
            if (index < bottom) {
                bottom = index + 1;
                Object temp = list.get(bottom);
                list.set(bottom, (IAntClasspathEntry)target);
                list.set(index, (IAntClasspathEntry)temp);
            }
            bottom = index;
            --i;
        }
        this.finishMove(list);
    }

    private void finishMove(List list) {
        AntClasspathContentProvider viewerContentProvider = (AntClasspathContentProvider)this.treeViewer.getContentProvider();
        viewerContentProvider.setEntries(this.currentParent, list);
        this.treeViewer.refresh();
        this.treeViewer.setSelection(this.treeViewer.getSelection());
        this.updateContainer();
    }

    private void handleMoveUp() {
        List targets = this.getOrderedSelection(this.currentParent);
        int top = 0;
        int index = 0;
        ArrayList<IAntClasspathEntry> list = new ArrayList<IAntClasspathEntry>(Arrays.asList(this.currentParent.getEntries()));
        Iterator entries = targets.iterator();
        while (entries.hasNext()) {
            Object target = entries.next();
            index = list.indexOf(target);
            if (index > top) {
                top = index - 1;
                Object temp = list.get(top);
                list.set(top, (IAntClasspathEntry)target);
                list.set(index, (IAntClasspathEntry)temp);
            }
            top = index;
        }
        this.finishMove(list);
    }

    private void remove() {
        AntClasspathContentProvider viewerContentProvider = (AntClasspathContentProvider)this.treeViewer.getContentProvider();
        IStructuredSelection sel = (IStructuredSelection)this.treeViewer.getSelection();
        viewerContentProvider.remove(sel);
        this.updateContainer();
    }

    private void addFolder() {
        String lastUsedPath = this.dialogSettings.get("org.eclipse.ant.ui.lastfolder");
        if (lastUsedPath == null) {
            lastUsedPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        }
        DirectoryDialog dialog = new DirectoryDialog(this.treeViewer.getControl().getShell());
        dialog.setMessage(AntPreferencesMessages.AntClasspathBlock_1);
        dialog.setFilterPath(lastUsedPath);
        String result = dialog.open();
        if (result != null) {
            try {
                URL url = new URL("file:" + result + "/");
                ((AntClasspathContentProvider)this.treeViewer.getContentProvider()).add(this.currentParent, (Object)url);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        this.treeViewer.setSelection(this.treeViewer.getSelection());
        this.dialogSettings.put("org.eclipse.ant.ui.lastfolder", result);
        this.updateContainer();
    }

    private void addExternalJars() {
        String lastUsedPath = this.dialogSettings.get("org.eclipse.ant.ui.lastextjar");
        if (lastUsedPath == null) {
            lastUsedPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        }
        FileDialog dialog = new FileDialog(this.treeViewer.getControl().getShell(), 2);
        dialog.setFilterExtensions(new String[]{"*.jar;*.zip"});
        dialog.setFilterPath(lastUsedPath);
        String result = dialog.open();
        if (result == null) {
            return;
        }
        Path filterPath = new Path(dialog.getFilterPath());
        String[] results = dialog.getFileNames();
        AntClasspathContentProvider contentProvider = (AntClasspathContentProvider)this.treeViewer.getContentProvider();
        contentProvider.setRefreshEnabled(false);
        int i = 0;
        while (i < results.length) {
            String jarName = results[i];
            try {
                IPath path = filterPath.append(jarName).makeAbsolute();
                URL url = new URL("file:" + path.toOSString());
                contentProvider.add(this.currentParent, (Object)url);
            }
            catch (MalformedURLException malformedURLException) {}
            ++i;
        }
        contentProvider.setRefreshEnabled(true);
        this.treeViewer.setSelection(this.treeViewer.getSelection());
        this.dialogSettings.put("org.eclipse.ant.ui.lastextjar", filterPath.toOSString());
        this.updateContainer();
    }

    private void addJars() {
        ArrayList<IAntClasspathEntry> allEntries = new ArrayList<IAntClasspathEntry>();
        if (this.currentParent != null) {
            allEntries.addAll(Arrays.asList(this.currentParent.getEntries()));
        } else {
            IAntClasspathEntry[] entries = this.antContentProvider.getModel().getEntries(2);
            if (entries != null) {
                allEntries.addAll(Arrays.asList(entries));
            }
        }
        ArrayList<IPath> selectedPaths = new ArrayList<IPath>(allEntries.size());
        Iterator iterator = allEntries.iterator();
        while (iterator.hasNext()) {
            String file;
            IAntClasspathEntry entry = (IAntClasspathEntry)iterator.next();
            URL url = entry.getEntryURL();
            if (url == null || (file = url.getFile()) == null || file.length() <= 0) continue;
            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(file));
            int i = 0;
            while (i < files.length) {
                selectedPaths.add(files[i].getFullPath());
                ++i;
            }
        }
        IPath[] paths = BuildPathDialogAccess.chooseJAREntries((Shell)this.treeViewer.getControl().getShell(), null, (IPath[])selectedPaths.toArray(new IPath[selectedPaths.size()]));
        if (paths != null && paths.length > 0) {
            AntClasspathContentProvider contentProvider = (AntClasspathContentProvider)this.treeViewer.getContentProvider();
            contentProvider.setRefreshEnabled(false);
            int i = 0;
            while (i < paths.length) {
                String varExpression = VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", paths[i].toString());
                contentProvider.add(this.currentParent, (Object)varExpression);
                ++i;
            }
            contentProvider.setRefreshEnabled(true);
            this.updateContainer();
        }
    }

    private void updateContainer() {
        this.validated = 0;
        this.container.update();
    }

    private void createButtonGroup(Composite top) {
        Composite buttonGroup = new Composite(top, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonGroup.setLayout((Layout)layout);
        buttonGroup.setLayoutData((Object)new GridData(1040));
        buttonGroup.setFont(top.getFont());
        this.addButtonsToButtonGroup(buttonGroup);
    }

    private void createClasspathTree(Composite parent) {
        Tree tree = new Tree(parent, 67586);
        GridData data = new GridData(1808);
        data.widthHint = 200;
        data.heightHint = tree.getItemHeight();
        tree.setLayoutData((Object)data);
        tree.setFont(parent.getFont());
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0) {
                    AntClasspathBlock.this.remove();
                }
            }
        });
        this.antContentProvider = new AntClasspathContentProvider();
        this.treeViewer = new TreeViewer(tree);
        this.treeViewer.setContentProvider((IContentProvider)this.antContentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AntClasspathBlock.this.tableSelectionChanged((IStructuredSelection)event.getSelection(), (AntClasspathContentProvider)AntClasspathBlock.this.treeViewer.getContentProvider());
            }
        });
    }

    public void createContents(Composite parent) {
        this.createClasspathTree(parent);
        this.createButtonGroup(parent);
        this.tableSelectionChanged((IStructuredSelection)this.treeViewer.getSelection(), this.antContentProvider);
    }

    private void tableSelectionChanged(IStructuredSelection selection, AntClasspathContentProvider contentProvider) {
        boolean notEmpty = !selection.isEmpty();
        boolean first = !notEmpty;
        boolean last = !notEmpty;
        boolean canRemove = true;
        boolean canAdd = notEmpty;
        boolean canMove = true;
        if (!this.resolveCurrentParent(selection)) {
            canAdd = false;
            canMove = false;
            canRemove = false;
        } else {
            Iterator selected = selection.iterator();
            while (selected.hasNext()) {
                IClasspathEntry parent;
                IClasspathEntry element = (IClasspathEntry)selected.next();
                if (element instanceof GlobalClasspathEntries) {
                    GlobalClasspathEntries global = (GlobalClasspathEntries)element;
                    canRemove = global.canBeRemoved();
                    canAdd = global.getType() != 3;
                    canMove = false;
                }
                if ((parent = element.getParent()) instanceof GlobalClasspathEntries) {
                    canRemove = canAdd = ((GlobalClasspathEntries)parent).getType() != 3;
                    canMove = canAdd;
                }
                Object[] childEntries = contentProvider.getChildren(parent);
                List<Object> entries = Arrays.asList(childEntries);
                int lastEntryIndex = entries.size() - 1;
                if (!first && entries.indexOf(element) == 0) {
                    first = true;
                }
                if (last || entries.indexOf(element) != lastEntryIndex) continue;
                last = true;
            }
        }
        this.addJARButton.setEnabled(canAdd);
        this.addExternalJARButton.setEnabled(canAdd);
        this.addFolderButton.setEnabled(canAdd);
        this.addVariableButton.setEnabled(canAdd);
        this.removeButton.setEnabled(notEmpty && canRemove);
        this.upButton.setEnabled(canMove && !first);
        this.downButton.setEnabled(canMove && !last);
    }

    private boolean resolveCurrentParent(IStructuredSelection selection) {
        this.currentParent = null;
        Iterator selected = selection.iterator();
        while (selected.hasNext()) {
            Object element = selected.next();
            if (element instanceof ClasspathEntry) {
                IClasspathEntry parent = ((IClasspathEntry)element).getParent();
                if (this.currentParent != null) {
                    if (this.currentParent.equals(parent)) continue;
                    return false;
                }
                this.currentParent = parent;
                continue;
            }
            if (this.currentParent != null) {
                if (this.currentParent.equals(element)) continue;
                return false;
            }
            this.currentParent = (IClasspathEntry)element;
        }
        return true;
    }

    private File validateAntHome(String path) {
        File rootDir = null;
        boolean invalid = true;
        if (path.length() > 0) {
            rootDir = new File(path, "lib");
            File parentDir = rootDir.getParentFile();
            if (parentDir == null || !parentDir.exists()) {
                this.container.setErrorMessage(AntPreferencesMessages.AntClasspathBlock_56);
            } else if (!rootDir.exists()) {
                this.container.setErrorMessage(AntPreferencesMessages.AntClasspathBlock_7);
            } else {
                invalid = false;
            }
        } else {
            this.container.setErrorMessage(AntPreferencesMessages.AntClasspathBlock_57);
        }
        if (invalid) {
            this.setValidated();
            return null;
        }
        this.container.setErrorMessage(null);
        return rootDir;
    }

    private void browseAntHome() {
        String lastUsedPath = this.dialogSettings.get("org.eclipse.ant.ui.lastanthome");
        if (lastUsedPath == null) {
            lastUsedPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        }
        DirectoryDialog dialog = new DirectoryDialog(this.treeViewer.getControl().getShell());
        dialog.setMessage(AntPreferencesMessages.AntClasspathBlock_3);
        dialog.setFilterPath(lastUsedPath);
        String path = dialog.open();
        if (path == null) {
            return;
        }
        this.antHome = path;
        if (path.length() > 0) {
            File rootDir = new File(path, "lib");
            this.setAntHome(rootDir);
        } else {
            this.updateContainer();
        }
        this.dialogSettings.put("org.eclipse.ant.ui.lastanthome", path);
    }

    private void setAntHome(File rootDir) {
        AntClasspathContentProvider contentProvider = (AntClasspathContentProvider)this.treeViewer.getContentProvider();
        contentProvider.setRefreshEnabled(false);
        contentProvider.removeAllGlobalAntClasspathEntries();
        Object[] names = rootDir.list();
        if (names != null) {
            Arrays.sort(names);
            int i = 0;
            while (i < names.length) {
                File file = new File(rootDir, (String)names[i]);
                if (file.isFile() && file.getPath().endsWith(".jar")) {
                    try {
                        URL url = new URL("file:" + file.getAbsolutePath());
                        contentProvider.add(0, (Object)url);
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
                ++i;
            }
        }
        contentProvider.setRefreshEnabled(true);
        this.updateContainer();
    }

    public String getAntHome() {
        return this.antHome;
    }

    public void initializeAntHome(String antHomeString) {
        this.antHome = antHomeString;
    }

    public void setInput(ClasspathModel model) {
        this.treeViewer.setInput((Object)model);
        this.validated = 0;
    }

    public boolean validateAntHome() {
        ++this.validated;
        return this.validateAntHome(this.antHome) != null;
    }

    public Image getClasspathImage() {
        return this.labelProvider.getClasspathImage();
    }

    public boolean validateToolsJAR() {
        ++this.validated;
        boolean check = AntUIPlugin.getDefault().getPreferenceStore().getBoolean("toolsJAR");
        if (check && !AntUIPlugin.isMacOS()) {
            boolean valid;
            Object[] entries = this.antContentProvider.getModel().getEntries(0);
            boolean bl = valid = !this.JARPresent(entries, TOOLS).isEmpty();
            if (!valid) {
                entries = this.antContentProvider.getModel().getEntries(1);
                boolean bl2 = valid = !this.JARPresent(entries, TOOLS).isEmpty();
                if (!valid) {
                    entries = this.antContentProvider.getModel().getEntries(2);
                    boolean bl3 = valid = !this.JARPresent(entries, TOOLS).isEmpty();
                    if (!valid) {
                        MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)AntUIPlugin.getActiveWorkbenchWindow().getShell(), (String)AntPreferencesMessages.AntClasspathBlock_31, (String)AntPreferencesMessages.AntClasspathBlock_32, (String)AntPreferencesMessages.AntClasspathBlock_33, (boolean)false, (IPreferenceStore)AntUIPlugin.getDefault().getPreferenceStore(), (String)"toolsJAR");
                        boolean bl4 = valid = dialog.getReturnCode() == 2;
                    }
                }
            }
            if (!valid) {
                this.container.setErrorMessage(AntPreferencesMessages.AntClasspathBlock_34);
                this.setValidated();
            }
            return valid;
        }
        return true;
    }

    private List JARPresent(Object[] classpathEntries, String[] suffixes) {
        if (classpathEntries == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> found = new ArrayList<String>(2);
        int i = 0;
        while (i < classpathEntries.length) {
            Object entry = classpathEntries[i];
            String file = entry instanceof URL ? ((URL)entry).getFile() : entry.toString();
            int j = 0;
            while (j < suffixes.length) {
                String suffix = suffixes[j];
                if (file.endsWith(suffix)) {
                    found.add(suffix);
                }
                ++j;
            }
            ++i;
        }
        return found;
    }

    public boolean isValidated() {
        return this.validated >= 2;
    }

    public void setValidated() {
        this.validated = 2;
    }

    private void addVariable() {
        VariableInputDialog inputDialog = new VariableInputDialog(this.treeViewer.getControl().getShell());
        inputDialog.open();
        String variableString = inputDialog.getVariableString();
        if (variableString != null && variableString.trim().length() > 0) {
            ((AntClasspathContentProvider)this.treeViewer.getContentProvider()).add(this.currentParent, (Object)variableString);
            this.treeViewer.setSelection(this.treeViewer.getSelection());
            this.updateContainer();
        }
    }
}

