/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.populationmodels.standard.impl;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.model.impl.NodeDecoratorImpl;
import org.eclipse.stem.core.scenario.ScenarioInitializationException;
import org.eclipse.stem.definitions.labels.PopulationLabel;
import org.eclipse.stem.definitions.labels.impl.PopulationLabelImpl;
import org.eclipse.stem.populationmodels.standard.PopulationInitializer;
import org.eclipse.stem.populationmodels.standard.PopulationModel;
import org.eclipse.stem.populationmodels.standard.StandardPackage;
import org.eclipse.stem.populationmodels.standard.impl.Messages;

public abstract class PopulationInitializerImpl
extends NodeDecoratorImpl
implements PopulationInitializer {
    protected static final String POPULATION_IDENTIFIER_EDEFAULT = "human";
    protected String populationIdentifier = "human";

    protected PopulationInitializerImpl() {
    }

    protected EClass eStaticClass() {
        return StandardPackage.Literals.POPULATION_INITIALIZER;
    }

    @Override
    public String getPopulationIdentifier() {
        return this.populationIdentifier;
    }

    @Override
    public void setPopulationIdentifier(String newPopulationIdentifier) {
        this.populationIdentifier = newPopulationIdentifier;
    }

    protected abstract void initializeLabel(PopulationLabel var1, STEMTime var2, boolean var3) throws ScenarioInitializationException;

    protected void checkPopulationModels() throws ScenarioInitializationException {
        for (Decorator d : this.getGraph().getDecorators()) {
            if (!(d instanceof PopulationModel) || !((PopulationModel)d).getPopulationIdentifier().equals(this.getPopulationIdentifier()) || !((PopulationModel)d).isGraphDecorated()) continue;
            throw new ScenarioInitializationException(NLS.bind((String)Messages.DUPLICATE_POP_INIT, (Object[])new Object[]{this.getPopulationIdentifier(), this.getURI().toString(), d.getURI().toString()}), (Identifiable)d, new Exception());
        }
    }

    protected int getYear(STEMTime time) {
        Calendar cal = Calendar.getInstance();
        if (time != null) {
            cal.setTime(time.getTime());
        } else {
            cal.setTime(new Date());
        }
        int year = cal.get(1);
        return year;
    }

    protected URI createPopulationLabelURI(Node n, STEMTime time) {
        int adminLevel = Utility.keyLevel((String)n.getURI().lastSegment());
        String countryCode = this.getCountryCode(n);
        String population = this.getPopulationIdentifier();
        Calendar currentCal = Calendar.getInstance();
        int year = currentCal.get(1) + 1900;
        if (time != null) {
            year = this.getYear(time);
        }
        String code = n.getURI().lastSegment();
        return PopulationLabelImpl.createPopulationLabelURI((int)adminLevel, (String)countryCode, (String)population, (String)String.valueOf(year), (String)code);
    }

    protected String getCountryCode(Node n) {
        if (Utility.keyLevel((String)n.getURI().lastSegment()) == 0) {
            return n.getURI().lastSegment();
        }
        for (Edge e : n.getEdges()) {
            if (Utility.keyLevel((String)e.getA().getURI().lastSegment()) >= Utility.keyLevel((String)n.getURI().lastSegment())) continue;
            return this.getCountryCode(e.getA());
        }
        return "ZZZ";
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 8: {
                return this.getPopulationIdentifier();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 8: {
                this.setPopulationIdentifier((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 8: {
                this.setPopulationIdentifier(POPULATION_IDENTIFIER_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return POPULATION_IDENTIFIER_EDEFAULT == null ? this.populationIdentifier != null : !POPULATION_IDENTIFIER_EDEFAULT.equals(this.populationIdentifier);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (populationIdentifier: ");
        result.append(this.populationIdentifier);
        result.append(')');
        return result.toString();
    }
}

