/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.resource;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ExternalPackageFragmentRoot;
import org.eclipse.xtext.ui.resource.JarEntryURIHelper;
import org.eclipse.xtext.ui.resource.PackageFragmentRootWalker;

public class JarEntryLocator {
    private static final Logger log = Logger.getLogger(JarEntryLocator.class);

    public URI getURI(final IJarEntryResource jarEntry) {
        final IPackageFragmentRoot root = jarEntry.getPackageFragmentRoot();
        if (root.isArchive()) {
            URI jarURI = JarEntryURIHelper.getUriForPackageFragmentRoot(root);
            URI storageURI = URI.createURI((String)jarEntry.getFullPath().toString());
            return this.createJarURI(root.isArchive(), jarURI, storageURI);
        }
        if (root.isExternal()) {
            if (root instanceof ExternalPackageFragmentRoot) {
                try {
                    return (URI)new PackageFragmentRootWalker<URI>(){

                        @Override
                        protected URI handle(IJarEntryResource current, PackageFragmentRootWalker.TraversalState state) {
                            if (current.equals(jarEntry)) {
                                return JarEntryLocator.this.getURI(root, current, state);
                            }
                            return null;
                        }
                    }.traverse(root, true);
                }
                catch (JavaModelException ex) {
                    if (!ex.isDoesNotExist()) {
                        log.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
            } else {
                throw new IllegalStateException("Unexpeced root type: " + root.getClass().getName());
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IJarEntryResource getJarEntry(final URI uri, final IPackageFragmentRoot root) {
        try {
            try {
                if (root.isArchive()) {
                    if (!uri.isArchive()) {
                        return null;
                    }
                    final String path = uri.devicePath().substring(uri.authority().length());
                    return (IJarEntryResource)new PackageFragmentRootWalker<IJarEntryResource>(){

                        @Override
                        protected IJarEntryResource handle(IJarEntryResource jarEntry, PackageFragmentRootWalker.TraversalState state) {
                            if (jarEntry.getFullPath().toString().equals(path)) {
                                return jarEntry;
                            }
                            return null;
                        }
                    }.traverse(root, true);
                }
                if (!(root instanceof ExternalPackageFragmentRoot)) throw new IllegalStateException("Unexpeced root type: " + root.getClass().getName());
                if (!uri.isPlatformResource()) {
                    return null;
                }
                IResource resource = ((ExternalPackageFragmentRoot)root).resource();
                Path uriAsPath = new Path(uri.toPlatformString(true));
                IPath absolutePath = resource.getFullPath();
                if (!absolutePath.isPrefixOf((IPath)uriAsPath)) return null;
                return (IJarEntryResource)new PackageFragmentRootWalker<IJarEntryResource>(){

                    @Override
                    protected IJarEntryResource handle(IJarEntryResource jarEntry, PackageFragmentRootWalker.TraversalState state) {
                        URI entryURI = JarEntryLocator.this.getURI(root, jarEntry, state);
                        if (entryURI.equals((Object)uri)) {
                            return jarEntry;
                        }
                        return null;
                    }
                }.traverse(root, true);
            }
            catch (JavaModelException ex) {
                if (ex.isDoesNotExist()) return null;
                log.error((Object)ex.getMessage(), (Throwable)ex);
                return null;
            }
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public URI getURI(IPackageFragmentRoot root, IJarEntryResource jarEntry, PackageFragmentRootWalker.TraversalState state) {
        if (root.isArchive()) {
            URI jarURI = JarEntryURIHelper.getUriForPackageFragmentRoot(root);
            URI storageURI = URI.createURI((String)jarEntry.getFullPath().toString());
            return this.createJarURI(root.isArchive(), jarURI, storageURI);
        }
        if (root instanceof ExternalPackageFragmentRoot) {
            IResource resource = ((ExternalPackageFragmentRoot)root).resource();
            IPath result = resource.getFullPath();
            int i = 1;
            while (i < state.getParents().size()) {
                Object obj = state.getParents().get(i);
                if (obj instanceof IPackageFragment) {
                    result = result.append((IPath)new Path(((IPackageFragment)obj).getElementName().replace('.', '/')));
                } else if (obj instanceof IJarEntryResource) {
                    result = result.append(((IJarEntryResource)obj).getName());
                }
                ++i;
            }
            result = result.append(jarEntry.getName());
            return URI.createPlatformResourceURI((String)result.toString(), (boolean)true);
        }
        throw new IllegalStateException("Unexpeced root type: " + root.getClass().getName());
    }

    protected URI createJarURI(boolean isArchive, URI uriToRoot, URI pathToResourceInRoot) {
        if (isArchive) {
            String fullURI = "archive:" + uriToRoot.toString() + "!" + pathToResourceInRoot.toString();
            return URI.createURI((String)fullURI);
        }
        return null;
    }
}

