/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.resource;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.dispatch.DispatchingSupport;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.typing.ReturnTypeProvider;
import org.eclipse.xtend.core.typing.XtendOverridesService;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMultiTypeReference;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.TypeConformanceComputer;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.resource.XbaseResource;
import org.eclipse.xtext.xbase.typing.ITypeProvider;
import org.eclipse.xtext.xbase.typing.JvmOnlyTypeConformanceComputer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendResource
extends XbaseResource {
    public static final String FRAGMENT_PREFIX = "\u00a7lazyType$";
    public static final Logger LOG = Logger.getLogger(XtendResource.class);
    @Inject
    private ITypeProvider typeProvider;
    @Inject
    private IXtendJvmAssociations associations;
    @Inject
    private TypeConformanceComputer typeConformanceComputer;
    @Inject
    private JvmOnlyTypeConformanceComputer jvmTypeConformanceComputer;
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private DispatchingSupport dispatchingSupport;
    @Inject
    private XtendOverridesService overridesService;
    @Inject
    private ReturnTypeProvider returnTypeProvider;
    private Set<String> computingFragments = Sets.newLinkedHashSet();

    public synchronized EObject getEObject(String uriFragment) {
        if (!uriFragment.startsWith(FRAGMENT_PREFIX)) {
            return super.getEObject(uriFragment);
        }
        if (!this.computingFragments.add(uriFragment)) {
            return null;
        }
        try {
            String fragmentToJvmOperation = uriFragment.substring(FRAGMENT_PREFIX.length());
            EObject eObject = super.getEObject(fragmentToJvmOperation);
            if (eObject instanceof XExpression) {
                EObject eObject2 = EcoreUtil2.cloneIfContained((EObject)this.typeProvider.getType((XExpression)eObject));
                return eObject2;
            }
            if (eObject instanceof JvmOperation) {
                JvmOperation op = (JvmOperation)eObject;
                JvmTypeReference typeReference = this.inferReturnType(op);
                if (typeReference == null || typeReference.getType() == null) {
                    JvmTypeReference jvmTypeReference = this.typeReferences.getTypeForName(Object.class, (Notifier)this.getContents().get(0), new JvmTypeReference[0]);
                    return jvmTypeReference;
                }
                if (typeReference.eContainer() != null && typeReference.eContainer() != op) {
                    typeReference = (JvmTypeReference)EcoreUtil2.cloneWithProxies((EObject)typeReference);
                }
                JvmTypeReference jvmTypeReference = typeReference;
                return jvmTypeReference;
            }
            if (eObject instanceof JvmFormalParameter) {
                int index;
                JvmFormalParameter param = (JvmFormalParameter)eObject;
                JvmOperation op = (JvmOperation)param.eContainer();
                Multimap<Pair<String, Integer>, JvmOperation> dispatchMethods = this.dispatchingSupport.getDispatchMethods((JvmGenericType)op.getDeclaringType());
                Collection dispatchOperations = dispatchMethods.get((Object)Tuples.pair((Object)op.getSimpleName(), (Object)op.getParameters().size()));
                JvmTypeReference commonType = this.commonType(dispatchOperations, new Function<JvmOperation, JvmTypeReference>(index = op.getParameters().indexOf((Object)param)){
                    private final /* synthetic */ int val$index;
                    {
                        this.val$index = n;
                    }

                    public JvmTypeReference apply(JvmOperation from) {
                        return ((JvmFormalParameter)from.getParameters().get(this.val$index)).getParameterType();
                    }
                });
                if (commonType != null && commonType.eContainer() != null) {
                    commonType = (JvmTypeReference)EcoreUtil2.cloneWithProxies((EObject)commonType);
                }
                JvmTypeReference jvmTypeReference = commonType;
                return jvmTypeReference;
            }
            try {
                throw new IllegalStateException("couldn't resolve type proxy in " + eObject);
            }
            catch (RuntimeException e) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)e.getMessage(), (Throwable)e);
                }
                throw e;
            }
        }
        finally {
            this.computingFragments.remove(uriFragment);
        }
    }

    protected JvmTypeReference inferReturnType(JvmOperation jvmOperation) {
        ArrayList associatedReturnTypes = Lists.newArrayList();
        Iterable associatedElements = Iterables.filter((Iterable)this.associations.getSourceElements((EObject)jvmOperation), XtendFunction.class);
        boolean wasDispatch = false;
        for (XtendFunction func : associatedElements) {
            JvmTypeReference type = this.returnTypeProvider.computeReturnType(func);
            if (type != null && !(type instanceof JvmAnyTypeReference)) {
                associatedReturnTypes.add(type);
            }
            wasDispatch |= func.isDispatch();
        }
        if (wasDispatch) {
            if (jvmOperation.getSimpleName().startsWith("_")) {
                for (XtendFunction func : associatedElements) {
                    if (func.getReturnType() != null) {
                        return (JvmTypeReference)EcoreUtil2.cloneWithProxies((EObject)func.getReturnType());
                    }
                    JvmOperation overriddenOperation = this.overridesService.findOverriddenOperation(jvmOperation);
                    if (overriddenOperation != null) {
                        JvmTypeReference result = overriddenOperation.getReturnType();
                        return (JvmTypeReference)EcoreUtil2.cloneWithProxies((EObject)result);
                    }
                    JvmOperation dispatchOperation = this.associations.getDispatchOperation(func);
                    if (dispatchOperation == null) continue;
                    JvmTypeReference result = dispatchOperation.getReturnType();
                    return (JvmTypeReference)EcoreUtil2.cloneWithProxies((EObject)result);
                }
            } else {
                JvmOperation overriddenOperation = this.overridesService.findOverriddenOperation(jvmOperation);
                if (overriddenOperation != null) {
                    JvmTypeReference result = overriddenOperation.getReturnType();
                    return (JvmTypeReference)EcoreUtil2.cloneWithProxies((EObject)result);
                }
            }
        }
        if (!associatedReturnTypes.isEmpty()) {
            JvmTypeReference commonSuperType = this.typeConformanceComputer.getCommonSuperType((List)associatedReturnTypes);
            return commonSuperType;
        }
        return null;
    }

    protected <T> JvmTypeReference commonType(Iterable<? extends T> iterable, Function<T, JvmTypeReference> mapping) {
        JvmTypeReference apply;
        ArrayList references = Lists.newArrayList();
        for (T element : iterable) {
            apply = (JvmTypeReference)mapping.apply(element);
            if (this.typeReferences.isNullOrProxy(apply) || this.typeReferences.is(apply, Void.class)) continue;
            references.add(apply);
        }
        if (references.isEmpty()) {
            for (T element : iterable) {
                apply = (JvmTypeReference)mapping.apply(element);
                if (this.typeReferences.isNullOrProxy(apply)) continue;
                references.add(apply);
            }
        }
        JvmTypeReference result = this.jvmTypeConformanceComputer.getCommonSuperType((List)references);
        while (result instanceof JvmMultiTypeReference) {
            result = this.jvmTypeConformanceComputer.getCommonSuperType((List)((JvmMultiTypeReference)result).getReferences());
        }
        return result;
    }
}

