/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.loggers.imagewriter.logger;

import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.ReferenceMap;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.DynamicNodeLabel;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLong;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProvider;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProviderAdapter;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProviderAdapterFactory;
import org.eclipse.stem.loggers.imagewriter.logger.projections.IMapProjection;

public class PolygonHandler {
    private static final Map<Class<? extends IMapProjection>, Map> cachedPolygons = new HashMap<Class<? extends IMapProjection>, Map>();

    private static final ProjectedPolygons getProjectedPolygons(IMapProjection projection, Identifiable identifiable, LatLong points) {
        ProjectedPolygons polygons = new ProjectedPolygons();
        polygons.identifiable = identifiable;
        if (points != null) {
            for (LatLong.Segment segment : points.getSegments()) {
                if (segment.size() <= 0) continue;
                int vertexCount = segment.size();
                Path2D.Float poly = new Path2D.Float(0, vertexCount);
                boolean started = false;
                int i = 0;
                while (i < vertexCount) {
                    double[] pt = projection.project(segment.latitude(i), segment.longitude(i));
                    if (pt != null) {
                        if (started) {
                            poly.lineTo(pt[1], -pt[0]);
                        } else {
                            poly.moveTo(pt[1], -pt[0]);
                            started = true;
                        }
                    }
                    ++i;
                }
                polygons.polygons.add(poly);
            }
        }
        if (polygons.polygons.size() < 1) {
            polygons = null;
        }
        return polygons;
    }

    public static ProjectedPolygons getPolygonsForProjection(IMapProjection projection, NodeLabel label) {
        Map projectionCache = cachedPolygons.get(projection.getClass());
        if (projectionCache == null) {
            projectionCache = new ReferenceMap(1, 1);
            cachedPolygons.put(projection.getClass(), projectionCache);
        }
        ProjectedPolygons retVal = null;
        Object obj = projectionCache.get(label.getIdentifiable().getURI());
        if (obj != null) {
            retVal = (ProjectedPolygons)obj;
            retVal.identifiable = label.getIdentifiable();
        } else {
            LatLongProviderAdapter latLongProvider = (LatLongProviderAdapter)LatLongProviderAdapterFactory.INSTANCE.adapt((Notifier)label.getIdentifiable(), LatLongProvider.class);
            LatLong latLong = latLongProvider.getLatLong();
            retVal = PolygonHandler.getProjectedPolygons(projection, label.getIdentifiable(), latLong);
            if (retVal != null) {
                projectionCache.put(label.getIdentifiable().getURI(), retVal);
            }
        }
        return retVal;
    }

    public static class ProjectedPolygons {
        public Identifiable identifiable;
        public List<Shape> polygons = new LinkedList<Shape>();
        public Rectangle2D bounds;
        public DynamicNodeLabel label;

        public Rectangle2D getBoundingBox() {
            Rectangle2D bounds = null;
            for (Shape p : this.polygons) {
                if (bounds == null) {
                    bounds = p.getBounds2D();
                    continue;
                }
                Rectangle2D shapeBounds = p.getBounds2D();
                bounds = bounds.createUnion(shapeBounds);
            }
            return bounds;
        }
    }
}

