/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.model.edit;

import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionDiffBuilder;
import org.eclipse.xtext.ide.serializer.IChangeSerializer;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.BatchModification;
import org.eclipse.xtext.ui.editor.model.edit.ICompositeModification;
import org.eclipse.xtext.ui.editor.model.edit.ICompositeModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.validation.Issue;

public class CompositeModificationWrapper
implements IModification,
BatchModification.IBatchableModification {
    private final Issue issue;
    private final ICompositeModification<EObject> modification;
    private boolean updateCrossReferences = true;
    private boolean updateRelatedFiles = true;

    public CompositeModificationWrapper(Issue issue, ICompositeModification<?> modification) {
        this.issue = issue;
        this.modification = modification;
    }

    @Override
    public void apply(EObject object, IChangeSerializer serializer) {
        this.modification.apply(object, new MultiModificationContext(object, serializer));
    }

    @Override
    public void apply(IModificationContext ctx) throws Exception {
        IXtextDocument document = ctx.getXtextDocument();
        BatchModification batch = (BatchModification)document.readOnly(r -> (BatchModification)r.getResourceServiceProvider().get(BatchModification.class));
        batch.setDocument(document);
        batch.apply(Collections.singleton(this), (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public URI getEObjectURI() {
        return this.issue.getUriToProblem();
    }

    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public boolean isUpdateCrossReferences() {
        return this.updateCrossReferences;
    }

    @Override
    public boolean isUpdateRelatedFiles() {
        return this.updateRelatedFiles;
    }

    public void setUpdateCrossReferences(boolean updateCrossReferences) {
        this.updateCrossReferences = updateCrossReferences;
    }

    public void setUpdateRelatedFiles(boolean updateRelatedFiles) {
        this.updateRelatedFiles = updateRelatedFiles;
    }

    public static class ModificationPart<T extends Notifier>
    implements IChangeSerializer.IModification<T> {
        private final T element;
        private final ICompositeModificationContext.IModificationPart<T> part;

        public ModificationPart(ICompositeModificationContext.IModificationPart<T> part, T element) {
            this.part = part;
            this.element = element;
        }

        public void apply() {
            this.part.apply(this.element);
        }

        public void modify(T context) {
            this.part.apply(context);
        }
    }

    protected class MultiModificationContext
    implements ICompositeModificationContext<EObject> {
        private final EObject element;
        private final IChangeSerializer serializer;

        public MultiModificationContext(EObject element, IChangeSerializer serializer) {
            this.element = element;
            this.serializer = serializer;
        }

        @Override
        public <N extends Notifier> void addModification(N toModify, ICompositeModificationContext.IModificationPart<N> modification) {
            this.serializer.addModification(toModify, new ModificationPart<N>(modification, toModify));
        }

        @Override
        public EObject getElement() {
            return this.element;
        }

        @Override
        public Issue getIssue() {
            return CompositeModificationWrapper.this.getIssue();
        }

        @Override
        public ITextRegionDiffBuilder getModifiableDocument(XtextResource resource) {
            return this.serializer.getModifiableDocument((Resource)resource);
        }

        @Override
        public boolean isUpdateCrossReferences() {
            return CompositeModificationWrapper.this.isUpdateCrossReferences();
        }

        @Override
        public boolean isUpdateRelatedFiles() {
            return CompositeModificationWrapper.this.isUpdateRelatedFiles();
        }

        @Override
        public void setUpdateCrossReferences(boolean value) {
            CompositeModificationWrapper.this.setUpdateCrossReferences(value);
        }

        @Override
        public void setUpdateRelatedFiles(boolean value) {
            CompositeModificationWrapper.this.setUpdateRelatedFiles(value);
        }
    }
}

