/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.graphsynchronizer.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.stem.graphsynchronizer.Activator;
import org.eclipse.stem.graphsynchronizer.util.CountryGraphPartitionPlanner;

public class SubCountryGraphPartitionPlanner {
    static int NUM_COUNTRIES = -1;
    static int NUM_LEVEL_1_IDS = -1;
    static int[][] level0CommonBorderMatrix = null;
    static int[][] level1CommonBorderMatrix = null;
    static final String STATS_FILE_0 = "worldPartioningStats.csv";
    static final String STATS_FILE_1 = "subCountryPartioningStats.csv";
    static final String CODES_FILE = "countryCodeMap.csv";
    private static final String URI_PREFIX = "platform:/plugin/org.eclipse.stem.data.geography/resources/data/statistics/";
    private static final URI CODES_FILE_URI = URI.createURI((String)"platform:/plugin/org.eclipse.stem.data.geography/resources/data/statistics/countryCodeMap.csv");
    private static final URI STATS_FILE_0_URI = URI.createURI((String)"platform:/plugin/org.eclipse.stem.data.geography/resources/data/statistics/worldPartioningStats.csv");
    private static final URI STATS_FILE_1_URI = URI.createURI((String)"platform:/plugin/org.eclipse.stem.data.geography/resources/data/statistics/subCountryPartioningStats.csv");
    static Map<String, String> regionCode2to3 = new HashMap<String, String>();
    static Map<String, String> regionCode3to2 = new HashMap<String, String>();
    static final List<Country> worldCountryList = new ArrayList<Country>();
    static final Map<String, Country> worldCountryMap = new HashMap<String, Country>();
    static final List<Region> worldStateList = new ArrayList<Region>();
    static final List<String> levelOneIDList = new ArrayList<String>();
    static final Map<String, Region> worldSubCountryMap = new HashMap<String, Region>();
    static final double DELTA_TOLLERANCE = 0.2;
    static double SIZE_MISSMATCH_TOLLERANCE = 1.2;

    public SubCountryGraphPartitionPlanner() {
        this.mapCodes();
        this.mapCountryStats();
        this.mapSubCountryStats();
    }

    public static void main(String[] args) {
        String[] test = new String[]{"AFG", "AGO", "AIA", "ALA", "ALB", "AND", "ANT", "ARE", "ARG", "ARM", "ASM", "ATA", "ATF", "ATG", "AUS", "AUT", "AZE", "BDI", "BEL", "BEN", "BFA", "BGD", "BGR", "BHR", "BHS", "BIH", "BLR", "BLZ", "BMU", "BOL", "BRA", "BRB", "BRN", "BTN", "BVT", "BWA", "CAF", "CAN", "CCK", "CHE", "CHL", "CHN", "CIV", "CMR", "COD", "COG", "COK", "COL", "COM", "CPV", "CRI", "CUB", "CXR", "CYM", "CYP", "CZE", "DEU", "DJI", "DMA", "DNK", "DOM", "DZA", "ECU", "EGY", "ERI", "ESH", "ESP", "EST", "ETH", "FIN", "FJI", "FLK", "FRA", "FRO", "FSM", "GAB", "GBR", "GEO", "GGY", "GHA", "GIB", "GIN", "GLP", "GMB", "GNB", "GNQ", "GRC", "GRD", "GRL", "GTM", "GUF", "GUM", "GUY", "HKG", "HMD", "HND", "HRV", "HTI", "HUN", "IDN", "IMN", "IND", "IOT", "IRL", "IRN", "IRQ", "ISL", "ISR", "ITA", "JAM", "JEY", "JOR", "JPN", "KAZ", "KEN", "KGZ", "KHM", "KIR", "KNA", "KOR", "KWT", "LAO", "LBN", "LBR", "LBY", "LCA", "LIE", "LKA", "LSO", "LTU", "LUX", "LVA", "MAC", "MAR", "MCO", "MDA", "MDG", "MDV", "MEX", "MHL", "MKD", "MLI", "MLT", "MMR", "MNE", "MNG", "MNP", "MOZ", "MRT", "MSR", "MTQ", "MUS", "MWI", "MYS", "MYT", "NAM", "NCL", "NER", "NFK", "NGA", "NIC", "NIU", "NLD", "NOR", "NPL", "NRU", "NZL", "OMN", "PAK", "PAN", "PCN", "PER", "PHL", "PLW", "PNG", "POL", "PRI", "PRK", "PRT", "PRY", "PSE", "PYF", "QAT", "REU", "ROU", "RUS", "RWA", "SAU", "SDN", "SEN", "SGP", "SGS", "SHN", "SJM", "SLB", "SLE", "SLV", "SMR", "SOM", "SPM", "SRB", "STP", "SUR", "SVK", "SVN", "SWE", "SWZ", "SYC", "SYR", "TCA", "TCD", "TGO", "THA", "TJK", "TKL", "TKM", "TLS", "TMP", "TON", "TTO", "TUN", "TUR", "TUV", "TWN", "TZA", "UGA", "UKR", "UMI", "URY", "USA", "UZB", "VAT", "VCT", "VEN", "VGB", "VIR", "VNM", "VUT", "WLF", "WSM", "YEM", "ZAF", "ZMB", "ZWE"};
        HashSet<String> testSet = new HashSet<String>();
        int i = 0;
        while (i < test.length) {
            testSet.add(test[i]);
            ++i;
        }
        SubCountryGraphPartitionPlanner subCtryPartionPlanner = new SubCountryGraphPartitionPlanner();
        int numServers = 7;
        List<PartitionGroup> initialPlan = subCtryPartionPlanner.getInitialCountryLevelPlan(numServers, testSet);
        List<PartitionGroup> plan = subCtryPartionPlanner.relaxPartitionPlan(initialPlan);
        List<Set<String>> planCodes = subCtryPartionPlanner.planAsCodeStrings(plan);
        Activator.logInformation("planning complete.... assignments are:");
        int allNodes = 0;
        int i2 = 0;
        while (i2 < plan.size()) {
            PartitionGroup pg = plan.get(i2);
            Set<String> regionSet = planCodes.get(i2);
            Set<Region> regionS = pg.regionGroup;
            for (Region r : regionS) {
                allNodes += r.numNodes;
            }
            double surface = pg.countUnresolvedBorderEdges();
            int totalNodes = pg.getTotalNodes();
            double surfaceToVolume = surface / (double)totalNodes;
            Activator.logInformation("server number: " + i2 + "  size is [" + totalNodes + "] external Edges = " + (int)surface + " surfaceToVolumeRatio= " + surfaceToVolume);
            String s = "";
            int icount = 0;
            Object[] rgns = regionSet.toArray(new String[regionSet.size()]);
            Arrays.sort(rgns);
            Object[] objectArray = rgns;
            int n = rgns.length;
            int n2 = 0;
            while (n2 < n) {
                Object region = objectArray[n2];
                s = String.valueOf(s) + (String)region + "  ";
                if (++icount % 25 == 0) {
                    s = String.valueOf(s) + "\n  ";
                }
                ++n2;
            }
            ++i2;
        }
        Activator.logInformation("total nodeCount = " + allNodes);
        int[][] pgMatrix = SubCountryGraphPartitionPlanner.getPartitionGroupBorderMatrix(plan);
        Activator.logInformation("");
        Activator.logInformation("");
        Activator.logInformation("PartitionGroup Matrix");
        Activator.logInformation("");
        int i3 = 0;
        while (i3 < plan.size()) {
            String s = "";
            int j = 0;
            while (j < plan.size()) {
                if (pgMatrix[i3][j] < 10) {
                    s = String.valueOf(s) + " ";
                }
                if (pgMatrix[i3][j] < 100) {
                    s = String.valueOf(s) + " ";
                }
                s = String.valueOf(s) + pgMatrix[i3][j] + "  ";
                ++j;
            }
            Activator.logInformation(s);
            ++i3;
        }
    }

    public List<PartitionGroup> getPlan(int numServers, Set<String> countries) {
        HashSet<String> regions = new HashSet<String>();
        for (String threeLetterID : countries) {
            String twoLetterPrefix = regionCode3to2.get(threeLetterID);
            int i = 0;
            while (i < levelOneIDList.size()) {
                String levelOneID = levelOneIDList.get(i);
                if (twoLetterPrefix != null && levelOneID.indexOf(twoLetterPrefix) >= 0) {
                    regions.add(levelOneID);
                }
                if (levelOneID.equalsIgnoreCase(threeLetterID)) {
                    regions.add(threeLetterID);
                }
                ++i;
            }
        }
        if (numServers > regions.size()) {
            numServers = regions.size();
            Activator.logInformation("CountryGraphPatitionPlanner.getPlan(): Warning, number of servers can not exceed number of countries. Using " + numServers + " servers for now.");
        }
        ArrayList<PartitionGroup> partitionPlan = new ArrayList<PartitionGroup>();
        int i = 0;
        while (i < numServers) {
            PartitionGroup partitionGroup = new PartitionGroup();
            partitionPlan.add(partitionGroup);
            ++i;
        }
        HashSet<String> unassignedSet = new HashSet<String>();
        unassignedSet.addAll(regions);
        Region[] unassignedRegions = this.getSortedRegions(unassignedSet);
        int totalProblemSize = 0;
        int i2 = 0;
        while (i2 < unassignedRegions.length) {
            totalProblemSize += unassignedRegions[i2].numNodes;
            ++i2;
        }
        Activator.logInformation("CountryGraphPatitionPlanner.getPlan(): total problem size = " + totalProblemSize);
        double targetGroupSizeD = totalProblemSize / numServers;
        Activator.logInformation("CountryGraphPatitionPlanner.getPlan(): IDEAL target partition size = " + Math.round(targetGroupSizeD));
        int targetGroupSize = (int)Math.round(targetGroupSizeD *= SIZE_MISSMATCH_TOLLERANCE);
        Activator.logInformation("CountryGraphPatitionPlanner.getPlan(): Planning for max target partition size ~= " + targetGroupSize);
        Object[] parents = this.getSortedCountries(worldCountryList);
        Arrays.sort(parents);
        int i3 = 0;
        while (i3 < numServers) {
            PartitionGroup partitionGroup = (PartitionGroup)partitionPlan.get(i3);
            String nextLargestCountry = ((Country)parents[i3]).threeLetterCode;
            Region[] unassigned = this.getSortedRegions(unassignedSet);
            Region seedRegion = null;
            int j = 0;
            while (j < unassigned.length) {
                seedRegion = unassigned[j];
                if (seedRegion.parentCountryCode.equalsIgnoreCase(nextLargestCountry)) {
                    partitionGroup.add(seedRegion);
                    Activator.logInformation(i3 + ": seeding with  " + seedRegion.regionID + " inside country " + nextLargestCountry);
                    unassignedSet.remove(seedRegion);
                }
                ++j;
            }
            ++i3;
        }
        double progress = 0.0;
        while (unassignedSet.size() > 0) {
            if (progress % 100.0 == 0.0) {
                Activator.logInformation("      " + unassignedSet.size() + " regions remaining to be assigned");
            }
            progress += 1.0;
            Region[] regionsToProcess = this.getSortedRegions(unassignedSet);
            Region regionToAssign = null;
            PartitionGroup destinationGroup = null;
            double minFactor = Double.MAX_VALUE;
            int i4 = 0;
            while (i4 < partitionPlan.size()) {
                PartitionGroup pg = (PartitionGroup)partitionPlan.get(i4);
                pg.nextCandidateMember = null;
                if (pg.getTotalNodes() < targetGroupSize) {
                    Region[] regionArray = regionsToProcess;
                    int n = regionsToProcess.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Region candidate = regionArray[n2];
                        double worstCaseLoadThisCandidateThisPlan = Double.MIN_VALUE;
                        int j = 0;
                        while (j < partitionPlan.size()) {
                            if (j != i4) {
                                PartitionGroup pgOther = (PartitionGroup)partitionPlan.get(j);
                                double load = this.getCommunicationsLoadFactor(candidate, pgOther.regionGroup, pg.regionGroup);
                                if (load > worstCaseLoadThisCandidateThisPlan) {
                                    worstCaseLoadThisCandidateThisPlan = load;
                                }
                            }
                            ++j;
                        }
                        if (worstCaseLoadThisCandidateThisPlan < minFactor) {
                            minFactor = worstCaseLoadThisCandidateThisPlan;
                            regionToAssign = candidate;
                            destinationGroup = pg;
                        }
                        ++n2;
                    }
                }
                ++i4;
            }
            if (regionToAssign != null && destinationGroup != null) {
                destinationGroup.add(regionToAssign);
                unassignedSet.remove(regionToAssign.regionID);
            }
            if (unassignedSet.size() == 0) break;
        }
        return partitionPlan;
    }

    public List<PartitionGroup> getInitialCountryLevelPlan(int numServers, Set<String> countries) {
        Activator.logInformation("1. Getting initial Country Level Plan");
        CountryGraphPartitionPlanner cgpp = new CountryGraphPartitionPlanner();
        List<CountryGraphPartitionPlanner.PartitionGroup> initialPlan = cgpp.getPlan(numServers, countries);
        List<Set<String>> initialPlanCountrySet = cgpp.planAsCodeStrings(initialPlan);
        if (numServers > initialPlanCountrySet.size()) {
            numServers = initialPlanCountrySet.size();
            Activator.logInformation("CountryGraphPatitionPlanner.getPlan(): Warning, number of servers can not exceed number of countries. Using " + numServers + " servers for now.");
        }
        Activator.logInformation("2. Executing initial Country Level Plan by level 1 regions");
        int partitionCount = 0;
        ArrayList<PartitionGroup> partitionPlan = new ArrayList<PartitionGroup>();
        for (Set<String> countrySet : initialPlanCountrySet) {
            PartitionGroup partitionGroup = new PartitionGroup();
            partitionPlan.add(partitionGroup);
            Activator.logInformation("");
            System.out.print("Partition " + partitionCount + " adding ");
            ++partitionCount;
            for (String threeLetterID : countrySet) {
                System.out.print(" " + threeLetterID);
                String twoLetterPrefix = regionCode3to2.get(threeLetterID);
                int i = 0;
                while (i < levelOneIDList.size()) {
                    Region region;
                    String levelOneID = levelOneIDList.get(i);
                    if (twoLetterPrefix != null && levelOneID.indexOf(twoLetterPrefix) == 0) {
                        region = worldSubCountryMap.get(levelOneID);
                        partitionGroup.add(region);
                    }
                    if (levelOneID.equalsIgnoreCase(threeLetterID)) {
                        region = worldSubCountryMap.get(levelOneID);
                        partitionGroup.add(region);
                    }
                    ++i;
                }
            }
        }
        return partitionPlan;
    }

    public List<PartitionGroup> relaxPartitionPlan(List<PartitionGroup> partitionPlan) {
        int problemSize = 0;
        int i = 0;
        while (i < partitionPlan.size()) {
            PartitionGroup pg = partitionPlan.get(i);
            problemSize += pg.getTotalNodes();
            ++i;
        }
        double idealTargetSize = problemSize / partitionPlan.size();
        SIZE_MISSMATCH_TOLLERANCE = 1.2;
        int outer = 0;
        while (outer < 500) {
            Object[] sortedPlans = partitionPlan.toArray(new PartitionGroup[partitionPlan.size()]);
            Arrays.sort(sortedPlans);
            int inner = 0;
            while (inner < 10) {
                int i2 = 0;
                while (i2 < sortedPlans.length) {
                    Object currentGroup = sortedPlans[i2];
                    int planSize = ((PartitionGroup)currentGroup).getTotalNodes();
                    if ((double)planSize > idealTargetSize * SIZE_MISSMATCH_TOLLERANCE) {
                        int pickIndex = i2;
                        double maxExternalArea = Double.MIN_VALUE;
                        Region regionToMove = null;
                        PartitionGroup groupToMoveTo = null;
                        for (Region candidate : ((PartitionGroup)currentGroup).regionGroup) {
                            int j = 0;
                            while (j < partitionPlan.size()) {
                                double load;
                                PartitionGroup otherGroup;
                                if (j != pickIndex && (double)(otherGroup = partitionPlan.get(j)).getTotalNodes() <= idealTargetSize && (load = this.getCommunicationsLoadFactor(candidate, otherGroup.regionGroup, ((PartitionGroup)currentGroup).regionGroup)) > maxExternalArea) {
                                    maxExternalArea = load;
                                    regionToMove = candidate;
                                    groupToMoveTo = otherGroup;
                                }
                                ++j;
                            }
                        }
                        if (regionToMove != null && groupToMoveTo != null) {
                            ((PartitionGroup)currentGroup).regionGroup.remove(regionToMove);
                            groupToMoveTo.regionGroup.add(regionToMove);
                        }
                    } else if ((double)planSize < idealTargetSize / SIZE_MISSMATCH_TOLLERANCE) {
                        Object groupToMoveTo = currentGroup;
                        PartitionGroup groupToMoveFrom = null;
                        Region regionToMove = null;
                        int maxArea = -1;
                        int pickIndex = i2;
                        int j = 0;
                        while (j < partitionPlan.size()) {
                            PartitionGroup otherGroup;
                            if (j != pickIndex && (double)(otherGroup = partitionPlan.get(j)).getTotalNodes() > idealTargetSize * SIZE_MISSMATCH_TOLLERANCE) {
                                for (Region candidate : otherGroup.regionGroup) {
                                    int area = ((PartitionGroup)groupToMoveTo).getSurfaceArea(candidate);
                                    if (area <= maxArea) continue;
                                    regionToMove = candidate;
                                    groupToMoveFrom = otherGroup;
                                }
                            }
                            ++j;
                        }
                        if (regionToMove != null && groupToMoveFrom != null) {
                            groupToMoveFrom.regionGroup.remove(regionToMove);
                            ((PartitionGroup)groupToMoveTo).regionGroup.add(regionToMove);
                        }
                    }
                    ++i2;
                }
                ++inner;
            }
            ++outer;
        }
        return partitionPlan;
    }

    public double getCommunicationsLoadFactor(Region candidate, Set<Region> outsideRegions, Set<Region> homeRegions) {
        double ratio;
        double factor = Double.MIN_VALUE;
        double outSideSurfaceArea = 0.0;
        for (Region region : outsideRegions) {
            outSideSurfaceArea += (double)level1CommonBorderMatrix[candidate.index][region.index];
        }
        double inSideSurfaceArea = 0.0;
        for (Region region : homeRegions) {
            inSideSurfaceArea += (double)level1CommonBorderMatrix[candidate.index][region.index];
        }
        if (inSideSurfaceArea <= 0.0) {
            inSideSurfaceArea = 0.01;
        }
        if (outSideSurfaceArea == 0.0) {
            outSideSurfaceArea = 0.1;
        }
        if ((ratio = outSideSurfaceArea / inSideSurfaceArea) > factor) {
            factor = ratio;
        }
        return factor;
    }

    public int getLargestGroupIndex(List<PartitionGroup> partitionPlan) {
        int pickIndex = 0;
        int maxSize = -1;
        int i = 0;
        while (i < partitionPlan.size()) {
            PartitionGroup pg = partitionPlan.get(i);
            int numNodes = pg.getTotalNodes();
            if (numNodes > maxSize) {
                maxSize = numNodes;
                pickIndex = i;
            }
            ++i;
        }
        Activator.logInformation("**** choosing " + pickIndex + " size = " + maxSize);
        return pickIndex;
    }

    public List<Set<String>> planAsCodeStrings(List<PartitionGroup> partitionPlan) {
        ArrayList<Set<String>> planList = new ArrayList<Set<String>>();
        int i = 0;
        while (i < partitionPlan.size()) {
            PartitionGroup pg = partitionPlan.get(i);
            planList.add(pg.getRegionCodes());
            ++i;
        }
        return planList;
    }

    public int getSmallestGroupIndex(List<PartitionGroup> partitionPlan) {
        int smallest = Integer.MAX_VALUE;
        int index = -1;
        int i = 0;
        while (i < partitionPlan.size()) {
            PartitionGroup pg = partitionPlan.get(i);
            int totalNodes = pg.getTotalNodes();
            if (totalNodes < smallest) {
                smallest = totalNodes;
                index = i;
            }
            ++i;
        }
        return index;
    }

    public Region[] getSortedRegions(Set<String> regionSet) {
        Object[] sortedRegions = new Region[regionSet.size()];
        int icount = 0;
        for (String region : regionSet) {
            Region r = worldSubCountryMap.get(region);
            if (r == null) {
                System.err.println("Unable to find region " + region);
            }
            sortedRegions[icount] = r;
            ++icount;
        }
        Arrays.sort(sortedRegions);
        return sortedRegions;
    }

    public Country[] getSortedCountries(List<Country> countryList) {
        Object[] sortedCountries = countryList.toArray(new Country[countryList.size()]);
        Arrays.sort(sortedCountries);
        return sortedCountries;
    }

    public String[] getSortedCountryNames(List<Country> countryList) {
        Object[] sortedCountries = new String[countryList.size()];
        int icount = 0;
        for (Country ctry : countryList) {
            sortedCountries[icount] = ctry.threeLetterCode;
            ++icount;
        }
        Arrays.sort(sortedCountries);
        return sortedCountries;
    }

    public int getAdminLevel(String stemid) {
        String[] splitID = stemid.split("-");
        if (splitID.length == 4) {
            return 3;
        }
        if (splitID.length == 3) {
            return 2;
        }
        if (splitID.length == 2) {
            return 1;
        }
        return splitID.length - 1;
    }

    private InputStream getInputStreamForURI(URI uri) throws IOException {
        return new ExtensibleURIConverterImpl().createInputStream(uri);
    }

    public void mapCodes() {
        BufferedReader d = null;
        try {
            try {
                String record;
                d = new BufferedReader(new InputStreamReader(this.getInputStreamForURI(CODES_FILE_URI)));
                while ((record = d.readLine()) != null) {
                    StringTokenizer st = new StringTokenizer(record);
                    String name = st.nextToken(",");
                    String twoLetter = st.nextToken(",");
                    String threeLetter = st.nextToken(",");
                    regionCode2to3.put(twoLetter, threeLetter);
                    regionCode3to2.put(threeLetter, twoLetter);
                }
            }
            catch (IOException e) {
                Activator.logInformation(" IOException error!" + e.getMessage());
                try {
                    d.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                d.close();
            }
            catch (Exception exception) {}
        }
    }

    public void mapCountryStats() {
        int index = 0;
        BufferedReader d = null;
        try {
            try {
                String record;
                d = new BufferedReader(new InputStreamReader(this.getInputStreamForURI(STATS_FILE_0_URI)));
                while ((record = d.readLine()) != null) {
                    StringTokenizer st = new StringTokenizer(record, ",");
                    String threeLetter = st.nextToken();
                    int numNodes = new Integer(st.nextToken().trim());
                    String twoLetter = regionCode3to2.get(threeLetter);
                    Country country = new Country(threeLetter, twoLetter, index, numNodes);
                    worldCountryList.add(index, country);
                    worldCountryMap.put(threeLetter, country);
                    ++index;
                }
                level0CommonBorderMatrix = new int[worldCountryList.size()][worldCountryList.size()];
                Activator.logInformation("read " + index + " countries and their sizes");
            }
            catch (IOException e) {
                Activator.logInformation(" IOException error!" + e.getMessage());
                try {
                    d.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                d.close();
            }
            catch (Exception exception) {}
        }
    }

    public void mapSubCountryStats() {
        int levelOneCount = 0;
        BufferedReader d = null;
        try {
            try {
                String record;
                d = new BufferedReader(new InputStreamReader(this.getInputStreamForURI(STATS_FILE_1_URI)));
                while ((record = d.readLine()) != null) {
                    StringTokenizer st = new StringTokenizer(record, ",");
                    String levelOneID = st.nextToken();
                    int numNodes = new Integer(st.nextToken().trim());
                    if (level1CommonBorderMatrix == null) {
                        NUM_LEVEL_1_IDS = st.countTokens();
                        level1CommonBorderMatrix = new int[NUM_LEVEL_1_IDS][NUM_LEVEL_1_IDS];
                    }
                    int i = 0;
                    while (i < NUM_LEVEL_1_IDS) {
                        int val;
                        SubCountryGraphPartitionPlanner.level1CommonBorderMatrix[levelOneCount][i] = val = new Integer(st.nextToken().trim()).intValue();
                        ++i;
                    }
                    String level0Code = "";
                    int lvl = this.getAdminLevel(levelOneID);
                    if (lvl == 0) {
                        level0Code = levelOneID;
                    } else {
                        String twoLetter = levelOneID.substring(0, 2);
                        level0Code = regionCode2to3.get(twoLetter);
                    }
                    Country ctry = worldCountryMap.get(level0Code);
                    if (ctry == null) {
                        Activator.logInformation("Error, ctry = null for level0Code= " + level0Code);
                        System.exit(1);
                    }
                    Region region = new Region(levelOneID, levelOneCount, numNodes, ctry.threeLetterCode);
                    worldStateList.add(levelOneCount, region);
                    worldSubCountryMap.put(levelOneID, region);
                    levelOneIDList.add(levelOneID);
                    ++levelOneCount;
                }
                Activator.logInformation("read matrix " + levelOneCount + " x " + NUM_LEVEL_1_IDS);
                if (levelOneCount != NUM_LEVEL_1_IDS) {
                    Activator.logInformation("FAIL " + levelOneCount + " != " + NUM_LEVEL_1_IDS);
                    System.exit(1);
                }
            }
            catch (IOException e) {
                Activator.logInformation(" IOException error!" + e.getMessage());
                try {
                    d.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                d.close();
            }
            catch (Exception exception) {}
        }
    }

    public void checkSumCountryStats() {
        int j;
        String[] world = this.getSortedCountryNames(worldCountryList);
        int i = 0;
        while (i < world.length) {
            int j2 = 0;
            while (j2 < world.length) {
                SubCountryGraphPartitionPlanner.level0CommonBorderMatrix[i][j2] = 0;
                ++j2;
            }
            ++i;
        }
        i = 0;
        while (i < worldStateList.size()) {
            int ii = SubCountryGraphPartitionPlanner.getCountryIndex(SubCountryGraphPartitionPlanner.worldStateList.get((int)i).parentCountryCode, world);
            j = 0;
            while (j < worldStateList.size()) {
                int jj = SubCountryGraphPartitionPlanner.getCountryIndex(SubCountryGraphPartitionPlanner.worldStateList.get((int)j).parentCountryCode, world);
                if (ii != jj) {
                    int[] nArray = level0CommonBorderMatrix[ii];
                    int n = jj;
                    nArray[n] = nArray[n] + level1CommonBorderMatrix[i][j];
                }
                ++j;
            }
            ++i;
        }
        Activator.logInformation("");
        Activator.logInformation("CheckSum for Stats Martix - compressed by country");
        Activator.logInformation("");
        i = 0;
        while (i < world.length) {
            String s = String.valueOf(world[i]) + "  ";
            j = 0;
            while (j < 25) {
                if (level0CommonBorderMatrix[i][j] < 10) {
                    s = String.valueOf(s) + " ";
                }
                if (level0CommonBorderMatrix[i][j] < 100) {
                    s = String.valueOf(s) + " ";
                }
                s = String.valueOf(s) + level0CommonBorderMatrix[i][j] + "  ";
                ++j;
            }
            Activator.logInformation(s);
            ++i;
        }
        Activator.logInformation("");
        Activator.logInformation("CheckSum for Stats Martix - compressed by country");
        Activator.logInformation("");
        System.exit(0);
    }

    public static int getCountryIndex(String threeLetterCode, String[] world) {
        int i = 0;
        while (i < world.length) {
            if (world[i].equalsIgnoreCase(threeLetterCode)) {
                return i;
            }
            ++i;
        }
        Activator.logInformation("Error mapping country index");
        System.exit(1);
        return -1;
    }

    public static int[][] getPartitionGroupBorderMatrix(List<PartitionGroup> masterList) {
        int numGroups = masterList.size();
        int[][] matrix = new int[numGroups][numGroups];
        int i = 0;
        while (i < numGroups) {
            PartitionGroup pgi = masterList.get(i);
            int j = 0;
            while (j < numGroups) {
                matrix[i][j] = 0;
                if (i != j) {
                    PartitionGroup pgj = masterList.get(j);
                    for (Region region : pgj.regionGroup) {
                        int[] nArray = matrix[i];
                        int n = j;
                        nArray[n] = nArray[n] + pgi.getCommonBorderArea(region);
                    }
                }
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public class Country
    implements Comparable<Country> {
        String threeLetterCode;
        String twoLetterCode;
        int index;
        int numNodes;

        public Country(String threeLetterCode, String twoLetterCode, int index, int numNodes) {
            this.threeLetterCode = threeLetterCode;
            this.twoLetterCode = twoLetterCode;
            this.index = index;
            this.numNodes = numNodes;
        }

        @Override
        public int compareTo(Country other) {
            if (this.threeLetterCode.equalsIgnoreCase("PNG")) {
                return 1;
            }
            if (this.numNodes > other.numNodes) {
                return -1;
            }
            if (this.numNodes < other.numNodes) {
                return 1;
            }
            return 0;
        }
    }

    public class PartitionGroup
    implements Comparable<PartitionGroup> {
        Set<Region> regionGroup = new HashSet<Region>();
        Region nextCandidateMember = null;

        Set<String> getRegionCodes() {
            HashSet<String> planSet = new HashSet<String>();
            for (Region region : this.regionGroup) {
                planSet.add(region.regionID);
            }
            return planSet;
        }

        public int getTotalNodes() {
            int sum = 0;
            for (Region r : this.regionGroup) {
                sum += r.numNodes;
            }
            return sum;
        }

        public void add(Region region) {
            this.regionGroup.add(region);
        }

        public int getCommonBorderArea(Region other) {
            int surfaceArea = 0;
            for (Region region : this.regionGroup) {
                surfaceArea += level1CommonBorderMatrix[region.index][other.index];
            }
            return surfaceArea;
        }

        public int countUnresolvedBorderEdges() {
            int surfaceArea = 0;
            for (Region region : this.regionGroup) {
                int j = 0;
                while (j < NUM_LEVEL_1_IDS) {
                    Region target;
                    if (j != region.index && !this.regionGroup.contains(target = worldStateList.get(j))) {
                        surfaceArea += level1CommonBorderMatrix[j][region.index];
                    }
                    ++j;
                }
            }
            return surfaceArea;
        }

        public int getSurfaceArea(Region candidate) {
            int surfaceArea = 0;
            for (Region region : this.regionGroup) {
                surfaceArea += level1CommonBorderMatrix[candidate.index][region.index];
            }
            return surfaceArea;
        }

        @Override
        public int compareTo(PartitionGroup other) {
            int otherSize;
            int thisSize = this.getTotalNodes();
            if (thisSize < (otherSize = other.getTotalNodes())) {
                return 1;
            }
            if (thisSize > otherSize) {
                return -1;
            }
            return 0;
        }
    }

    public class Region
    implements Comparable<Region> {
        String regionID;
        int index;
        int numNodes;
        String parentCountryCode;

        public Region(String regionID, int index, int numNodes, String parentCountry) {
            this.regionID = regionID;
            this.index = index;
            this.numNodes = numNodes;
            this.parentCountryCode = parentCountry;
        }

        @Override
        public int compareTo(Region other) {
            if (this.regionID.equalsIgnoreCase("PNG")) {
                return 1;
            }
            if (this.numNodes > other.numNodes) {
                return -1;
            }
            if (this.numNodes < other.numNodes) {
                return 1;
            }
            return 0;
        }
    }
}

