/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;

public class ReopenUtil {
    private static final String STATE = "state";
    private static final String REOPEN = "reopen";

    public static boolean isReopenPreferenceInitialized() {
        return ReopenUtil.readMemento() != null;
    }

    public static void setReopenPreference(boolean reopen) {
        XMLMemento memento = XMLMemento.createWriteRoot((String)STATE);
        memento.putBoolean(REOPEN, reopen);
        ReopenUtil.saveMemento(memento);
    }

    public static boolean isReopenPreference() {
        XMLMemento memento = ReopenUtil.readMemento();
        if (memento == null) {
            return false;
        }
        return memento.getBoolean(REOPEN);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static XMLMemento readMemento() {
        File stateFile = ReopenUtil.getStateFile();
        try {
            Throwable throwable = null;
            Object var3_3 = null;
            try {
                XMLMemento memento;
                FileInputStream input = new FileInputStream(stateFile);
                try {
                    try (InputStreamReader reader = new InputStreamReader((InputStream)input, StandardCharsets.UTF_8);){
                        memento = XMLMemento.createReadRoot((Reader)reader);
                    }
                    if (input == null) return memento;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (input == null) throw throwable;
                    input.close();
                    throw throwable;
                }
                input.close();
                return memento;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void saveMemento(XMLMemento memento) {
        File stateFile = ReopenUtil.getStateFile();
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                FileOutputStream stream = new FileOutputStream(stateFile);
                try {
                    try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);){
                        memento.save((Writer)writer);
                    }
                    if (stream == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (stream == null) throw throwable;
                    stream.close();
                    throw throwable;
                }
                stream.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            stateFile.delete();
        }
    }

    private static File getStateFile() {
        IPath path = IntroPlugin.getDefault().getStateLocation();
        path = path.append("introstate");
        File stateFile = path.toFile();
        return stateFile;
    }
}

