/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder;

import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.builder.EclipseResourceFileSystemAccess2;
import org.eclipse.xtext.generator.AbstractFileSystemAccess;
import org.eclipse.xtext.generator.FileSystemAccessQueue;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.util.RuntimeIOException;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ParallelFileSystemAccess
implements IFileSystemAccess2 {
    private final IFileSystemAccess2 delegate;
    private final IResourceDescription.Delta delta;
    private final FileSystemAccessQueue fileSystemAccessQueue;
    private final String sourceFolder;
    private final EclipseResourceFileSystemAccess2.IFileCallback fileCallback;

    @FinalFieldsConstructor
    public ParallelFileSystemAccess(IFileSystemAccess2 delegate, IResourceDescription.Delta delta, FileSystemAccessQueue fileSystemAccessQueue, String sourceFolder, EclipseResourceFileSystemAccess2.IFileCallback fileCallback) {
        this.delegate = delegate;
        this.delta = delta;
        this.fileSystemAccessQueue = fileSystemAccessQueue;
        this.sourceFolder = sourceFolder;
        this.fileCallback = fileCallback;
    }

    protected void sendAsync(Procedures.Procedure1<? super IFileSystemAccess2> procedure) {
        Runnable _function = () -> {
            if (this.delegate instanceof EclipseResourceFileSystemAccess2) {
                ((EclipseResourceFileSystemAccess2)this.delegate).setPostProcessor(this.fileCallback);
            }
            if (this.sourceFolder != null && this.delegate instanceof AbstractFileSystemAccess) {
                ((AbstractFileSystemAccess)this.delegate).setCurrentSource(this.sourceFolder);
            }
            procedure.apply((Object)this.delegate);
        };
        this.fileSystemAccessQueue.sendAsync(this.delta.getUri(), _function);
    }

    public void deleteFile(String fileName) {
        Procedures.Procedure1 _function = it -> it.deleteFile(fileName);
        this.sendAsync((Procedures.Procedure1<? super IFileSystemAccess2>)_function);
    }

    public void generateFile(String fileName, CharSequence contents) {
        Procedures.Procedure1 _function = it -> it.generateFile(fileName, contents);
        this.sendAsync((Procedures.Procedure1<? super IFileSystemAccess2>)_function);
    }

    public void generateFile(String fileName, String outputConfigurationName, CharSequence contents) {
        Procedures.Procedure1 _function = it -> it.generateFile(fileName, outputConfigurationName, contents);
        this.sendAsync((Procedures.Procedure1<? super IFileSystemAccess2>)_function);
    }

    public void deleteFile(String fileName, String outputConfigurationName) {
        Procedures.Procedure1 _function = it -> it.deleteFile(fileName, outputConfigurationName);
        this.sendAsync((Procedures.Procedure1<? super IFileSystemAccess2>)_function);
    }

    public URI getURI(String path, String outputConfiguration) {
        if (this.delegate instanceof EclipseResourceFileSystemAccess2) {
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            return ((EclipseResourceFileSystemAccess2)this.delegate).getURI(path, outputConfiguration, (IProgressMonitor)_nullProgressMonitor);
        }
        return this.delegate.getURI(path, outputConfiguration);
    }

    public URI getURI(String path) {
        if (this.delegate instanceof EclipseResourceFileSystemAccess2) {
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            return ((EclipseResourceFileSystemAccess2)this.delegate).getURI(path, (IProgressMonitor)_nullProgressMonitor);
        }
        return this.delegate.getURI(path);
    }

    public void generateFile(String fileName, String outputCfgName, InputStream content) throws RuntimeIOException {
        Procedures.Procedure1 _function = it -> it.generateFile(fileName, outputCfgName, content);
        this.sendAsync((Procedures.Procedure1<? super IFileSystemAccess2>)_function);
    }

    public void generateFile(String fileName, InputStream content) throws RuntimeIOException {
        Procedures.Procedure1 _function = it -> it.generateFile(fileName, content);
        this.sendAsync((Procedures.Procedure1<? super IFileSystemAccess2>)_function);
    }

    public InputStream readBinaryFile(String fileName, String outputCfgName) throws RuntimeIOException {
        if (this.delegate instanceof EclipseResourceFileSystemAccess2) {
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            return ((EclipseResourceFileSystemAccess2)this.delegate).readBinaryFile(fileName, outputCfgName, (IProgressMonitor)_nullProgressMonitor);
        }
        return this.delegate.readBinaryFile(fileName, outputCfgName);
    }

    public InputStream readBinaryFile(String fileName) throws RuntimeIOException {
        if (this.delegate instanceof EclipseResourceFileSystemAccess2) {
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            return ((EclipseResourceFileSystemAccess2)this.delegate).readBinaryFile(fileName, (IProgressMonitor)_nullProgressMonitor);
        }
        return this.delegate.readBinaryFile(fileName);
    }

    public CharSequence readTextFile(String fileName, String outputCfgName) throws RuntimeIOException {
        if (this.delegate instanceof EclipseResourceFileSystemAccess2) {
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            return ((EclipseResourceFileSystemAccess2)this.delegate).readTextFile(fileName, outputCfgName, (IProgressMonitor)_nullProgressMonitor);
        }
        return this.delegate.readTextFile(fileName, outputCfgName);
    }

    public CharSequence readTextFile(String fileName) throws RuntimeIOException {
        if (this.delegate instanceof EclipseResourceFileSystemAccess2) {
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            return ((EclipseResourceFileSystemAccess2)this.delegate).readTextFile(fileName, (IProgressMonitor)_nullProgressMonitor);
        }
        return this.delegate.readTextFile(fileName);
    }

    public boolean isFile(String path, String outputConfigurationName) throws RuntimeIOException {
        if (this.delegate instanceof EclipseResourceFileSystemAccess2) {
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            return ((EclipseResourceFileSystemAccess2)this.delegate).isFile(path, outputConfigurationName, (IProgressMonitor)_nullProgressMonitor);
        }
        return this.delegate.isFile(path, outputConfigurationName);
    }

    public boolean isFile(String path) throws RuntimeIOException {
        if (this.delegate instanceof EclipseResourceFileSystemAccess2) {
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            return ((EclipseResourceFileSystemAccess2)this.delegate).isFile(path, (IProgressMonitor)_nullProgressMonitor);
        }
        return this.delegate.isFile(path);
    }
}

