/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.stem.analysis.ErrorFunction;
import org.eclipse.stem.analysis.ErrorResult;
import org.eclipse.stem.analysis.LogInitializationException;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;
import org.eclipse.stem.analysis.util.CSVscenarioLoader;
import org.eclipse.stem.util.analysis.AggregateDataWriter;
import org.eclipse.stem.util.analysis.CSVAnalysisWriter;
import org.eclipse.stem.util.analysis.ErrorCalculator;
import org.eclipse.stem.util.analysis.LyapunovAnalysis;
import org.eclipse.stem.util.analysis.ModelParameters;
import org.eclipse.stem.util.analysis.ParameterEstimator;
import org.eclipse.stem.util.analysis.ParameterEstimatorMethod;
import org.eclipse.stem.util.analysis.PhaseSpaceCoordinate;
import org.eclipse.stem.util.analysis.ScenarioParameterEstimator;
import org.eclipse.stem.util.analysis.views.AnalysisControl;
import org.eclipse.stem.util.analysis.views.Messages;

public class ScenarioAnalysisSuite {
    public static final String REFERENCE_ROOT_DIRECTORY;
    public static String REFERENCE_TESTING_DIRECTORY;
    public static String REFERENCE_TESTING_AGGREGATE_FILE;
    private static String DEFAULT_AGGREGATE_FILENAME;
    private static String COMPARISON_FILE_NAME;
    public static final String NOT_FOUND_MSG;
    public static final String INVALID_DATA_MSG;
    public static final String DONE_MSG;
    public static final String READY_MSG;
    public static final String WORKING_MSG;
    ReferenceScenarioDataMapImpl referenceScenarioDataMap = null;
    ReferenceScenarioDataMapImpl comparisonScenarioDataMap = null;
    ScenarioParameterEstimator estimator = null;
    AnalysisControl control = null;

    static {
        REFERENCE_TESTING_DIRECTORY = REFERENCE_ROOT_DIRECTORY = AggregateDataWriter.ANALYSISFOLDER;
        REFERENCE_TESTING_AGGREGATE_FILE = String.valueOf(REFERENCE_ROOT_DIRECTORY) + File.separator + "aggregate" + File.separator + "aggregate.csv";
        DEFAULT_AGGREGATE_FILENAME = "aggregate";
        COMPARISON_FILE_NAME = "RMSComparisonResults";
        NOT_FOUND_MSG = Messages.getString("COMMON.NOTFOUND");
        INVALID_DATA_MSG = Messages.getString("COMMON.NOTDATA");
        DONE_MSG = Messages.getString("COMMON.DONE");
        READY_MSG = Messages.getString("COMMON.READY");
        WORKING_MSG = Messages.getString("COMMON.WORKING");
    }

    public ScenarioAnalysisSuite(AnalysisControl ctrl) {
        this.control = ctrl;
    }

    public String aggregateData(String folder, IRunnableContext runnableContext, double alpha) throws LogInitializationException {
        CSVscenarioLoader loader = new CSVscenarioLoader(folder);
        int maxResolution = loader.getMaxResolution("");
        ReferenceScenarioDataMapImpl map = loader.parseAllFiles("", maxResolution);
        String aggregateFileName = ScenarioAnalysisSuite.getAggregateFileName(folder);
        ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance aggregatedData = map.aggregateScenarioData(runnableContext);
        AggregateDataWriter writer = new AggregateDataWriter(folder, aggregateFileName);
        return writer.logDataInstance(aggregatedData, alpha);
    }

    public String aggregateByFilter(String referenceFolder, String folder, IRunnableContext runnableContext, double alpha) throws LogInitializationException {
        CSVscenarioLoader refLoader = new CSVscenarioLoader(referenceFolder);
        int maxRes = refLoader.getMaxResolution("");
        Set locationsToAggregate = refLoader.getLocations("", maxRes);
        CSVscenarioLoader loader = new CSVscenarioLoader(folder);
        int maxResolution = loader.getMaxResolution("");
        ReferenceScenarioDataMapImpl map = loader.parseAllFiles(locationsToAggregate, "", maxResolution);
        String aggregateFileName = ScenarioAnalysisSuite.getAggregateFileName(folder);
        ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance aggregatedData = map.aggregateScenarioData(runnableContext);
        AggregateDataWriter writer = new AggregateDataWriter(folder, aggregateFileName);
        return writer.logDataInstance(aggregatedData, alpha);
    }

    public ModelParameters estimateParameters(ReferenceScenarioDataMapImpl dataMap, ParameterEstimatorMethod parameterEstimatorMethod, IRunnableContext runnableContext) {
        this.referenceScenarioDataMap = dataMap;
        this.estimator = new ScenarioParameterEstimator(this.referenceScenarioDataMap, parameterEstimatorMethod);
        ModelParameters bestEstimate = new ModelParameters();
        boolean sumAllLocations = false;
        Map<String, Object> controlParametersMap = this.control.getControlParametersMap();
        if (controlParametersMap != null) {
            sumAllLocations = (Boolean)controlParametersMap.get("SUM_LOCATIONS");
        }
        if (sumAllLocations) {
            bestEstimate = this.estimator.averageThenEstimateParameters(controlParametersMap, runnableContext);
        } else {
            Map<String, ModelParameters> fittedParameters = this.estimator.estimateParameters(controlParametersMap, runnableContext);
            bestEstimate.average(fittedParameters);
        }
        return bestEstimate;
    }

    private static String getAggregateFileName(String dir) {
        int start = dir.lastIndexOf(File.separatorChar);
        String filename = DEFAULT_AGGREGATE_FILENAME;
        if (start >= 0) {
            filename = dir.substring(start + 1, dir.length());
        }
        filename = String.valueOf(filename) + ".csv";
        return filename;
    }

    public ErrorResult compare(String referenceDirectory, String comparisonDirectory, IRunnableContext runnableContext, ErrorFunction errorfunc) throws LogInitializationException {
        CSVscenarioLoader referenceLoader = new CSVscenarioLoader(referenceDirectory);
        String resultFile = COMPARISON_FILE_NAME;
        CSVAnalysisWriter resultWriter = new CSVAnalysisWriter(resultFile);
        HashMap<Map<String, String>, ErrorResult> result = new HashMap<Map<String, String>, ErrorResult>();
        this.compareRecursive(referenceLoader, comparisonDirectory, result, runnableContext, errorfunc);
        resultWriter.logData(result);
        resultWriter.flushLoggerData();
        resultWriter.closeLoggerData();
        double smallestError = Double.MAX_VALUE;
        ErrorResult returnError = null;
        for (Map.Entry entry : result.entrySet()) {
            ErrorResult res = (ErrorResult)entry.getValue();
            double error = 0.0;
            if (res != null) {
                error = res.getError();
            }
            if (!(error < smallestError)) continue;
            smallestError = error;
            returnError = res;
        }
        return returnError;
    }

    public String[] getKeys(String directory) throws LogInitializationException {
        CSVscenarioLoader referenceLoader = new CSVscenarioLoader(directory);
        ReferenceScenarioDataMapImpl dataMap = referenceLoader.parseAllFiles("", 1);
        return dataMap.getModelLabelKeys();
    }

    /*
     * Unable to fully structure code
     */
    public void compareRecursive(CSVscenarioLoader referenceLoader, String comparisonDirectory, Map<Map<String, String>, ErrorResult> result, IRunnableContext runnableContext, ErrorFunction errorfunc) throws LogInitializationException {
        block3: {
            try {
                comparisonLoader = new CSVscenarioLoader(comparisonDirectory);
                res = this._compare(referenceLoader, comparisonLoader, runnableContext, errorfunc);
                runParms = comparisonLoader.getRunParameters();
                result.put(runParms, res);
                break block3;
            }
            catch (LogInitializationException sie) {
                f = new File(comparisonDirectory);
                dirs = f.list();
                if (dirs == null) break block3;
                var12_12 = dirs;
                var11_13 = dirs.length;
                var10_14 = 0;
                ** while (var10_14 < var11_13)
            }
lbl-1000:
            // 1 sources

            {
                dir = var12_12[var10_14];
                this.compareRecursive(referenceLoader, String.valueOf(comparisonDirectory) + File.separator + dir, result, runnableContext, errorfunc);
                ++var10_14;
                continue;
            }
        }
    }

    private ErrorResult _compare(CSVscenarioLoader refLoader, CSVscenarioLoader compLoader, IRunnableContext runnableContext, ErrorFunction errorfunc) throws LogInitializationException {
        int maxComp;
        int maxRef = refLoader.getMaxResolution("");
        int actualRes = maxRef > (maxComp = compLoader.getMaxResolution("")) ? maxComp : maxRef;
        this.referenceScenarioDataMap = refLoader.parseAllFiles("", actualRes);
        this.comparisonScenarioDataMap = compLoader.parseAllFiles("", actualRes);
        ErrorCalculator msd = new ErrorCalculator(this.referenceScenarioDataMap, this.comparisonScenarioDataMap, errorfunc);
        ErrorResult result = msd.solve(runnableContext);
        return result;
    }

    public boolean validate(String directory) {
        return CSVscenarioLoader.validate((String)directory);
    }

    public List<PhaseSpaceCoordinate[]> getLyapunovTrajectory(String referenceDirectory, String comparisonDirectory, IRunnableContext runnableContext) throws LogInitializationException {
        int actualRes;
        CSVscenarioLoader refLoader = new CSVscenarioLoader(referenceDirectory);
        int maxRef = refLoader.getMaxResolution("");
        if (maxRef <= -1) {
            return null;
        }
        CSVscenarioLoader compLoader = new CSVscenarioLoader(comparisonDirectory);
        int maxComp = compLoader.getMaxResolution("");
        int n = actualRes = maxRef > maxComp ? maxComp : maxRef;
        if (actualRes <= -1) {
            return null;
        }
        this.referenceScenarioDataMap = refLoader.parseAllFiles("", actualRes);
        this.comparisonScenarioDataMap = compLoader.parseAllFiles("", actualRes);
        LyapunovAnalysis lyap = new LyapunovAnalysis(this.referenceScenarioDataMap, this.comparisonScenarioDataMap, runnableContext);
        List<PhaseSpaceCoordinate[]> retVal = lyap.getLyapunovTrajectory(runnableContext);
        return retVal;
    }

    public static List<EList<Double>> getCumulativePhaseSpaceDeviation(List<PhaseSpaceCoordinate[]> trajectoryList) {
        List<EList<Double>> deviation = LyapunovAnalysis.getCumulativePhaseSpaceDeviation(trajectoryList);
        return deviation;
    }

    public ParameterEstimator getEstimator() {
        return this.estimator.getEstimator();
    }
}

