/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import java.io.File;
import java.net.URI;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.internal.build.site.QualifierReplacer;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.exports.FeatureExportInfo;
import org.eclipse.pde.internal.core.exports.FeatureExportOperation;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.build.RuntimeInstallJob;
import org.eclipse.pde.internal.ui.wizards.exports.AntGeneratingExportWizard;
import org.eclipse.pde.internal.ui.wizards.exports.BaseExportWizardPage;
import org.eclipse.pde.internal.ui.wizards.exports.CrossPlatformExportPage;
import org.eclipse.pde.internal.ui.wizards.exports.FeatureExportWizardPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressConstants;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FeatureExportWizard
extends AntGeneratingExportWizard {
    private static final String STORE_SECTION = "FeatureExportWizard";
    private CrossPlatformExportPage fPage2;

    public FeatureExportWizard() {
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_FEATURE_EXPORT_WIZ);
    }

    @Override
    public void addPages() {
        super.addPages();
        FeatureModelManager manager = PDECore.getDefault().getFeatureModelManager();
        IFeatureModel model = manager.getDeltaPackFeature();
        if (model != null) {
            this.fPage2 = new CrossPlatformExportPage("environment", model);
            this.addPage((IWizardPage)this.fPage2);
        }
    }

    @Override
    protected BaseExportWizardPage createPage1() {
        return new FeatureExportWizardPage(this.getSelection());
    }

    @Override
    protected String getSettingsSectionName() {
        return STORE_SECTION;
    }

    @Override
    protected void scheduleExportJob() {
        boolean installAfterExport;
        final FeatureExportInfo info = new FeatureExportInfo();
        info.toDirectory = this.fPage.doExportToDirectory();
        info.useJarFormat = this.fPage.useJARFormat();
        info.exportSource = this.fPage.doExportSource();
        info.exportSourceBundle = this.fPage.doExportSourceBundles();
        info.allowBinaryCycles = this.fPage.allowBinaryCycles();
        info.useWorkspaceCompiledClasses = this.fPage.useWorkspaceCompiledClasses();
        info.destinationDirectory = this.fPage.getDestination();
        info.zipFileName = this.fPage.getFileName();
        if (this.fPage2 != null && ((FeatureExportWizardPage)this.fPage).doMultiPlatform()) {
            info.targets = this.fPage2.getTargets();
        }
        info.exportMetadata = ((FeatureExportWizardPage)this.fPage).doExportMetadata();
        info.items = this.fPage.getSelectedItems();
        info.signingInfo = this.fPage.getSigningInfo();
        info.jnlpInfo = ((FeatureExportWizardPage)this.fPage).getJNLPInfo();
        info.qualifier = this.fPage.getQualifier();
        if (((FeatureExportWizardPage)this.fPage).getCategoryDefinition() != null) {
            info.categoryDefinition = URIUtil.toUnencodedString((URI)((FeatureExportWizardPage)this.fPage).getCategoryDefinition());
        }
        if (installAfterExport = this.fPage.doInstall()) {
            info.useJarFormat = true;
            info.exportMetadata = true;
            if (info.qualifier == null) {
                info.qualifier = QualifierReplacer.getDateQualifier();
            }
        }
        final FeatureExportOperation job = new FeatureExportOperation(info, PDEUIMessages.FeatureExportJob_name);
        job.setUser(true);
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.setProperty(IProgressConstants.ICON_PROPERTY, (Object)PDEPluginImages.DESC_FEATURE_OBJ);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (job.hasAntErrors()) {
                    final File logLocation = new File(info.destinationDirectory, "logs.zip");
                    if (logLocation.exists()) {
                        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                AntGeneratingExportWizard.AntErrorDialog dialog = new AntGeneratingExportWizard.AntErrorDialog(logLocation);
                                dialog.open();
                            }
                        });
                    }
                } else if (event.getResult().isOK() && installAfterExport) {
                    RuntimeInstallJob installJob = new RuntimeInstallJob(PDEUIMessages.PluginExportWizard_InstallJobName, info);
                    installJob.setUser(true);
                    installJob.setProperty(IProgressConstants.ICON_PROPERTY, PDEPluginImages.DESC_FEATURE_OBJ);
                    installJob.schedule();
                }
            }
        });
        job.schedule();
    }

    @Override
    protected Document generateAntTask() {
        try {
            String qualifier;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document doc = factory.newDocumentBuilder().newDocument();
            Element root = doc.createElement("project");
            root.setAttribute("name", "build");
            root.setAttribute("default", "feature_export");
            doc.appendChild(root);
            Element target = doc.createElement("target");
            target.setAttribute("name", "feature_export");
            root.appendChild(target);
            Element export = doc.createElement("pde.exportFeatures");
            export.setAttribute("features", this.getFeatureIDs());
            export.setAttribute("destination", this.fPage.getDestination());
            String filename = this.fPage.getFileName();
            if (filename != null) {
                export.setAttribute("filename", filename);
            }
            export.setAttribute("exportType", this.getExportOperation());
            export.setAttribute("useJARFormat", Boolean.toString(this.fPage.useJARFormat()));
            export.setAttribute("exportSource", Boolean.toString(this.fPage.doExportSource()));
            if (this.fPage.doExportSource()) {
                export.setAttribute("exportSourceBundle", Boolean.toString(this.fPage.doExportSourceBundles()));
            }
            if ((qualifier = this.fPage.getQualifier()) != null) {
                export.setAttribute("qualifier", qualifier);
            }
            target.appendChild(export);
            return doc;
        }
        catch (DOMException dOMException) {
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
        }
        catch (ParserConfigurationException parserConfigurationException) {}
        return null;
    }

    private String getFeatureIDs() {
        StringBuilder buffer = new StringBuilder();
        Object[] objects = this.fPage.getSelectedItems();
        int i = 0;
        while (i < objects.length) {
            Object object = objects[i];
            if (object instanceof IFeatureModel) {
                buffer.append(((IFeatureModel)object).getFeature().getId());
                if (i < objects.length - 1) {
                    buffer.append(",");
                }
            }
            ++i;
        }
        return buffer.toString();
    }
}

