/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.model.Model;
import org.eclipse.stem.core.model.ModelFactory;
import org.eclipse.stem.ui.wizards.DublinCorePage;
import org.eclipse.stem.ui.wizards.Messages;
import org.eclipse.stem.ui.wizards.NewIdentifiablePage;
import org.eclipse.stem.ui.wizards.NewIdentifiableWizard;
import org.eclipse.stem.ui.wizards.STEMWizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class NewModelWizard
extends NewIdentifiableWizard {
    @Override
    protected String getWizardTitle() {
        return Messages.getString("NModelWiz.wizard_title");
    }

    @Override
    protected NewIdentifiablePage createNewIdentifiablePage() {
        this.setHelpContextId("org.eclipse.stem.doc.newmodel_contextid");
        return new NewModelPage();
    }

    @Override
    protected DublinCorePage createDublinCorePage() {
        return new DublinCorePage(){

            @Override
            protected void initializeDCAttributes() {
                super.initializeDCAttributes();
                this.format.setText("http:///org/eclipse/stem/core/model.ecore");
                this.format.setEnabled(false);
                this.type.setText(STEMURI.MODEL_TYPE_URI.toString());
                this.type.setEnabled(false);
                this.titleTextField.setText(Messages.getString("dc_title_model"));
                this.source.setText(Messages.getString("dc_source_model"));
                this.descriptionTextField.setText(Messages.getString("dc_desc_model"));
            }
        };
    }

    @Override
    protected Identifiable createIdentifiable() {
        Model retValue = ModelFactory.eINSTANCE.createModel();
        retValue.setDublinCore(this.newDublinCorePage.createDublinCore());
        return retValue;
    }

    @Override
    protected String getSerializationFolderName() {
        return "models";
    }

    @Override
    protected String getSerializationFileNameExtension() {
        return "model";
    }

    protected static class NewModelPage
    extends NewIdentifiablePage {
        protected NewModelPage() {
            super(Messages.getString("NModelWiz.page_title"));
            this.setTitle(Messages.getString("NModelWiz.page_title"));
            this.setDescription(Messages.getString("NModelWiz.page_description"));
        }

        @Override
        protected Composite createSpecificComposite(Composite parent) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.stem.doc.newmodel_contextid");
            return new Composite(parent, 0);
        }
    }

    public static class NewModelWizardCommandHandler
    extends AbstractHandler
    implements IHandler {
        public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
            IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)executionEvent);
            NewModelWizard wizard = new NewModelWizard();
            wizard.init(window.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
            STEMWizardDialog wizardDialog = new STEMWizardDialog(window.getShell(), (IWizard)wizard);
            wizardDialog.open();
            return null;
        }
    }
}

