/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.geographic.map.preferences;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.views.geographic.map.preferences.Messages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class MapViewPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID_STEM_MAP_VIEW_PAGE = "org.eclipse.stem.ui.views.geographic.map.preferences.MapViewPreferencePage";
    private static final int FIELD_WIDTH = 11;
    private ColorFieldEditor backgroundColorFieldEditor;
    private ColorFieldEditor foregroundColorRelativeValueZeroFieldEditor;
    private BooleanFieldEditor enableMultiColorDisplayFieldEditor;
    private StringFieldEditor sFactorFieldEditor;
    private StringFieldEditor eFactorFieldEditor;
    private StringFieldEditor iFactorFieldEditor;
    private StringFieldEditor rFactorFieldEditor;
    private StringFieldEditor guiScalingFactorFieldEditor;

    public MapViewPreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription(Messages.getString("MapVPPage.Viz"));
    }

    protected void createFieldEditors() {
        this.backgroundColorFieldEditor = new ColorFieldEditor("org.eclipse.stem.ui.views.geographic.map.preferences.backgroundcolor", Messages.getString("MapVPPage.bgc"), this.getFieldEditorParent());
        this.foregroundColorRelativeValueZeroFieldEditor = new ColorFieldEditor("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundrelativevaluezerocolor", Messages.getString("MapVPPage.fgrvzeroc"), this.getFieldEditorParent());
        this.enableMultiColorDisplayFieldEditor = new BooleanFieldEditor("org.eclipse.stem.ui.views.geographic.map.preferences.multicolordisplay", Messages.getString("MapVPPage.multicolordisplay"), this.getFieldEditorParent());
        this.sFactorFieldEditor = new StringFieldEditor("org.eclipse.stem.ui.views.geographic.map.preferences.scolorweight", Messages.getString("MapVPPage.ScolorWeight"), 11, this.getFieldEditorParent());
        this.sFactorFieldEditor.setEmptyStringAllowed(false);
        this.eFactorFieldEditor = new StringFieldEditor("org.eclipse.stem.ui.views.geographic.map.preferences.ecolorweight", Messages.getString("MapVPPage.EcolorWeight"), 11, this.getFieldEditorParent());
        this.eFactorFieldEditor.setEmptyStringAllowed(false);
        this.iFactorFieldEditor = new StringFieldEditor("org.eclipse.stem.ui.views.geographic.map.preferences.icolorweight", Messages.getString("MapVPPage.IcolorWeight"), 11, this.getFieldEditorParent());
        this.iFactorFieldEditor.setEmptyStringAllowed(false);
        this.rFactorFieldEditor = new StringFieldEditor("org.eclipse.stem.ui.views.geographic.map.preferences.rcolorweight", Messages.getString("MapVPPage.RcolorWeight"), 11, this.getFieldEditorParent());
        this.rFactorFieldEditor.setEmptyStringAllowed(false);
        this.guiScalingFactorFieldEditor = new StringFieldEditor("org.eclipse.stem.ui.views.geographic.map.preferences.guiscaling", Messages.getString("MapVPPage.gsf"), 11, this.getFieldEditorParent());
        this.guiScalingFactorFieldEditor.setEmptyStringAllowed(false);
        this.addField((FieldEditor)this.backgroundColorFieldEditor);
        this.addField((FieldEditor)this.foregroundColorRelativeValueZeroFieldEditor);
        this.addField((FieldEditor)this.enableMultiColorDisplayFieldEditor);
        this.addField((FieldEditor)this.sFactorFieldEditor);
        this.addField((FieldEditor)this.eFactorFieldEditor);
        this.addField((FieldEditor)this.iFactorFieldEditor);
        this.addField((FieldEditor)this.rFactorFieldEditor);
        this.addField((FieldEditor)this.guiScalingFactorFieldEditor);
    }

    protected void checkState() {
        super.checkState();
        if (this.isValid()) {
            try {
                double factor = Double.parseDouble(this.guiScalingFactorFieldEditor.getStringValue());
                if (factor <= 0.0) {
                    this.setErrorMessage(Messages.getString("GUIScale.negErr"));
                    this.setValid(false);
                }
            }
            catch (Exception e) {
                this.setErrorMessage(Messages.getString("MapVPPage.numErr"));
                this.setValid(false);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getProperty().equals("field_editor_value") && event.getSource() == this.guiScalingFactorFieldEditor) {
            this.checkState();
        }
    }

    public void init(IWorkbench workbench) {
    }
}

