/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.geographic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationManagerListener;
import org.eclipse.stem.jobs.simulation.SimulationManager;
import org.eclipse.stem.jobs.simulation.SimulationManagerEvent;
import org.eclipse.stem.ui.views.IContextMenuUpdatesListener;
import org.eclipse.stem.ui.views.geographic.GeographicControl;
import org.eclipse.stem.ui.views.geographic.GeographicControlFactory;
import org.eclipse.stem.ui.views.geographic.GeographicRenderer;
import org.eclipse.stem.ui.views.geographic.map.MapRenderer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class GeographicViewer
extends Viewer
implements ISelectionChangedListener,
ISimulationManagerListener {
    private final Set<ISimulation> simulationsToDisplay = new LinkedHashSet<ISimulation>();
    private SimulationManager simulationManager;
    private ISelection selection = null;
    private Composite composite;
    private GeographicControlFactory gcf;
    private List<IContextMenuUpdatesListener> contextMenuUpdateListeners = new ArrayList<IContextMenuUpdatesListener>();

    public GeographicViewer(Composite parent, GeographicControlFactory gcf) {
        this.composite = new Composite(parent, 0);
        FillLayout compositeLayout = new FillLayout(256);
        this.composite.setLayout((Layout)compositeLayout);
        this.gcf = gcf;
        this.refresh();
        this.composite.pack();
    }

    public Control getControl() {
        return this.composite;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void refresh() {
        if (this.simulationManager != null) {
            this.simulationsToDisplay.clear();
            this.simulationsToDisplay.addAll(this.simulationManager.getActiveSimulations());
        }
        this.populateView();
    }

    public Object getInput() {
        return this.simulationManager;
    }

    public void setInput(Object input) {
        SimulationManager oldInput = this.simulationManager;
        this.simulationManager = (SimulationManager)input;
        this.inputChanged(input, oldInput);
    }

    protected void inputChanged(Object input, Object oldInput) {
        if (oldInput != null) {
            ((SimulationManager)oldInput).removeListener((ISimulationManagerListener)this);
        }
        if (input != null) {
            ((SimulationManager)input).addSimulationManagerListener((ISimulationManagerListener)this);
        }
        this.refresh();
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.selection = selection;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelectionProvider() instanceof GeographicControl) {
            this.selection = event.getSelection();
            this.fireSelectionChanged(event);
        }
    }

    public void simulationsChanged(SimulationManagerEvent event) {
        this.addToDisplayedSimulationSet(Arrays.asList(event.getSimulationsAdded()));
        this.removeFromDisplayedSimulationSet(Arrays.asList(event.getSimulationsRemoved()));
        this.populateView();
    }

    private void addToDisplayedSimulationSet(List<ISimulation> simulations) {
        if (!simulations.isEmpty()) {
            this.simulationsToDisplay.addAll(simulations);
        }
    }

    private void removeFromDisplayedSimulationSet(List<ISimulation> simulations) {
        if (!simulations.isEmpty()) {
            this.simulationsToDisplay.removeAll(simulations);
        }
    }

    private void populateView() {
        ISimulation simulation;
        GeographicControl geoControl;
        Control element;
        Control[] controls;
        if (this.composite.isDisposed()) {
            return;
        }
        this.selection = null;
        HashSet<ISimulation> undisplayedSimulations = new HashSet<ISimulation>();
        for (ISimulation simulation2 : this.simulationsToDisplay) {
            if (this.isDisplayed(simulation2)) continue;
            undisplayedSimulations.add(simulation2);
        }
        Control[] controlArray = controls = this.composite.getChildren();
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            element = controlArray[n2];
            geoControl = (GeographicControl)element;
            if (!this.simulationsToDisplay.contains(geoControl.getSimulation()) && !undisplayedSimulations.isEmpty()) {
                simulation = (ISimulation)undisplayedSimulations.toArray()[0];
                geoControl.setSimulation(simulation);
                this.notifyContextMenuUpdateListeners(geoControl);
                undisplayedSimulations.remove(simulation);
            }
            ++n2;
        }
        controlArray = controls;
        n = controls.length;
        n2 = 0;
        while (n2 < n) {
            element = controlArray[n2];
            geoControl = (GeographicControl)element;
            simulation = geoControl.getSimulation();
            if (simulation != null && !this.simulationsToDisplay.contains(simulation)) {
                geoControl.removeSelectionChangedListener(this);
                geoControl.dispose();
            }
            ++n2;
        }
        for (ISimulation simulation2 : undisplayedSimulations) {
            GeographicControl geoControl2 = this.gcf.create(this.composite);
            this.notifyContextMenuUpdateListeners(geoControl2);
            geoControl2.addSelectionChangedListener(this);
            geoControl2.setSimulation(simulation2);
        }
        if (this.composite.getChildren().length == 0) {
            GeographicControl geoControl3 = this.gcf.create(this.composite);
            geoControl3.addSelectionChangedListener(this);
        }
        this.composite.layout(true, true);
        this.composite.redraw();
    }

    private boolean isDisplayed(ISimulation simulation) {
        Control[] foo;
        boolean retValue = false;
        Control[] controlArray = foo = this.composite.getChildren();
        int n = foo.length;
        int n2 = 0;
        while (n2 < n) {
            Control element = controlArray[n2];
            GeographicControl geoControl = (GeographicControl)element;
            ISimulation testSimulation = geoControl.getSimulation();
            if (testSimulation != null && testSimulation.equals(simulation)) {
                retValue = true;
                break;
            }
            ++n2;
        }
        return retValue;
    }

    public void addContextMenuUpdateListener(IContextMenuUpdatesListener newListener) {
        if (!this.contextMenuUpdateListeners.contains(newListener)) {
            this.contextMenuUpdateListeners.add(newListener);
        }
    }

    public void removeContextMenuUpdateListener(IContextMenuUpdatesListener newListener) {
        this.contextMenuUpdateListeners.remove(newListener);
    }

    private void notifyContextMenuUpdateListeners(GeographicControl geoControl) {
        GeographicRenderer geoRenderer = geoControl.getGeographicRenderer();
        if (geoRenderer instanceof MapRenderer) {
            MapRenderer mapRenderer = (MapRenderer)geoRenderer;
            this.notifyContextMenuUpdateListeners(mapRenderer.getMenuManager(), mapRenderer);
        }
    }

    private void notifyContextMenuUpdateListeners(MenuManager menuManager, ISelectionProvider selectionProvider) {
        for (IContextMenuUpdatesListener listener : this.contextMenuUpdateListeners) {
            listener.onContextMenuUpdate(menuManager, selectionProvider);
        }
    }
}

