/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ui.editor.parts;

import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ShortestPathConnectionRouter;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.stem.model.metamodel.Model;
import org.eclipse.stem.model.ui.editor.commands.CompartmentCreateCommand;
import org.eclipse.stem.model.ui.editor.commands.CompartmentSetConstraintCommand;
import org.eclipse.stem.model.ui.editor.controls.ModelParametersEditorDialog;
import org.eclipse.stem.model.ui.editor.parts.CompartmentElementEditPart;
import org.eclipse.stem.model.ui.editor.vismodel.CompartmentElement;
import org.eclipse.stem.model.ui.editor.vismodel.ModelElement;
import org.eclipse.swt.widgets.Display;

public class ModelElementEditPart
extends AbstractGraphicalEditPart
implements Adapter {
    public void performRequest(Request req) {
        super.performRequest(req);
        if (req.getType().equals("open")) {
            ModelElement me = this.getCastedModel();
            Model m = me.getModel();
            ModelParametersEditorDialog dialog = new ModelParametersEditorDialog(Display.getCurrent().getActiveShell(), m);
            dialog.open();
            this.refreshVisuals();
        }
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getCastedModel().eAdapters().add((Object)this);
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            this.getCastedModel().eAdapters().remove((Object)this);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ShapesXYLayoutEditPolicy());
    }

    protected IFigure createFigure() {
        FreeformLayer canvas = new FreeformLayer();
        canvas.setBorder((Border)new MarginBorder(3));
        canvas.setLayoutManager((LayoutManager)new FreeformLayout());
        ConnectionLayer connLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        connLayer.setConnectionRouter((ConnectionRouter)new ShortestPathConnectionRouter((IFigure)canvas));
        return canvas;
    }

    private ModelElement getCastedModel() {
        return (ModelElement)this.getModel();
    }

    protected List<CompartmentElement> getModelChildren() {
        return this.getCastedModel().getCompartmentElements();
    }

    public void notifyChanged(Notification notification) {
        this.refreshChildren();
        this.refreshSourceConnections();
        this.refreshTargetConnections();
        this.refreshVisuals();
    }

    public Notifier getTarget() {
        return this.getCastedModel();
    }

    public void setTarget(Notifier newTarget) {
    }

    public boolean isAdapterForType(Object type) {
        return type instanceof ModelElement;
    }

    private static class ShapesXYLayoutEditPolicy
    extends XYLayoutEditPolicy {
        private ShapesXYLayoutEditPolicy() {
        }

        protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
            if (child instanceof CompartmentElementEditPart && constraint instanceof Rectangle) {
                return new CompartmentSetConstraintCommand((CompartmentElement)child.getModel(), request, (Rectangle)constraint);
            }
            return super.createChangeConstraintCommand(request, child, constraint);
        }

        protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
            return null;
        }

        protected Command getCreateCommand(CreateRequest request) {
            Object childClass = request.getNewObjectType();
            if (childClass == CompartmentElement.class) {
                return new CompartmentCreateCommand((CompartmentElement)request.getNewObject(), (ModelElement)this.getHost().getModel(), (Rectangle)this.getConstraintFor(request));
            }
            return null;
        }
    }
}

