/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.vector.presentation;

import java.util.MissingResourceException;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.diseasemodels.vector.SimpleDengueModel;
import org.eclipse.stem.diseasemodels.vector.VectorPackage;
import org.eclipse.stem.diseasemodels.vector.presentation.AbstractDengueModelPropertyEditor;
import org.eclipse.stem.diseasemodels.vector.presentation.VectorWizardMessages;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class SimpleDengueModelPropertyEditor
extends AbstractDengueModelPropertyEditor {
    public SimpleDengueModelPropertyEditor(Composite parent, int style, DiseaseModel model, ModifyListener projectValidator, IProject project) {
        super(parent, style, model, projectValidator, project);
    }

    @Override
    public void populate(DiseaseModel object) {
        super.populate(object);
        SimpleDengueModel model = (SimpleDengueModel)object;
        try {
            Double hostTransmissionRateValue = Double.parseDouble(((Text)this.map.get(VectorPackage.Literals.SIMPLE_DENGUE_MODEL__HOST_TRANSMISSION_RATE)).getText());
            model.setHostTransmissionRate(hostTransmissionRateValue.doubleValue());
        }
        catch (NumberFormatException hostTransmissionRateValue) {
            // empty catch block
        }
        try {
            Double adeFactorValue = Double.parseDouble(((Text)this.map.get(VectorPackage.Literals.SIMPLE_DENGUE_MODEL__ADE_FACTOR)).getText());
            model.setAdeFactor(adeFactorValue.doubleValue());
        }
        catch (NumberFormatException adeFactorValue) {
            // empty catch block
        }
        try {
            Double hostImmunityLossRateValue = Double.parseDouble(((Text)this.map.get(VectorPackage.Literals.SIMPLE_DENGUE_MODEL__HOST_IMMUNITY_LOSS_RATE)).getText());
            model.setHostImmunityLossRate(hostImmunityLossRateValue.doubleValue());
        }
        catch (NumberFormatException hostImmunityLossRateValue) {
            // empty catch block
        }
        try {
            Double hostPrimaryDeathRateValue = Double.parseDouble(((Text)this.map.get(VectorPackage.Literals.SIMPLE_DENGUE_MODEL__HOST_PRIMARY_DEATH_RATE)).getText());
            model.setHostPrimaryDeathRate(hostPrimaryDeathRateValue.doubleValue());
        }
        catch (NumberFormatException hostPrimaryDeathRateValue) {
            // empty catch block
        }
        try {
            Double hostRecoveryRateValue = Double.parseDouble(((Text)this.map.get(VectorPackage.Literals.SIMPLE_DENGUE_MODEL__HOST_RECOVERY_RATE)).getText());
            model.setHostRecoveryRate(hostRecoveryRateValue.doubleValue());
        }
        catch (NumberFormatException hostRecoveryRateValue) {
            // empty catch block
        }
        try {
            Double hostSecondaryDeathRateValue = Double.parseDouble(((Text)this.map.get(VectorPackage.Literals.SIMPLE_DENGUE_MODEL__HOST_SECONDARY_DEATH_RATE)).getText());
            model.setHostSecondaryDeathRate(hostSecondaryDeathRateValue.doubleValue());
        }
        catch (NumberFormatException hostSecondaryDeathRateValue) {
            // empty catch block
        }
        try {
            Double vectorIncubationRateValue = Double.parseDouble(((Text)this.map.get(VectorPackage.Literals.SIMPLE_DENGUE_MODEL__VECTOR_INCUBATION_RATE)).getText());
            model.setVectorIncubationRate(vectorIncubationRateValue.doubleValue());
        }
        catch (NumberFormatException vectorIncubationRateValue) {
            // empty catch block
        }
        try {
            Double vectorTransmissionRateValue = Double.parseDouble(((Text)this.map.get(VectorPackage.Literals.SIMPLE_DENGUE_MODEL__VECTOR_TRANSMISSION_RATE)).getText());
            model.setVectorTransmissionRate(vectorTransmissionRateValue.doubleValue());
        }
        catch (NumberFormatException vectorTransmissionRateValue) {
            // empty catch block
        }
        try {
            Double immunityStrengthValue = Double.parseDouble(((Text)this.map.get(VectorPackage.Literals.SIMPLE_DENGUE_MODEL__IMMUNITY_STRENGTH)).getText());
            model.setImmunityStrength(immunityStrengthValue.doubleValue());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public boolean validate() {
        boolean valid = super.validate();
        valid = valid && this.validateFeatureConstraint((EStructuralFeature)VectorPackage.Literals.SIMPLE_DENGUE_MODEL__HOST_TRANSMISSION_RATE);
        valid = valid && this.validateFeatureConstraint((EStructuralFeature)VectorPackage.Literals.SIMPLE_DENGUE_MODEL__ADE_FACTOR);
        valid = valid && this.validateFeatureConstraint((EStructuralFeature)VectorPackage.Literals.SIMPLE_DENGUE_MODEL__HOST_IMMUNITY_LOSS_RATE);
        valid = valid && this.validateFeatureConstraint((EStructuralFeature)VectorPackage.Literals.SIMPLE_DENGUE_MODEL__HOST_PRIMARY_DEATH_RATE);
        valid = valid && this.validateFeatureConstraint((EStructuralFeature)VectorPackage.Literals.SIMPLE_DENGUE_MODEL__HOST_RECOVERY_RATE);
        valid = valid && this.validateFeatureConstraint((EStructuralFeature)VectorPackage.Literals.SIMPLE_DENGUE_MODEL__HOST_SECONDARY_DEATH_RATE);
        valid = valid && this.validateFeatureConstraint((EStructuralFeature)VectorPackage.Literals.SIMPLE_DENGUE_MODEL__VECTOR_INCUBATION_RATE);
        valid = valid && this.validateFeatureConstraint((EStructuralFeature)VectorPackage.Literals.SIMPLE_DENGUE_MODEL__VECTOR_TRANSMISSION_RATE);
        valid = valid && this.validateFeatureConstraint((EStructuralFeature)VectorPackage.Literals.SIMPLE_DENGUE_MODEL__IMMUNITY_STRENGTH);
        return valid;
    }

    public static class SimpleDengueModelPropertyStringProviderAdapter
    extends AbstractDengueModelPropertyEditor.AbstractDengueModelPropertyStringProviderAdapter {
        @Override
        public String getPropertyName(IItemPropertyDescriptor descriptor) {
            try {
                return VectorWizardMessages.getString(((EStructuralFeature)descriptor.getFeature(null)).getName(), "SimpleDengueModel");
            }
            catch (MissingResourceException e) {
                return super.getPropertyName(descriptor);
            }
        }

        @Override
        public String getPropertyToolTip(IItemPropertyDescriptor descriptor) {
            try {
                EStructuralFeature feature = (EStructuralFeature)descriptor.getFeature(null);
                return VectorWizardMessages.getString(String.valueOf(feature.getName()) + "TT", "SimpleDengueModel");
            }
            catch (MissingResourceException e) {
                return super.getPropertyToolTip(descriptor);
            }
        }

        @Override
        public String getPropertyUnits(IItemPropertyDescriptor descriptor) {
            try {
                EStructuralFeature feature = (EStructuralFeature)descriptor.getFeature(null);
                return VectorWizardMessages.getString(String.valueOf(feature.getName()) + "UNIT", "SimpleDengueModel");
            }
            catch (MissingResourceException e) {
                return super.getPropertyUnits(descriptor);
            }
        }

        @Override
        public String getPropertyMissing(IItemPropertyDescriptor descriptor) {
            try {
                EStructuralFeature feature = (EStructuralFeature)descriptor.getFeature(null);
                return VectorWizardMessages.getString(String.valueOf(feature.getName()) + "MISSING", "SimpleDengueModel");
            }
            catch (MissingResourceException e) {
                return super.getPropertyMissing(descriptor);
            }
        }

        @Override
        public String getPropertyInvalid(IItemPropertyDescriptor descriptor) {
            try {
                EStructuralFeature feature = (EStructuralFeature)descriptor.getFeature(null);
                return VectorWizardMessages.getString(String.valueOf(feature.getName()) + "INVALID", "SimpleDengueModel");
            }
            catch (MissingResourceException e) {
                return super.getPropertyInvalid(descriptor);
            }
        }
    }
}

