/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stem.loggers.SimulationLogger;
import org.eclipse.ui.handlers.HandlerUtil;

public class LoggerCommandHandler {
    private static SimulationLogger getSelection(ExecutionEvent executionEvent) throws ExecutionException {
        StructuredSelection selection2;
        Object selected;
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)executionEvent);
        if (selection instanceof StructuredSelection && (selected = (selection2 = (StructuredSelection)selection).getFirstElement()) instanceof SimulationLogger) {
            return (SimulationLogger)selected;
        }
        return null;
    }

    private static void setLoggerState(ExecutionEvent executionEvent, boolean enabled) throws ExecutionException {
        SimulationLogger logger = LoggerCommandHandler.getSelection(executionEvent);
        if (logger != null) {
            logger.setEnabled(enabled);
        }
    }

    public static class DisableLoggerCommandHandler
    extends AbstractHandler
    implements IHandler {
        public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
            LoggerCommandHandler.setLoggerState(executionEvent, false);
            return null;
        }
    }

    public static class EnableLoggerCommandHandler
    extends AbstractHandler
    implements IHandler {
        public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
            LoggerCommandHandler.setLoggerState(executionEvent, true);
            return null;
        }
    }
}

