/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;

class MethodArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<MethodSource> {
    private String[] methodNames;

    MethodArgumentsProvider() {
    }

    @Override
    public void accept(MethodSource annotation) {
        this.methodNames = annotation.value();
    }

    public Stream<Arguments> provideArguments(ExtensionContext context) {
        Class testClass = context.getRequiredTestClass();
        Object testInstance = context.getTestInstance().orElse(null);
        return Arrays.stream(this.methodNames).map(methodName -> StringUtils.isNotBlank((String)methodName) ? methodName : context.getRequiredTestMethod().getName()).map(methodName -> (Method)ReflectionUtils.findMethod((Class)testClass, (String)methodName, (Class[])new Class[0]).orElseThrow(() -> new JUnitException(String.format("Could not find factory method [%s] in class [%s]", methodName, testClass.getName())))).map(method -> ReflectionUtils.invokeMethod((Method)method, (Object)testInstance, (Object[])new Object[0])).flatMap(CollectionUtils::toStream).map(MethodArgumentsProvider::toArguments);
    }

    private static Arguments toArguments(Object item) {
        if (item instanceof Arguments) {
            return (Arguments)item;
        }
        if (item instanceof Object[]) {
            return Arguments.of((Object[])item);
        }
        return Arguments.of(item);
    }
}

