/**
 * <copyright>
 * 
 * Copyright (c) 2016 itemis and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     itemis - Initial API and implementation
 * 
 * </copyright>
 */
package org.eclipse.sphinx.examples.workflows.simple.xtend;

import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.mwe2.runtime.workflow.IWorkflowComponent;
import org.eclipse.sphinx.emf.mwe.dynamic.WorkspaceWorkflow;
import org.eclipse.sphinx.emf.mwe.dynamic.annotations.WorkflowParameter;
import org.eclipse.sphinx.examples.workflows.simple.xtend.SimpleXtendWorkflowComponentWithParams;
import org.eclipse.xtext.xbase.lib.InputOutput;

@SuppressWarnings("all")
public class SimpleXtendWorkflowWithParams extends WorkspaceWorkflow {
  @WorkflowParameter
  private boolean boolWorkflowParam;
  
  @WorkflowParameter
  private String strWorkflowParam;
  
  @WorkflowParameter
  private URI uriWorkflowParam;
  
  @WorkflowParameter("workflowParamWithAlias")
  private String otherWorkflowParam;
  
  public SimpleXtendWorkflowWithParams() {
    List<IWorkflowComponent> _children = this.getChildren();
    SimpleXtendWorkflowComponentWithParams _simpleXtendWorkflowComponentWithParams = new SimpleXtendWorkflowComponentWithParams();
    _children.add(_simpleXtendWorkflowComponentWithParams);
  }
  
  @Override
  public void preInvoke() {
    InputOutput.<String>println("Running simple Xtend-based workflow with parameters");
    InputOutput.<String>println(("boolWorkflowParam = " + Boolean.valueOf(this.boolWorkflowParam)));
    InputOutput.<String>println(("strWorkflowParam = " + this.strWorkflowParam));
    InputOutput.<String>println(("uriWorkflowParam = " + this.uriWorkflowParam));
    InputOutput.<String>println(("otherWorkflowParam (workflowParamWithAlias) = " + this.otherWorkflowParam));
    super.preInvoke();
  }
}
