/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sphinx.emf.Activator;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.metamodel.MetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.resource.ScopingResourceSet;
import org.eclipse.sphinx.emf.scoping.IResourceScope;
import org.eclipse.sphinx.emf.scoping.ResourceScopeProviderRegistry;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public class ModelDescriptor
extends PlatformObject
implements IModelDescriptor {
    protected IMetaModelDescriptor mmDescriptor;
    protected IMetaModelDescriptor targetMMDescriptor;
    protected IResourceScope resourceScope;
    private TransactionalEditingDomain editingDomain = null;

    public ModelDescriptor(IMetaModelDescriptor mmDescriptor, IMetaModelDescriptor targetMMDescriptor, IResourceScope resourceScope) {
        Assert.isNotNull((Object)mmDescriptor);
        Assert.isNotNull((Object)resourceScope);
        this.mmDescriptor = mmDescriptor;
        this.targetMMDescriptor = targetMMDescriptor;
        this.resourceScope = resourceScope;
    }

    @Override
    public IMetaModelDescriptor getMetaModelDescriptor() {
        return this.mmDescriptor;
    }

    @Override
    public IMetaModelDescriptor getTargetMetaModelDescriptor() {
        return this.targetMMDescriptor;
    }

    protected IMetaModelDescriptor getEffectiveMetaModelDescriptor() {
        if (this.targetMMDescriptor != null) {
            return this.targetMMDescriptor;
        }
        return this.mmDescriptor;
    }

    @Override
    public IResourceScope getScope() {
        return this.resourceScope;
    }

    @Override
    public TransactionalEditingDomain getEditingDomain() {
        if (this.editingDomain == null) {
            IResource resourceScopeRoot = this.getRoot();
            if (resourceScopeRoot instanceof IContainer) {
                this.editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((IContainer)resourceScopeRoot, this.getEffectiveMetaModelDescriptor());
            } else if (resourceScopeRoot instanceof IFile) {
                this.editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((IFile)resourceScopeRoot);
            } else {
                throw new RuntimeException("Unable to retrieve editing domain for resource scope root being an instance of '" + resourceScopeRoot.getClass().getSimpleName() + "'");
            }
        }
        return this.editingDomain;
    }

    @Override
    public IResource getRoot() {
        return this.resourceScope.getRoot();
    }

    @Override
    public Collection<IResource> getReferencedRoots() {
        return this.resourceScope.getReferencedRoots();
    }

    @Override
    public Collection<IResource> getReferencingRoots() {
        return this.resourceScope.getReferencingRoots();
    }

    @Override
    public Collection<IFile> getPersistedFiles(boolean includeReferencedScopes) {
        HashSet<IFile> persistedFiles = new HashSet<IFile>();
        for (IFile file : this.resourceScope.getPersistedFiles(includeReferencedScopes)) {
            IMetaModelDescriptor mmDescriptor;
            boolean isSynchronized;
            if (ResourceScopeProviderRegistry.INSTANCE.isNotInAnyScope(file) || !(isSynchronized = ExtendedPlatform.isSynchronized((IResource)file)) || !this.mmDescriptor.equals(mmDescriptor = MetaModelDescriptorRegistry.INSTANCE.getDescriptor(file))) continue;
            if (this.targetMMDescriptor != null) {
                IMetaModelDescriptor targetMMDescriptor = MetaModelDescriptorRegistry.INSTANCE.getTargetDescriptor(file);
                if (!this.targetMMDescriptor.equals(targetMMDescriptor)) continue;
                persistedFiles.add(file);
                continue;
            }
            persistedFiles.add(file);
        }
        return Collections.unmodifiableCollection(persistedFiles);
    }

    @Override
    public Collection<Resource> getLoadedResources(final boolean includeReferencedScopes) {
        try {
            return (Collection)TransactionUtil.runExclusive((TransactionalEditingDomain)this.getEditingDomain(), (RunnableWithResult)new RunnableWithResult.Impl<List<Resource>>(){

                public void run() {
                    ResourceSet resourceSet = ModelDescriptor.this.getEditingDomain().getResourceSet();
                    if (resourceSet instanceof ScopingResourceSet) {
                        this.setResult(((ScopingResourceSet)resourceSet).getResourcesInModel(ModelDescriptor.this, includeReferencedScopes));
                    } else {
                        this.setResult(resourceSet.getResources());
                    }
                }
            });
        }
        catch (InterruptedException ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
            return Collections.emptyList();
        }
    }

    @Override
    public boolean belongsTo(IFile file, boolean includeReferencedScopes) {
        IMetaModelDescriptor mmDescriptor;
        if (file != null && this.mmDescriptor.equals(mmDescriptor = MetaModelDescriptorRegistry.INSTANCE.getDescriptor(file))) {
            if (this.targetMMDescriptor != null) {
                IMetaModelDescriptor targetMMDescriptor = MetaModelDescriptorRegistry.INSTANCE.getTargetDescriptor(file);
                if (this.targetMMDescriptor.equals(targetMMDescriptor)) {
                    return this.resourceScope.belongsTo(file, includeReferencedScopes);
                }
            } else {
                return this.resourceScope.belongsTo(file, includeReferencedScopes);
            }
        }
        return false;
    }

    @Override
    public boolean belongsTo(final Resource resource, boolean includeReferencedScopes) {
        IMetaModelDescriptor mmDescriptor;
        if (resource != null && this.mmDescriptor.equals(mmDescriptor = MetaModelDescriptorRegistry.INSTANCE.getDescriptor(resource)) && this.resourceScope.belongsTo(resource, includeReferencedScopes)) {
            try {
                return (Boolean)TransactionUtil.runExclusive((TransactionalEditingDomain)this.getEditingDomain(), (RunnableWithResult)new RunnableWithResult.Impl<Boolean>(){

                    public void run() {
                        this.setResult(ModelDescriptor.this.getEditingDomain().getResourceSet().getResources().contains((Object)resource));
                    }
                });
            }
            catch (InterruptedException ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
            }
        }
        return false;
    }

    @Override
    public boolean belongsTo(URI uri, boolean includeReferencedScopes) {
        if (uri != null) {
            Resource resource = EcorePlatformUtil.getResource(uri);
            if (resource != null) {
                return this.belongsTo(resource, includeReferencedScopes);
            }
            IFile file = EcorePlatformUtil.getFile(uri);
            return this.belongsTo(file, includeReferencedScopes);
        }
        return false;
    }

    @Override
    public boolean didBelongTo(IFile file, boolean includeReferencedScopes) {
        IMetaModelDescriptor oldMMDescriptor;
        if (file != null && this.mmDescriptor.equals(oldMMDescriptor = MetaModelDescriptorRegistry.INSTANCE.getOldDescriptor(file))) {
            return this.resourceScope.didBelongTo(file, includeReferencedScopes);
        }
        return false;
    }

    @Override
    public boolean didBelongTo(Resource resource, boolean includeReferencedScopes) {
        IMetaModelDescriptor oldMMDescriptor;
        if (resource != null && this.mmDescriptor.equals(oldMMDescriptor = MetaModelDescriptorRegistry.INSTANCE.getOldDescriptor(resource))) {
            return this.resourceScope.didBelongTo(resource, includeReferencedScopes);
        }
        return false;
    }

    @Override
    public boolean didBelongTo(URI uri, boolean includeReferencedScopes) {
        if (uri != null) {
            Resource resource = EcorePlatformUtil.getResource(uri);
            if (resource != null) {
                return this.didBelongTo(resource, includeReferencedScopes);
            }
            IFile file = EcorePlatformUtil.getFile(uri);
            return this.didBelongTo(file, includeReferencedScopes);
        }
        return false;
    }

    @Override
    public boolean isShared(IFile file) {
        return this.resourceScope.isShared(file);
    }

    @Override
    public boolean isShared(Resource resource) {
        return this.resourceScope.isShared(resource);
    }

    @Override
    public boolean isShared(URI uri) {
        return this.resourceScope.isShared(uri);
    }

    public boolean equals(Object object) {
        if (object instanceof ModelDescriptor) {
            ModelDescriptor otherModelDescriptor = (ModelDescriptor)object;
            return this.mmDescriptor.equals(otherModelDescriptor.mmDescriptor) && (this.targetMMDescriptor == null && otherModelDescriptor.targetMMDescriptor == null || this.targetMMDescriptor.equals(otherModelDescriptor.targetMMDescriptor)) && this.resourceScope.equals(otherModelDescriptor.resourceScope);
        }
        return false;
    }

    public int hashCode() {
        return this.mmDescriptor.hashCode() + (this.targetMMDescriptor != null ? this.targetMMDescriptor.hashCode() : 0) + this.resourceScope.getRoot().hashCode();
    }

    public String toString() {
        return this.mmDescriptor + (this.targetMMDescriptor != null ? "->" + this.targetMMDescriptor : "") + "@" + this.resourceScope.getRoot().getName();
    }
}

