/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.evalidator.adapter;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.IConstraintFilter;
import org.eclipse.emf.validation.service.ITraversalStrategy;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.sphinx.emf.validation.diagnostic.ExtendedDiagnostic;
import org.eclipse.sphinx.emf.validation.preferences.IValidationPreferences;

public class EValidatorAdapter
extends EObjectValidator {
    private final IBatchValidator batchValidator = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
    private static Boolean emfIntrinsicConstraints = null;

    public EValidatorAdapter() {
        this.batchValidator.setIncludeLiveConstraints(true);
        this.batchValidator.setReportSuccesses(false);
        this.batchValidator.setTraversalStrategy((ITraversalStrategy)new ITraversalStrategy.Flat());
    }

    protected static Boolean areEMFIntrinsicConstraintsEnabled() {
        IEclipsePreferences prefs;
        if (emfIntrinsicConstraints == null && (prefs = InstanceScope.INSTANCE.getNode("org.eclipse.sphinx.emf.validation")) != null) {
            emfIntrinsicConstraints = prefs.getBoolean("emf_rule_enablement", IValidationPreferences.PREF_ENABLE_EMF_DEFAULT_RULES_DEFAULT);
            prefs.addPreferenceChangeListener(new IEclipsePreferences.IPreferenceChangeListener(){

                public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                    String key = event.getKey();
                    if (key.equals("emf_rule_enablement")) {
                        Object newValue = event.getNewValue();
                        if (newValue == null) {
                            emfIntrinsicConstraints = Boolean.FALSE;
                        } else {
                            emfIntrinsicConstraints = Boolean.valueOf(newValue.toString());
                        }
                    }
                }
            });
        }
        return emfIntrinsicConstraints;
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(eObject.eClass(), eObject, diagnostics, context);
    }

    protected void validateEMFRules(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (EValidatorAdapter.areEMFIntrinsicConstraintsEnabled() == Boolean.TRUE) {
            if (eClass.eContainer() == this.getEPackage()) {
                this.validate(eClass.getClassifierID(), eObject, diagnostics, context);
            } else {
                EList eSuperTypes = eClass.getESuperTypes();
                if (eSuperTypes.isEmpty()) {
                    this.validate_EveryDefaultConstraint(eObject, diagnostics, context);
                }
            }
        }
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context, final Set<IConstraintFilter> filters) {
        this.validateEMFRules(eClass, eObject, diagnostics, context);
        IStatus status = Status.OK_STATUS;
        if (diagnostics != null && !this.hasProcessed(eObject, context)) {
            this.addFilters(filters);
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)eObject);
            if (editingDomain != null) {
                final EObject tgt = eObject;
                RunnableWithResult.Impl<IStatus> run = new RunnableWithResult.Impl<IStatus>(){

                    public void run() {
                        IStatus status = Status.OK_STATUS;
                        try {
                            status = EValidatorAdapter.this.batchValidator.validate(tgt, (IProgressMonitor)new NullProgressMonitor());
                        }
                        finally {
                            EValidatorAdapter.this.removeFilters(filters);
                        }
                        this.setResult(status);
                    }
                };
                try {
                    status = (IStatus)editingDomain.runExclusive((Runnable)run);
                }
                catch (InterruptedException interruptedException) {}
            } else {
                try {
                    status = this.batchValidator.validate(eObject, (IProgressMonitor)new NullProgressMonitor());
                }
                finally {
                    this.removeFilters(filters);
                }
            }
            this.processed(eObject, context, status);
            this.appendDiagnostics(status, diagnostics);
        }
        return status.isOK();
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(eClass, eObject, diagnostics, context, null);
    }

    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return super.validate(eDataType, value, diagnostics, context);
    }

    private void processed(EObject eObject, Map<Object, Object> context, IStatus status) {
        if (context != null) {
            context.put(eObject, status);
        }
    }

    private boolean hasProcessed(EObject eObject, Map<Object, Object> context) {
        boolean result = false;
        if (context != null) {
            while (eObject != null) {
                if (context.containsKey(eObject)) {
                    result = true;
                    eObject = null;
                    continue;
                }
                eObject = eObject.eContainer();
            }
        }
        return false;
    }

    private void appendDiagnostics(IStatus status, DiagnosticChain diagnostics) {
        if (status.isMultiStatus()) {
            IStatus[] children;
            IStatus[] iStatusArray = children = status.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus element = iStatusArray[n2];
                this.appendDiagnostics(element, diagnostics);
                ++n2;
            }
        } else if (status instanceof IConstraintStatus) {
            diagnostics.add((Diagnostic)new ExtendedDiagnostic(status.getSeverity(), status.getPlugin(), ((IConstraintStatus)status).getConstraint(), status.getCode(), status.getMessage(), ((IConstraintStatus)status).getResultLocus().toArray()));
        } else {
            diagnostics.add((Diagnostic)new BasicDiagnostic(status.getSeverity(), status.getPlugin(), status.getCode(), status.getMessage(), (Object[])status.getChildren()));
        }
    }

    private void addFilters(Set<IConstraintFilter> filters) {
        if (filters != null) {
            for (IConstraintFilter icf : filters) {
                this.batchValidator.addConstraintFilter(icf);
            }
        }
    }

    private void removeFilters(Set<IConstraintFilter> filters) {
        if (filters != null) {
            for (IConstraintFilter icf : filters) {
                this.batchValidator.removeConstraintFilter(icf);
            }
        }
    }
}

