/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.ui.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class UIUtil {
    public static <T> T unwrap(Object object, Class<T> type) {
        if (object instanceof ExecutionEvent) {
            object = HandlerUtil.getCurrentSelection((ExecutionEvent)((ExecutionEvent)object));
        }
        if (object instanceof IStructuredSelection) {
            object = ((IStructuredSelection)object).getFirstElement();
        }
        if (object instanceof IAdaptable) {
            object = ((IAdaptable)object).getAdapter(type);
        }
        if (type.isInstance(object)) {
            return type.cast(object);
        }
        return null;
    }

    public static <T> List<T> unwrapAll(Object object, Class<T> clazz) {
        if (object instanceof ExecutionEvent) {
            object = HandlerUtil.getCurrentSelection((ExecutionEvent)((ExecutionEvent)object));
        }
        if (object instanceof IStructuredSelection) {
            ArrayList<T> list = new ArrayList<T>();
            IStructuredSelection selection = (IStructuredSelection)object;
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                T next = UIUtil.unwrap(it.next(), clazz);
                if (next == null) continue;
                list.add(next);
            }
            return list;
        }
        T element = UIUtil.unwrap(object, clazz);
        if (element != null) {
            return Collections.singletonList(element);
        }
        return Collections.emptyList();
    }
}

