/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.check;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.sphinx.emf.check.util.CheckValidationContextHelper;
import org.eclipse.sphinx.emf.check.util.ExtendedEObjectValidator;

public class CompositeValidator
implements EValidator {
    private List<EValidator> children = new ArrayList<EValidator>();

    public CompositeValidator() {
    }

    public CompositeValidator(EValidator delegate) {
        this();
        this.addChild(delegate);
    }

    public void addChild(EValidator delegate) {
        if (this == delegate) {
            return;
        }
        if (!this.children.contains(delegate)) {
            this.children.add(delegate);
        }
    }

    public void removeChild(EValidator delegate) {
        if (this == delegate) {
            return;
        }
        if (this.children.contains(delegate)) {
            this.children.remove(delegate);
        }
    }

    public List<EValidator> getChildren() {
        return this.children;
    }

    protected boolean containsEObjectValidator() {
        for (EValidator validator : this.getChildren()) {
            if (!(validator instanceof EObjectValidator)) continue;
            return true;
        }
        return false;
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        CompositeValidatorHandler handler = new CompositeValidatorHandler(context);
        boolean result = handler.preValidate(eObject.eClass().getClassifierID(), eObject, diagnostics);
        for (EValidator validator : this.getChildren()) {
            result &= validator.validate(eObject, diagnostics, context);
        }
        handler.postValidate();
        return result;
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        CompositeValidatorHandler handler = new CompositeValidatorHandler(context);
        boolean result = handler.preValidate(eClass.getClassifierID(), eObject, diagnostics);
        for (EValidator validator : this.getChildren()) {
            result &= validator.validate(eClass, eObject, diagnostics, context);
        }
        handler.postValidate();
        return result;
    }

    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        CompositeValidatorHandler handler = new CompositeValidatorHandler(context);
        boolean result = handler.preValidate(eDataType.getClassifierID(), value, diagnostics);
        for (EValidator validator : this.getChildren()) {
            result &= validator.validate(eDataType, value, diagnostics, context);
        }
        handler.postValidate();
        return result;
    }

    protected class CompositeValidatorHandler {
        private ExtendedEObjectValidator eObjectValidator = new ExtendedEObjectValidator();
        private Map<Object, Object> context;
        private CheckValidationContextHelper helper;
        private Boolean oldEnableIntrinsicModelIntegrityConstraintsOption = null;

        public CompositeValidatorHandler(Map<Object, Object> context) {
            this.context = context;
            this.helper = new CheckValidationContextHelper(context);
        }

        public boolean preValidate(int classifierID, Object object, DiagnosticChain diagnostics) {
            boolean result = true;
            if (this.helper.areIntrinsicModelIntegrityConstraintsEnabled() && !CompositeValidator.this.containsEObjectValidator()) {
                result = this.eObjectValidator.validate(classifierID, object, diagnostics, this.context);
                this.oldEnableIntrinsicModelIntegrityConstraintsOption = this.helper.removeEnableIntrinsicModelIntegrityConstraintsOption();
            }
            return result;
        }

        public void postValidate() {
            this.helper.addEnableIntrinsicModelIntegrityConstraintsOption(this.oldEnableIntrinsicModelIntegrityConstraintsOption);
        }
    }
}

