/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.ui.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.sphinx.platform.ui.internal.util.PixelConverter;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class SWTUtil {
    public static Shell getShell(Widget widget) {
        if (widget instanceof Control) {
            return ((Control)widget).getShell();
        }
        if (widget instanceof Caret) {
            return ((Caret)widget).getParent().getShell();
        }
        if (widget instanceof DragSource) {
            return ((DragSource)widget).getControl().getShell();
        }
        if (widget instanceof DropTarget) {
            return ((DropTarget)widget).getControl().getShell();
        }
        if (widget instanceof Menu) {
            return ((Menu)widget).getParent().getShell();
        }
        if (widget instanceof ScrollBar) {
            return ((ScrollBar)widget).getParent().getShell();
        }
        return null;
    }

    public static int getButtonWidthHint(Button button) {
        button.setFont(JFaceResources.getDialogFont());
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static void setButtonDimensionHint(Button button) {
        Assert.isNotNull((Object)button);
        Object gd = button.getLayoutData();
        if (gd instanceof GridData) {
            ((GridData)gd).widthHint = SWTUtil.getButtonWidthHint(button);
            ((GridData)gd).horizontalAlignment = 4;
        }
    }

    public static Button createButton(Composite parent, String text, int style) {
        Button button = new Button(parent, style);
        button.setText(text);
        button.setLayoutData((Object)SWTUtil.getButtonGridData(button));
        return button;
    }

    public static GridData getButtonGridData(Button button) {
        GridData data = new GridData(768);
        data.widthHint = SWTUtil.getButtonWidthHint(button);
        return data;
    }
}

