/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.explorer.refresh;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.sphinx.emf.explorer.IModelCommonContentProvider;
import org.eclipse.sphinx.emf.explorer.refresh.AbstractRefreshStrategy;

public class WorkspaceResourceRefreshStrategy
extends AbstractRefreshStrategy
implements Runnable {
    private static final int MAX_INDIVIDUAL_WORKSPACE_RESOURCE_REFRESHES = 20;
    private Set<IResource> workspaceResourcesToRefresh = null;

    public WorkspaceResourceRefreshStrategy(IModelCommonContentProvider contentProvider, boolean preserveTreeViewerState) {
        super(contentProvider, preserveTreeViewerState);
    }

    public Set<IResource> getWorkspaceResourcesToRefresh() {
        if (this.workspaceResourcesToRefresh == null) {
            this.workspaceResourcesToRefresh = new HashSet<IResource>();
        }
        return this.workspaceResourcesToRefresh;
    }

    @Override
    protected boolean shouldPerformSelectiveRefresh() {
        return this.getWorkspaceResourcesToRefresh().size() < 20;
    }

    @Override
    protected void performSelectiveRefresh(StructuredViewer viewer) {
        for (IResource workspaceResource : this.getWorkspaceResourcesToRefresh()) {
            if (workspaceResource == null || !workspaceResource.isAccessible() || !this.contentProvider.isTriggerPoint(workspaceResource)) continue;
            viewer.refresh((Object)workspaceResource, true);
        }
    }
}

