/**
 * <copyright>
 * 
 * Copyright (c) 2014 itemis and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     itemis - Initial API and implementation
 * 
 * </copyright>
 */
package org.eclipse.sphinx.jdt.loaders;

import com.google.common.base.Objects;
import java.security.SecureClassLoader;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

@SuppressWarnings("all")
public class DelegatingCompositeBundleClassLoader extends SecureClassLoader {
  private List<Bundle> bundles;
  
  private List<ClassLoader> bundleClassLoaders = null;
  
  public DelegatingCompositeBundleClassLoader(final ClassLoader parent, final List<Bundle> bundles) {
    super(parent);
    Assert.isNotNull(bundles);
    this.bundles = bundles;
  }
  
  public List<ClassLoader> getBundleClassLoaders() {
    List<ClassLoader> _xblockexpression = null;
    {
      boolean _equals = Objects.equal(this.bundleClassLoaders, null);
      if (_equals) {
        final Function1<Bundle, BundleWiring> _function = new Function1<Bundle, BundleWiring>() {
          public BundleWiring apply(final Bundle it) {
            return it.<BundleWiring>adapt(BundleWiring.class);
          }
        };
        List<BundleWiring> _map = ListExtensions.<Bundle, BundleWiring>map(this.bundles, _function);
        Iterable<BundleWiring> _filterNull = IterableExtensions.<BundleWiring>filterNull(_map);
        final Function1<BundleWiring, ClassLoader> _function_1 = new Function1<BundleWiring, ClassLoader>() {
          public ClassLoader apply(final BundleWiring it) {
            return it.getClassLoader();
          }
        };
        Iterable<ClassLoader> _map_1 = IterableExtensions.<BundleWiring, ClassLoader>map(_filterNull, _function_1);
        List<ClassLoader> _list = IterableExtensions.<ClassLoader>toList(_map_1);
        this.bundleClassLoaders = _list;
      }
      _xblockexpression = this.bundleClassLoaders;
    }
    return _xblockexpression;
  }
  
  protected Class<?> findClass(final String name) throws ClassNotFoundException {
    List<ClassLoader> _bundleClassLoaders = this.getBundleClassLoaders();
    for (final ClassLoader bundleClassLoader : _bundleClassLoaders) {
      try {
        final Class<?> clazz = bundleClassLoader.loadClass(name);
        return clazz;
      } catch (final Throwable _t) {
        if (_t instanceof Throwable) {
          final Throwable ex = (Throwable)_t;
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
    }
    throw new ClassNotFoundException(name);
  }
  
  public String toString() {
    Class<? extends DelegatingCompositeBundleClassLoader> _class = this.getClass();
    String _name = _class.getName();
    String _plus = (_name + " [bundles=");
    Object[] _array = this.bundles.toArray();
    String _string = Arrays.toString(_array);
    String _plus_1 = (_plus + _string);
    return (_plus_1 + "]");
  }
}
