/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.jobs;

import java.net.URI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.workspace.Activator;
import org.eclipse.sphinx.emf.workspace.internal.messages.Messages;
import org.eclipse.sphinx.platform.preferences.IProjectWorkspacePreference;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;
import org.eclipse.sphinx.platform.util.StatusUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateNewModelProjectJob<T extends IMetaModelDescriptor>
extends WorkspaceJob {
    protected IProject newProject;
    protected URI location;
    protected String natureId;
    protected T metaModelVersionDescriptor;
    protected IProjectWorkspacePreference<T> metaModelVersionPreference;
    @Deprecated
    protected IProject project;
    private IAdaptable uiInfo;
    private IProject[] referencedProjects;

    public CreateNewModelProjectJob(String jobName, IProject newProject) {
        this(jobName, newProject, null, null);
    }

    @Deprecated
    public CreateNewModelProjectJob(String jobName, String natureId) {
        this(jobName, ResourcesPlugin.getWorkspace().getRoot().getProject("NewModelProject"), null, natureId);
    }

    public CreateNewModelProjectJob(String jobName, IProject newProject, URI location, String natureId) {
        super(jobName);
        Assert.isNotNull((Object)newProject);
        this.newProject = this.project = newProject;
        this.location = location;
        this.natureId = natureId;
        this.setPriority(40);
        this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
    }

    public CreateNewModelProjectJob(String jobName, IProject newProject, URI location, T metaModelVersionDescriptor, IProjectWorkspacePreference<T> metaModelVersionPreference) {
        this(jobName, newProject, location, metaModelVersionPreference != null ? metaModelVersionPreference.getRequiredProjectNatureId() : null);
        this.metaModelVersionDescriptor = metaModelVersionDescriptor;
        this.metaModelVersionPreference = metaModelVersionPreference;
    }

    @Deprecated
    public CreateNewModelProjectJob(String jobName, IProject newProject, URI location, T metaModelVersionDescriptor, String natureId, IProjectWorkspacePreference<T> metaModelVersionPreference) {
        this(jobName, newProject, location, natureId);
        this.metaModelVersionDescriptor = metaModelVersionDescriptor;
        this.metaModelVersionPreference = metaModelVersionPreference;
    }

    public void setUIInfoAdaptable(IAdaptable uiInfo) {
        this.uiInfo = uiInfo;
    }

    public IAdaptable getUIInfoAdaptable() {
        return this.uiInfo;
    }

    public IProject[] getReferencedProjects() {
        return this.referencedProjects;
    }

    public void setReferencedProjects(IProject[] referencedProjects) {
        this.referencedProjects = referencedProjects;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getName(), (int)100);
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.createNewProject((IProgressMonitor)progress.newChild(70));
            this.addNatures((IProgressMonitor)progress.newChild(15));
            if (this.metaModelVersionDescriptor != null && this.metaModelVersionPreference != null) {
                this.metaModelVersionPreference.setInProject(this.newProject, this.metaModelVersionDescriptor);
            }
            progress.worked(15);
            return Status.OK_STATUS;
        }
        catch (OperationCanceledException operationCanceledException) {
            return Status.CANCEL_STATUS;
        }
        catch (Exception ex) {
            return StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex);
        }
    }

    protected void createNewProject(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        progress.subTask(Messages.subTask_creatingNewModelProject);
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(this.newProject.getName());
        description.setLocationURI(this.location);
        if (this.referencedProjects != null && this.referencedProjects.length > 0) {
            description.setReferencedProjects(this.referencedProjects);
        }
        this.newProject.create(description, (IProgressMonitor)progress.newChild(50));
        this.newProject.open(0, (IProgressMonitor)progress.newChild(50));
    }

    protected void addNatures(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (this.natureId != null) {
            progress.subTask(Messages.subTask_addingProjectNatures);
            ExtendedPlatform.addNature((IProject)this.newProject, (String)this.natureId, (IProgressMonitor)progress.newChild(100));
        }
    }
}

