/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.core.common.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.soa.sca.core.common.ScaCoreCommonPlugin;
import org.eclipse.soa.sca.core.common.utils.ResourceUtils;
import org.eclipse.soa.sca.core.common.utils.ScaResourcesFilter;
import org.eclipse.soa.sca.core.common.utils.ScaXmlUtils;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaXmlIncludesUtils {
    private final List<IProject> projects = new ArrayList<IProject>();

    protected ScaXmlIncludesUtils(IProject project) {
        this.projects.add(project);
        try {
            IProject[] iProjectArray = project.getReferencedProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject ref = iProjectArray[n2];
                this.projects.add(ref);
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static ScaXmlIncludesUtils createIncludesUtils(IProject project) {
        if (project != null) {
            return new ScaXmlIncludesUtils(project);
        }
        return null;
    }

    public QName getQName(IFile file) {
        QName result = null;
        Document document = this.getDOM(file);
        if (document != null) {
            try {
                Node compositeNode = ScaXmlUtils.getScaTopNode(document);
                String compositeName = ScaXmlUtils.getAttributeValue(compositeNode, "name");
                String namespaceUri = ScaXmlUtils.getAttributeValue(compositeNode, "targetNamespace");
                if (namespaceUri != null && namespaceUri.trim().length() > 0) {
                    result = new QName(namespaceUri, compositeName);
                }
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public List<QName> getQNames(IFile[] files) {
        ArrayList<QName> result = new ArrayList<QName>();
        IFile[] iFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            QName qName = this.getQName(file);
            if (qName != null) {
                result.add(qName);
            }
            ++n2;
        }
        return result;
    }

    public List<QName> getQNames(List<IFile> files) {
        IFile[] iFiles = new IFile[files.size()];
        return this.getQNames(files.toArray(iFiles));
    }

    public List<QName> getQNames() {
        ArrayList<IFile> iFiles = new ArrayList<IFile>();
        for (IProject project : this.projects) {
            Set<IContainer> binaryFolders = ScaResourcesFilter.getBinaryContainers(project);
            List<IFile> pIFiles = ResourceUtils.getFiles("composite", binaryFolders);
            iFiles.addAll(pIFiles);
        }
        return this.getQNames(iFiles);
    }

    public IFile getIFile(QName qName) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        for (IProject project : this.projects) {
            Set<IContainer> binaryFolders = ScaResourcesFilter.getBinaryContainers(project);
            List<IFile> pIFiles = ResourceUtils.getFiles("composite", binaryFolders);
            files.addAll(pIFiles);
        }
        for (IFile file : files) {
            QName fileQName = this.getQName(file);
            try {
                if (fileQName == null || !qName.equals(fileQName)) continue;
                return file;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public List<IFile> getIFiles(QName[] qNames) {
        ArrayList<IFile> result = new ArrayList<IFile>();
        QName[] qNameArray = qNames;
        int n = qNames.length;
        int n2 = 0;
        while (n2 < n) {
            QName name = qNameArray[n2];
            IFile file = this.getIFile(name);
            if (file != null) {
                result.add(file);
            }
            ++n2;
        }
        return result;
    }

    public List<IFile> getIFiles(List<QName> qNames) {
        QName[] names = new QName[qNames.size()];
        return this.getIFiles(qNames.toArray(names));
    }

    public List<IFile> getIFiles() {
        ArrayList<IFile> iFiles = new ArrayList<IFile>();
        for (IProject project : this.projects) {
            Set<IContainer> getSourceContainers = ScaResourcesFilter.getSourceContainers(project);
            List<IFile> pIFiles = ResourceUtils.getFiles("composite", getSourceContainers);
            iFiles.addAll(pIFiles);
        }
        return iFiles;
    }

    public Document getDOM(IFile file) {
        try {
            IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForRead(file);
            if (model != null) {
                return ((IDOMModel)model).getDocument();
            }
        }
        catch (Exception e) {
            ScaCoreCommonPlugin.log(e, 4, "Could not get the DOM for " + file);
        }
        return null;
    }

    public List<Document> getDOMs(IFile[] files) {
        ArrayList<Document> result = new ArrayList<Document>();
        IFile[] iFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            Document document = this.getDOM(file);
            if (document != null) {
                result.add(document);
            }
            ++n2;
        }
        return result;
    }

    public List<Document> getDOMs(List<IFile> files) {
        IFile[] iFiles = new IFile[files.size()];
        return this.getDOMs(files.toArray(iFiles));
    }

    public List<Document> getDOMs() {
        ArrayList<IFile> iFiles = new ArrayList<IFile>();
        for (IProject project : this.projects) {
            Set<IContainer> binaryFolders = ScaResourcesFilter.getBinaryContainers(project);
            List<IFile> pIFiles = ResourceUtils.getFiles("composite", binaryFolders);
            iFiles.addAll(pIFiles);
        }
        return this.getDOMs(iFiles);
    }

    public Document getDOMbyQName(QName name) {
        IFile file = this.getIFile(name);
        if (file != null) {
            return this.getDOM(file);
        }
        return null;
    }

    public List<Document> getDOMsByQName(QName[] names) {
        ArrayList<Document> result = new ArrayList<Document>();
        QName[] qNameArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            QName name = qNameArray[n2];
            Document document = this.getDOMbyQName(name);
            if (document != null) {
                result.add(document);
            }
            ++n2;
        }
        return result;
    }

    public List<Document> getDOMsByQName(List<QName> names) {
        QName[] qNames = new QName[names.size()];
        return this.getDOMsByQName(names.toArray(qNames));
    }

    public static IFile getIncludedFile(Object node, IProject project) {
        if (!ScaXmlUtils.isIncludeNode(node)) {
            return null;
        }
        QName qName = ScaXmlUtils.getIncludeQName((Node)node);
        if (qName == null) {
            return null;
        }
        ScaXmlIncludesUtils includesUtils = new ScaXmlIncludesUtils(project);
        return includesUtils.getIFile(qName);
    }
}

