/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.core.common.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.internal.core.JarEntryFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDTUtils {
    public static List<String> getImplementors(String superClassName, IJavaProject javaProject) throws JavaModelException {
        IType[] types;
        ArrayList<String> classes = new ArrayList<String>();
        IType parentType = javaProject.findType(superClassName);
        ITypeHierarchy hierarchy = parentType.newTypeHierarchy(javaProject, (IProgressMonitor)new NullProgressMonitor());
        IType[] iTypeArray = types = hierarchy.getAllSubtypes(parentType);
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType t = iTypeArray[n2];
            classes.add(t.getFullyQualifiedName());
            ++n2;
        }
        return classes;
    }

    public static IResource[] removeResourceFromBinaryFolders(IResource[] _resources) {
        HashMap<IProject, IJavaProject> projects = new HashMap<IProject, IJavaProject>();
        ArrayList<IResource> toKeep = new ArrayList<IResource>();
        IResource[] iResourceArray = _resources;
        int n = _resources.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                IProject p;
                IResource res;
                block9: {
                    res = iResourceArray[n2];
                    p = res.getProject();
                    try {
                        if (p.isOpen()) break block9;
                        p.open((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e1) {
                        e1.printStackTrace();
                        break block10;
                    }
                }
                try {
                    if (p.hasNature("org.eclipse.jdt.core.javanature")) {
                        IJavaProject jp = (IJavaProject)projects.get(p);
                        if (jp == null) {
                            jp = JavaCore.create((IProject)p);
                            projects.put(p, jp);
                        }
                        if (!jp.getOutputLocation().isPrefixOf(res.getFullPath())) {
                            toKeep.add(res);
                        }
                    } else {
                        toKeep.add(res);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        IResource[] result = new IResource[toKeep.size()];
        return toKeep.toArray(result);
    }

    public static List<IJavaProject> getJavaProjectDependencies(IJavaProject javaProject) {
        String[] projectNames;
        if (javaProject == null) {
            return Collections.emptyList();
        }
        ArrayList<IJavaProject> result = new ArrayList<IJavaProject>();
        result.add(javaProject);
        try {
            projectNames = javaProject.getRequiredProjectNames();
        }
        catch (JavaModelException e1) {
            e1.printStackTrace();
            projectNames = new String[]{};
        }
        String[] stringArray = projectNames;
        int n = projectNames.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                IProject project;
                block8: {
                    String projectName = stringArray[n2];
                    project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                    try {
                        if (!project.exists() || !project.isOpen()) break block7;
                        if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
                        }
                        break block8;
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    break block7;
                }
                IJavaProject p = JavaCore.create((IProject)project);
                result.add(p);
            }
            ++n2;
        }
        return result;
    }

    public static List<IProject> getJavaProjectDependencies(IProject project) {
        IJavaProject jp = JDTUtils.getJavaProject(project);
        if (jp != null) {
            List<IJavaProject> jps = JDTUtils.getJavaProjectDependencies(jp);
            ArrayList<IProject> result = new ArrayList<IProject>(jps.size());
            for (IJavaProject jp2 : jps) {
                result.add(jp2.getProject());
            }
            return result;
        }
        ArrayList<IProject> result = new ArrayList<IProject>(1);
        result.add(project);
        return result;
    }

    public static List<String> getClasspath(IJavaProject javaProject, boolean getReferencedProjectClasspath) {
        ArrayList<String> paths = new ArrayList<String>();
        try {
            if (javaProject != null) {
                IClasspathEntry[] entries;
                IClasspathEntry[] iClasspathEntryArray = entries = javaProject.getRawClasspath();
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    switch (entry.getEntryKind()) {
                        case 2: {
                            if (!getReferencedProjectClasspath) break;
                            String projectName = entry.getPath().toString();
                            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                            IJavaProject jProject = JavaCore.create((IProject)project);
                            List<String> subPaths = JDTUtils.getClasspath(jProject, true);
                            paths.addAll(subPaths);
                            break;
                        }
                        case 1: {
                            String path = entry.getPath().toString();
                            paths.add(path);
                            break;
                        }
                        case 4: {
                            entry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
                            if (entry == null) break;
                            String path = entry.getPath().toString();
                            paths.add(path);
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return paths;
    }

    public static IJavaProject getJavaProject(IProject project) {
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                return JavaCore.create((IProject)project);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String[] getQualifiedNameElements(String qualifiedName) {
        int index = qualifiedName.lastIndexOf(46);
        if (index < 0) {
            return new String[]{"", qualifiedName};
        }
        return new String[]{qualifiedName.substring(0, index), qualifiedName.substring(index + 1)};
    }

    public static Diagnostic validateJavaTypeName(String name, EObject eo) {
        IStatus status = JavaConventions.validateJavaTypeName((String)name, (String)JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source"), (String)JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance"));
        if (status.getCode() == 2) {
            return new BasicDiagnostic(2, "", 0, status.getMessage(), new Object[]{eo});
        }
        if (status.getCode() == 4) {
            return new BasicDiagnostic(4, "", 0, status.getMessage(), new Object[]{eo});
        }
        return null;
    }

    public static List<String> implementsOrExtendsAll(IJavaProject javaProject, String className, List<String> superClassNames) {
        String[] scn = superClassNames.toArray(new String[superClassNames.size()]);
        return JDTUtils.implementsOrExtendsAll(javaProject, className, scn);
    }

    public static List<String> implementsOrExtendsAll(IJavaProject javaProject, String className, String ... superClassNames) {
        ArrayList<String> notImplemented = new ArrayList<String>();
        try {
            IType iType = javaProject.findType(className);
            if (iType == null) {
                return Arrays.asList(superClassNames);
            }
            ArrayList<String> superInterfaces = new ArrayList<String>();
            String[] stringArray = iType.getSuperInterfaceNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String t = stringArray[n2];
                String[][] types = iType.resolveType(t);
                if (types != null) {
                    String pckName = types[0][0];
                    pckName = String.valueOf(pckName) + (pckName.length() > 0 ? "." : "");
                    superInterfaces.add(String.valueOf(pckName) + types[0][1]);
                }
                ++n2;
            }
            stringArray = superClassNames;
            n = superClassNames.length;
            n2 = 0;
            while (n2 < n) {
                String superClassName = stringArray[n2];
                if (!superInterfaces.contains(superClassName)) {
                    notImplemented.add(superClassName);
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return notImplemented;
    }

    public static String getClassName(Object transfer) {
        IClassFile classFile = null;
        if (transfer instanceof IFile) {
            IFile file = (IFile)transfer;
            if (!"class".equals(file.getFileExtension())) {
                return null;
            }
            IJavaProject jp = JDTUtils.getJavaProject(file.getProject());
            if (jp != null) {
                classFile = JavaCore.createClassFileFrom((IFile)file);
            }
        } else if (transfer instanceof IClassFile) {
            classFile = (IClassFile)transfer;
        }
        IClassFileReader cfr = null;
        if (classFile != null) {
            cfr = ToolFactory.createDefaultClassFileReader((IClassFile)classFile, (int)17);
        } else if (transfer instanceof IFile) {
            String location = ((IFile)transfer).getLocation().toOSString();
            cfr = ToolFactory.createDefaultClassFileReader((String)location, (int)17);
        }
        if (cfr != null) {
            String result = new String(cfr.getClassName());
            return result.replaceAll("/", ".");
        }
        return null;
    }

    public static IResource copyFileEnclosedInJar(JarEntryFile transfer, File tmpFile) {
        IFile result = null;
        try {
            if (JDTUtils.copyFile(transfer.getContents(), tmpFile)) {
                ResourcesPlugin.getWorkspace().getRoot().refreshLocal(10, null);
                Path location = new Path("file:" + tmpFile.getAbsolutePath());
                result = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)location);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static boolean copyFile(InputStream in, File tmpFile) {
        boolean result;
        block24: {
            result = false;
            FileOutputStream out = null;
            try {
                try {
                    int len;
                    out = new FileOutputStream(tmpFile);
                    byte[] buf = new byte[1024];
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    result = true;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    public static List<IClasspathEntry> getSourceFolders(IJavaProject javaProject) {
        ArrayList<IClasspathEntry> result = new ArrayList<IClasspathEntry>();
        try {
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3) {
                    result.add(entry);
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return result;
    }
}

