/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.core.common.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.soa.sca.core.common.ScaCoreCommonPlugin;
import org.eclipse.soa.sca.core.common.internal.provisional.extensions.IScaSpecificationExtension;
import org.eclipse.soa.sca.core.common.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaExtensionManager {
    public static ScaExtensionManager INSTANCE = new ScaExtensionManager();
    private static final String EP_ID = "org.eclipse.soa.sca.common.utilities";
    private static final String EP_SCA_EXT = "SpecificationExtension";
    private static final String EP_SCA_ATTR_CLASS = "class";
    private static final String EP_SCA_ATTR_VERSION_ID = "specification-id";
    private final Map<String, IScaSpecificationExtension> versionIdToSpec = new HashMap<String, IScaSpecificationExtension>();

    private ScaExtensionManager() {
        this.populate();
    }

    private void populate() {
        IConfigurationElement[] extensions;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = reg.getConfigurationElementsFor(EP_ID);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement rootElement = iConfigurationElementArray[n2];
            if (EP_SCA_EXT.equals(rootElement.getName())) {
                String className = rootElement.getAttribute(EP_SCA_ATTR_CLASS);
                String versionId = rootElement.getAttribute(EP_SCA_ATTR_VERSION_ID);
                if (!StringUtils.isEmpty(className) && !StringUtils.isEmpty(versionId)) {
                    try {
                        Object instance = rootElement.createExecutableExtension(EP_SCA_ATTR_CLASS);
                        IScaSpecificationExtension ext = (IScaSpecificationExtension)instance;
                        this.versionIdToSpec.put(versionId, ext);
                    }
                    catch (CoreException e) {
                        ScaCoreCommonPlugin.log((Exception)((Object)e), 4);
                    }
                }
            }
            ++n2;
        }
    }

    public Collection<IScaSpecificationExtension> getExtensionClasses() {
        return this.versionIdToSpec.values();
    }

    public IScaSpecificationExtension getScaExtensionByVersionId(String versionId) {
        return this.versionIdToSpec.get(versionId);
    }

    public IScaSpecificationExtension getScaExtensionByNamespace(String namespace) {
        IScaSpecificationExtension result = null;
        for (IScaSpecificationExtension ext : this.versionIdToSpec.values()) {
            if (!namespace.equals(ext.getNamespace())) continue;
            result = ext;
            break;
        }
        return result;
    }

    public String getVersionIdByNamespace(String namespace) {
        String result = null;
        for (Map.Entry<String, IScaSpecificationExtension> entry : this.versionIdToSpec.entrySet()) {
            if (!namespace.equals(entry.getValue().getNamespace())) continue;
            result = entry.getKey();
            break;
        }
        return result;
    }
}

