/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.core.common.internal.formeditor.pages.services;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.soa.sca.core.common.internal.formeditor.Messages;
import org.eclipse.soa.sca.core.common.internal.formeditor.pages.AbstractPage;
import org.eclipse.soa.sca.core.common.internal.formeditor.ui.ScaCustomSwt;
import org.eclipse.soa.sca.core.common.internal.formeditor.ui.TableViewerControl;
import org.eclipse.soa.sca.core.common.utils.ScaXmlUtils;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ServicesDetails
implements IDetailsPage {
    private IManagedForm form;
    private final AbstractPage page;
    private Element selectedElement;
    protected Text nameText;
    protected CCombo promoteCombo;
    protected CCombo interfaceTypeCombo;
    protected TableViewerControl bindingsControl;
    protected TableViewerControl operationsControl;

    public ServicesDetails(AbstractPage page) {
        this.page = page;
    }

    public void createContents(Composite parent) {
        FormToolkit toolkit = this.form.getToolkit();
        Color blueFont = parent.getDisplay().getSystemColor(10);
        TableWrapLayout layout2 = new TableWrapLayout();
        layout2.leftMargin = 0;
        layout2.bottomMargin = 0;
        layout2.topMargin = 10;
        parent.setLayout((Layout)layout2);
        ScaCustomSwt.SectionAndComposite sac = ScaCustomSwt.createSection(parent, toolkit, true);
        Section section = sac.getSection();
        section.setText(Messages.ServicesDetails_0);
        section.setDescription(Messages.ServicesDetails_1);
        Composite part = sac.getComposite();
        GridLayout layout = new GridLayout(2, false);
        layout.marginBottom = 20;
        part.setLayout((Layout)layout);
        toolkit.paintBordersFor(part);
        Label nameLabel = toolkit.createLabel(part, Messages.ServicesDetails_2, 64);
        nameLabel.setForeground(blueFont);
        nameLabel.setToolTipText(Messages.ServicesDetails_3);
        this.nameText = toolkit.createText(part, "", 4);
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ServicesDetails.this.selectedElement != null) {
                    String value = ServicesDetails.this.selectedElement.getAttribute("name");
                    if (!ServicesDetails.this.nameText.getText().equals(value)) {
                        ServicesDetails.this.page.addOrSetAttribute(ServicesDetails.this.selectedElement, "name", ServicesDetails.this.nameText.getText());
                    }
                }
            }
        });
        Label promoteLabel = toolkit.createLabel(part, Messages.ServicesDetails_7, 64);
        promoteLabel.setForeground(blueFont);
        promoteLabel.setToolTipText(Messages.ServicesDetails_8);
        this.promoteCombo = new CCombo(part, 0x800808);
        toolkit.adapt((Control)this.promoteCombo, true, true);
        this.promoteCombo.setLayoutData((Object)new GridData(768));
        this.promoteCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (ServicesDetails.this.selectedElement != null) {
                    String value = ServicesDetails.this.selectedElement.getAttribute("promote");
                    if (!ServicesDetails.this.promoteCombo.getText().equals(value)) {
                        ServicesDetails.this.page.addOrSetAttribute(ServicesDetails.this.selectedElement, "promote", ServicesDetails.this.promoteCombo.getText());
                    }
                }
            }
        });
        sac = ScaCustomSwt.createSection(parent, toolkit, true);
        section = sac.getSection();
        section.setText(Messages.ServicesDetails_11);
        section.setDescription(Messages.ServicesDetails_12);
        part = sac.getComposite();
        this.bindingsControl = new TableViewerControl(part, toolkit, true, false);
        sac = ScaCustomSwt.createSection(parent, toolkit, true);
        section = sac.getSection();
        section.setText(Messages.ServicesDetails_13);
        section.setDescription(Messages.ServicesDetails_14);
        part = sac.getComposite();
        layout = new GridLayout(2, false);
        layout.marginBottom = 20;
        part.setLayout((Layout)layout);
        toolkit.paintBordersFor(part);
        Label interfaceTypeLabel = toolkit.createLabel(part, Messages.ServicesDetails_15, 64);
        interfaceTypeLabel.setForeground(blueFont);
        interfaceTypeLabel.setToolTipText(Messages.ServicesDetails_16);
        this.interfaceTypeCombo = new CCombo(part, 0x800808);
        toolkit.adapt((Control)this.interfaceTypeCombo, true, true);
        this.interfaceTypeCombo.add("Java");
        this.interfaceTypeCombo.add("WSDL");
        sac = ScaCustomSwt.createSection(parent, toolkit, false);
        section = sac.getSection();
        section.setText(Messages.ServicesDetails_22);
        section.setDescription(Messages.ServicesDetails_23);
        part = sac.getComposite();
        this.operationsControl = new TableViewerControl(part, toolkit, true, false);
    }

    public void commit(boolean onSave) {
    }

    public void dispose() {
    }

    public void initialize(IManagedForm form) {
        this.form = form;
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isStale() {
        return false;
    }

    public void refresh() {
        this.update();
    }

    public void setFocus() {
    }

    public boolean setFormInput(Object input) {
        return false;
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        this.selectedElement = ssel.size() == 1 ? (Element)ssel.getFirstElement() : null;
        this.update();
    }

    private void update() {
        if (this.selectedElement == null || this.nameText == null || this.nameText.isDisposed()) {
            return;
        }
        String nameValue = this.selectedElement.getAttribute("name");
        String string = nameValue = nameValue != null ? nameValue : "";
        if (!nameValue.equals(this.nameText.getText())) {
            this.nameText.setText(nameValue);
        }
        this.promoteCombo.removeAll();
        String[] promotions = ScaXmlUtils.getPromotions(this.page.getDocument(), true);
        this.promoteCombo.setItems(promotions);
        String promoteValue = this.selectedElement.getAttribute("promote");
        promoteValue = promoteValue != null ? promoteValue : "";
        int index = this.promoteCombo.indexOf(promoteValue);
        this.promoteCombo.select(index);
        NodeList children = this.selectedElement.getChildNodes();
        if (children != null) {
            int i = 0;
            while (i < children.getLength()) {
                Element child;
                if (children.item(i) instanceof Element && (child = (Element)children.item(i)).getLocalName().startsWith("interface.")) {
                    String interfaceType = child.getLocalName().substring(10).toLowerCase();
                    if ("java".equals(interfaceType)) {
                        this.interfaceTypeCombo.select(0);
                        break;
                    }
                    if (!"wsdl".equals(interfaceType)) break;
                    this.interfaceTypeCombo.select(1);
                    break;
                }
                ++i;
            }
        }
    }
}

