/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.core.common.internal.formeditor.explorer;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.soa.sca.core.common.ScaCoreCommonPlugin;
import org.eclipse.soa.sca.core.common.internal.formeditor.Messages;
import org.eclipse.soa.sca.core.common.internal.xmleditor.outline.ScaXmlContentProvider;
import org.eclipse.soa.sca.core.common.internal.xmleditor.outline.ScaXmlLabelProvider;
import org.eclipse.soa.sca.core.common.internal.xmleditor.outline.ScaXmlMouseMoveListener;
import org.eclipse.soa.sca.core.common.utils.JDTUtils;
import org.eclipse.soa.sca.core.common.utils.ResourceUtils;
import org.eclipse.soa.sca.core.common.utils.ScaXmlIncludesUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaResourceExplorer
extends TitleAreaDialog {
    public static String SCA_ALL_RESOURCES = Messages.ScaResourceExplorer_0;
    public static String SCA_COMPOSITES = "Composites - *.composite";
    public static String SCA_CONSTRAINING_TYPES = "Constraining Types - *.composite";
    public static String SCA_COMPONENT_TYPES = "Component Types - *.componentType";
    private TreeViewer wkViewer;
    private TreeViewer scaViewer;
    private final Map<IProject, ScaXmlIncludesUtils> includesUtils = new HashMap<IProject, ScaXmlIncludesUtils>();
    private Text fileNameText;
    private Combo fileExtensionCombo;
    private Image image;
    private String input;
    private boolean expandAll;
    private List<IResource> resourcesToHide = Collections.emptyList();
    private IFile selection;
    private String[] extensions;
    private String filter = SCA_ALL_RESOURCES;
    private static Map<String, String[]> filterToExtensions = new HashMap<String, String[]>();

    static {
        filterToExtensions.put(SCA_COMPOSITES, new String[]{"composite"});
        filterToExtensions.put(SCA_CONSTRAINING_TYPES, new String[]{"composite"});
        filterToExtensions.put(SCA_COMPONENT_TYPES, new String[]{"componenttype"});
        filterToExtensions.put(SCA_ALL_RESOURCES, new String[]{"composite", "componenttype"});
    }

    public ScaResourceExplorer(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(35952);
    }

    public ScaResourceExplorer(Shell parentShell, IProject project) {
        this(parentShell);
        this.input = project.getName();
    }

    protected Control createDialogArea(Composite parent) {
        Composite bigContainer = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        bigContainer.setLayout((Layout)layout);
        bigContainer.setLayoutData((Object)new GridData(1808));
        Composite container = new Composite(bigContainer, 0);
        layout = new GridLayout(2, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.addWorkspaceExplorer(container);
        this.addScaViewer(container);
        this.addFilterElements(container);
        this.getShell().setText(Messages.ScaResourceExplorer_4);
        this.setTitle(Messages.ScaResourceExplorer_5);
        ImageDescriptor desc = ScaCoreCommonPlugin.getPluginImage("icons/wizban/search.gif");
        this.image = desc.createImage();
        this.setTitleImage(this.image);
        if (this.input == null) {
            this.wkViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        } else {
            this.wkViewer.setInput((Object)this.input);
        }
        if (this.expandAll) {
            this.wkViewer.expandAll();
        }
        return bigContainer;
    }

    private void addFilterElements(Composite container) {
        Composite subContainer = new Composite(container, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        subContainer.setLayout((Layout)layout);
        GridData layoutData = new GridData(768);
        subContainer.setLayoutData((Object)layoutData);
        new Label(subContainer, 0).setText(Messages.ScaResourceExplorer_8);
        this.fileNameText = new Text(subContainer, 2060);
        this.fileNameText.setLayoutData((Object)new GridData(768));
        Color c = Display.getDefault().getSystemColor(1);
        this.fileNameText.setBackground(c);
        new Label(subContainer, 0).setText(Messages.ScaResourceExplorer_9);
        this.fileExtensionCombo = new Combo(subContainer, 2060);
        this.fileExtensionCombo.setBackground(c);
        String[] filters = filterToExtensions.keySet().toArray(new String[filterToExtensions.size()]);
        this.fileExtensionCombo.setItems(filters);
        this.fileExtensionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selection = ScaResourceExplorer.this.fileExtensionCombo.getText();
                ScaResourceExplorer.this.extensions = (String[])filterToExtensions.get(selection);
                ScaResourceExplorer.this.wkViewer.refresh();
                ScaResourceExplorer.this.updateMessage();
            }
        });
        this.fileExtensionCombo.select(this.fileExtensionCombo.indexOf(this.filter));
        this.fileExtensionCombo.notifyListeners(13, new Event());
        this.setMessage(Messages.ScaResourceExplorer_10);
    }

    private void addScaViewer(Composite container) {
        this.scaViewer = new TreeViewer(container, 2560);
        this.scaViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.scaViewer.setContentProvider((IContentProvider)new ScaXmlContentProvider());
        this.scaViewer.setLabelProvider((IBaseLabelProvider)new ScaXmlLabelProvider());
        this.scaViewer.setInput(new Object());
        new ScaXmlMouseMoveListener(this.scaViewer);
    }

    private void addWorkspaceExplorer(Composite container) {
        this.wkViewer = new TreeViewer(container, 35332);
        GridData layoutData = new GridData(1808);
        layoutData.heightHint = 100;
        this.wkViewer.getTree().setLayoutData((Object)layoutData);
        this.wkViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.wkViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            private Object[] getContainerElements(IContainer container) {
                IResource[] res = ResourceUtils.getDirectValidChildren(container, ScaResourceExplorer.this.extensions, (List<IResource>)ScaResourceExplorer.this.resourcesToHide);
                return JDTUtils.removeResourceFromBinaryFolders(res);
            }

            public Object[] getChildren(Object o) {
                if (o instanceof IContainer) {
                    return this.getContainerElements((IContainer)o);
                }
                return new Object[0];
            }

            public boolean hasChildren(Object element) {
                if (element instanceof IContainer) {
                    return this.getContainerElements((IContainer)element).length > 0;
                }
                return false;
            }

            public Object getParent(Object element) {
                if (element instanceof IResource) {
                    IContainer parent = ((IResource)element).getParent();
                    if (parent instanceof IWorkspaceRoot) {
                        return null;
                    }
                    return parent;
                }
                return null;
            }

            public Object[] getElements(Object inputElement) {
                IProject p;
                if (inputElement instanceof IWorkspaceRoot) {
                    return ((IWorkspaceRoot)inputElement).getProjects();
                }
                if (inputElement instanceof String && (p = ResourcesPlugin.getWorkspace().getRoot().getProject((String)inputElement)) != null) {
                    List<IProject> dependencies = JDTUtils.getJavaProjectDependencies(p);
                    return dependencies.toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.wkViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    return;
                }
                Button b = ScaResourceExplorer.this.getButton(0);
                Object res = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (res instanceof IFile) {
                    ScaXmlIncludesUtils iu = ScaResourceExplorer.this.getIncludesUtil((IResource)((IFile)res));
                    Document document = iu.getDOM((IFile)res);
                    ScaResourceExplorer.this.scaViewer.setContentProvider((IContentProvider)new ScaXmlContentProvider((IFile)res));
                    ScaResourceExplorer.this.scaViewer.setInput((Object)document);
                    ScaResourceExplorer.this.scaViewer.refresh();
                    Color c = Display.getDefault().getSystemColor(1);
                    ScaResourceExplorer.this.scaViewer.getTree().setBackground(c);
                    ScaResourceExplorer.this.fileNameText.setText(((IFile)res).getName());
                    ScaResourceExplorer.this.selection = (IFile)res;
                    if (b != null) {
                        b.setEnabled(true);
                    }
                } else {
                    ScaResourceExplorer.this.scaViewer.setInput(new Object());
                    ScaResourceExplorer.this.scaViewer.refresh();
                    Color c = Display.getDefault().getSystemColor(22);
                    ScaResourceExplorer.this.scaViewer.getTree().setBackground(c);
                    ScaResourceExplorer.this.fileNameText.setText("");
                    ScaResourceExplorer.this.selection = null;
                    if (b != null) {
                        b.setEnabled(false);
                    }
                }
            }
        });
    }

    private ScaXmlIncludesUtils getIncludesUtil(IResource res) {
        IProject project = res.getProject();
        ScaXmlIncludesUtils iu = this.includesUtils.get(project);
        if (iu == null) {
            iu = ScaXmlIncludesUtils.createIncludesUtils(project);
            this.includesUtils.put(project, iu);
        }
        return iu;
    }

    public void setFilter(String filter) {
        if (filterToExtensions.keySet().contains(filter)) {
            this.filter = filter;
        }
    }

    public void setExpandAll(boolean expandAll) {
        this.expandAll = expandAll;
        if (this.wkViewer != null && expandAll) {
            this.wkViewer.expandAll();
        }
    }

    public void setResourcesToHide(List<IResource> resourcesToHide) {
        this.resourcesToHide = resourcesToHide != null ? resourcesToHide : Collections.emptyList();
    }

    public IFile getResultAsFile() {
        return this.selection;
    }

    public QName getResultAsQName() {
        if (this.selection != null) {
            ScaXmlIncludesUtils iu = this.includesUtils.get(this.selection.getProject());
            return iu.getQName(this.selection);
        }
        return null;
    }

    protected Point getInitialSize() {
        return new Point(700, 500);
    }

    public boolean close() {
        if (this.scaViewer != null && this.scaViewer.getLabelProvider() != null) {
            this.scaViewer.getLabelProvider().dispose();
        }
        if (this.image != null) {
            this.image.dispose();
        }
        return super.close();
    }

    private void updateMessage() {
        int count = this.wkViewer.getTree().getItems().length;
        if (count <= 1) {
            this.setMessage(Messages.ScaResourceExplorer_12, 1);
        } else {
            this.setMessage(Messages.ScaResourceExplorer_13);
        }
    }
}

