/**
 * Copyright (c) 2019 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.component.componentDatasheet;

import java.util.List;
import org.eclipse.smartmdsd.ecore.component.componentDatasheet.ComponentDatasheet;
import org.eclipse.smartmdsd.ecore.component.componentDatasheet.ComponentDatasheetPackage;
import org.eclipse.smartmdsd.ecore.component.componentDatasheet.ComponentPortDatasheet;
import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

@SuppressWarnings("all")
public class ComponentDatasheetQNameProvider extends DefaultDeclarativeQualifiedNameProvider {
  public QualifiedName qualifiedName(final ComponentDatasheet ds) {
    final List<INode> nodes = NodeModelUtils.findNodesForFeature(ds, ComponentDatasheetPackage.Literals.COMPONENT_DATASHEET__COMPONENT);
    boolean _isEmpty = nodes.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      return QualifiedName.create(NodeModelUtils.getTokenText(nodes.get(0)));
    } else {
      boolean _eIsSet = ds.eIsSet(ComponentDatasheetPackage.Literals.COMPONENT_DATASHEET__COMPONENT);
      if (_eIsSet) {
        return QualifiedName.create(ds.getComponent().getName());
      }
    }
    return QualifiedName.EMPTY;
  }
  
  public QualifiedName qualifiedName(final ComponentPortDatasheet ds) {
    final QualifiedName parent = super.getFullyQualifiedName(ds.eContainer());
    final List<INode> nodes = NodeModelUtils.findNodesForFeature(ds, ComponentDatasheetPackage.Literals.COMPONENT_PORT_DATASHEET__PORT);
    boolean _isEmpty = nodes.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      return parent.append(NodeModelUtils.getTokenText(nodes.get(0)));
    } else {
      boolean _eIsSet = ds.eIsSet(ComponentDatasheetPackage.Literals.COMPONENT_PORT_DATASHEET__PORT);
      if (_eIsSet) {
        return parent.append(ds.getPort().getName());
      }
    }
    return QualifiedName.EMPTY;
  }
}
