/**
 * Copyright (c) 2019 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.base.genericDatasheet.formatting2;

import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.DatasheetProperty;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class GenericDatasheetFormatter extends AbstractFormatter2 {
  protected void _format(final DatasheetProperty property, @Extension final IFormattableDocument document) {
    final ISemanticRegion ropen = this.textRegionExtensions.regionFor(property).keyword("{");
    final ISemanticRegion rclose = this.textRegionExtensions.regionFor(property).keyword("}");
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.append(ropen, _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    document.<ISemanticRegion, ISemanticRegion>interior(ropen, rclose, _function_1);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.prepend(rclose, _function_2);
  }
  
  public void format(final Object property, final IFormattableDocument document) {
    if (property instanceof XtextResource) {
      _format((XtextResource)property, document);
      return;
    } else if (property instanceof DatasheetProperty) {
      _format((DatasheetProperty)property, document);
      return;
    } else if (property instanceof EObject) {
      _format((EObject)property, document);
      return;
    } else if (property == null) {
      _format((Void)null, document);
      return;
    } else if (property != null) {
      _format(property, document);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(property, document).toString());
    }
  }
}
