/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtext.base.basicAttributes.validation;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractAttributeType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.ArrayValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeRefinement;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.BasicAttributesPackage;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.BasicAttributesTypeConformance;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.EnumerationElement;
import org.eclipse.smartmdsd.xtext.base.basicAttributes.validation.AbstractBasicAttributesValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Conversions;

public class BasicAttributesValidator
extends AbstractBasicAttributesValidator {
    @Inject
    private BasicAttributesTypeConformance conf;
    protected static final String ISSUE_PREFIX = "org.xtext.service.communicationObject.";
    public static final String INCOMPATIBLE_TYPES = "org.xtext.service.communicationObject.IncompatibleTypes";
    public static final String INCOMPATIBLE_CARDINALITY = "org.xtext.service.communicationObject.IncompatibleCardinality";
    public static final String SMALL_ATTR_NAME = "org.xtext.service.communicationObject.SmallAttributeName";
    public static final String CPP_KEYWORD_ATTR_NAME = "org.xtext.service.communicationObject.CppKeywordAttributeName";
    public static final String RESERVED_ENUM_NAME = "org.xtext.service.communicationObject.ReservedEnumName";

    public Boolean isCompatible(AbstractValue av, AbstractAttributeType type) {
        return this.conf.isCompatible(av, type);
    }

    @Check
    public void checkTypeConformance(AbstractValue av) {
        EObject parent = av.eContainer();
        if (parent instanceof ArrayValue) {
            parent = ((ArrayValue)parent).eContainer();
        }
        if (parent instanceof AttributeDefinition) {
            boolean _not;
            Boolean _isCompatible = this.isCompatible(av, ((AttributeDefinition)parent).getType());
            boolean bl = _not = _isCompatible == false;
            if (_not) {
                String _cardinalityName = this.conf.getCardinalityName(((AttributeDefinition)parent).getType());
                String _plus = "Incompatible types. Expected " + _cardinalityName;
                String _plus_1 = String.valueOf(_plus) + ", but assigned is ";
                String _valueTypeName = this.conf.getValueTypeName(av);
                String _plus_2 = String.valueOf(_plus_1) + _valueTypeName;
                String _plus_3 = String.valueOf(_plus_2) + ".";
                this.error(_plus_3, null, INCOMPATIBLE_TYPES, new String[0]);
            }
        } else if (parent instanceof AttributeRefinement) {
            boolean _not_1;
            Boolean _isCompatible_1 = this.isCompatible(av, ((AttributeRefinement)parent).getAttribute().getType());
            boolean bl = _not_1 = _isCompatible_1 == false;
            if (_not_1) {
                String _cardinalityName_1 = this.conf.getCardinalityName(((AttributeRefinement)parent).getAttribute().getType());
                String _plus_4 = "Incompatible types. Expected " + _cardinalityName_1;
                String _plus_5 = String.valueOf(_plus_4) + ", but assigned is ";
                String _valueTypeName_1 = this.conf.getValueTypeName(av);
                String _plus_6 = String.valueOf(_plus_5) + _valueTypeName_1;
                String _plus_7 = String.valueOf(_plus_6) + ".";
                this.error(_plus_7, null, INCOMPATIBLE_TYPES, new String[0]);
            }
        }
    }

    @Check
    public void checkCardinality(AbstractValue av) {
        EObject parent = av.eContainer();
        if (parent instanceof ArrayValue) {
            parent = ((ArrayValue)parent).eContainer();
        }
        if (av instanceof ArrayValue) {
            AbstractAttributeType type = null;
            if (parent instanceof AttributeDefinition) {
                type = ((AttributeDefinition)parent).getType();
            } else if (parent instanceof AttributeRefinement) {
                type = ((AttributeRefinement)parent).getAttribute().getType();
            }
            if (type != null && type.getArray() != null) {
                Integer arrayLength;
                int numberValues = ((Object[])Conversions.unwrapArray((Object)((ArrayValue)av).getValues(), Object.class)).length;
                String length = type.getArray().getLength();
                if (length != null && !Objects.equal((Object)length, (Object)"*") && numberValues > (arrayLength = Integer.valueOf(length))) {
                    this.error("Array length mismatch. Assigned array-value of size " + Integer.valueOf(numberValues) + " to a static array-type of size " + length + ".", null, INCOMPATIBLE_CARDINALITY, new String[0]);
                }
            }
        }
    }

    @Check
    public void checkAttributeStartsWithSmallLetter(AttributeDefinition attr) {
        boolean _not;
        boolean _isLowerCase = Character.isLowerCase(attr.getName().charAt(0));
        boolean bl = _not = !_isLowerCase;
        if (_not) {
            this.warning("Element name should start with a small letter!", (EStructuralFeature)BasicAttributesPackage.Literals.ATTRIBUTE_DEFINITION__NAME, SMALL_ATTR_NAME, new String[0]);
        }
    }

    @Check
    public void checkCppReservedKeywords(AttributeDefinition elem) {
        boolean _contains = BasicAttributesTypeConformance.cppKeywords.contains(elem.getName());
        if (_contains) {
            this.error("Element name must not be a C++ reserved keyword.", (EStructuralFeature)BasicAttributesPackage.Literals.ATTRIBUTE_DEFINITION__NAME, CPP_KEYWORD_ATTR_NAME, new String[0]);
        }
    }

    @Check
    public void checkEnumNameNotDefaultValue(EnumerationElement en) {
        boolean _equals = en.getName().equals("ENUM_VALUE_UNDEFINED");
        if (_equals) {
            this.error("This EnumerationElement is not allowed (it is reserved for internal usage).", (EStructuralFeature)BasicAttributesPackage.Literals.ENUMERATION_ELEMENT__NAME, RESERVED_ENUM_NAME, new String[0]);
        }
    }
}

