/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtext.system.componentArchitecture.formatting2;

import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentInstance;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentInstanceExtension;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.Connection;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ServiceInstance;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.SystemComponentArchitecture;
import org.eclipse.smartmdsd.xtext.service.roboticMiddleware.formatting2.RoboticMiddlewareFormatter;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ComponentArchitectureFormatter
extends RoboticMiddlewareFormatter {
    protected void _format(SystemComponentArchitecture systemModel, @Extension IFormattableDocument document) {
        ISemanticRegion open = this.textRegionExtensions.regionFor((EObject)systemModel).keyword("{");
        ISemanticRegion close = this.textRegionExtensions.regionFor((EObject)systemModel).keyword("}");
        Procedures.Procedure1 _function = it -> it.newLine();
        document.prepend(open, _function);
        Procedures.Procedure1 _function_1 = it -> it.newLine();
        document.append(open, _function_1);
        Procedures.Procedure1 _function_2 = it -> it.indent();
        document.interior(open, close, _function_2);
        EList _components = systemModel.getComponents();
        for (ComponentInstance componentInstance : _components) {
            document.format((Object)componentInstance);
        }
        EList _connections = systemModel.getConnections();
        for (Connection conn : _connections) {
            document.format((Object)conn);
        }
    }

    protected void _format(ComponentInstance componentInstance, @Extension IFormattableDocument document) {
        ISemanticRegion ropen = this.textRegionExtensions.regionFor((EObject)componentInstance).keyword("{");
        ISemanticRegion rclose = this.textRegionExtensions.regionFor((EObject)componentInstance).keyword("}");
        Procedures.Procedure1 _function = it -> it.newLine();
        document.prepend(ropen, _function);
        Procedures.Procedure1 _function_1 = it -> it.newLine();
        document.append(ropen, _function_1);
        Procedures.Procedure1 _function_2 = it -> it.indent();
        document.interior(ropen, rclose, _function_2);
        Procedures.Procedure1 _function_3 = it -> it.setNewLines(1, 1, 2);
        document.append((EObject)componentInstance, _function_3);
        EList _extensions = componentInstance.getExtensions();
        for (ComponentInstanceExtension ex : _extensions) {
            document.format((Object)ex);
            Procedures.Procedure1 _function_4 = it -> it.setNewLines(1, 1, 2);
            document.append((EObject)ex, _function_4);
        }
        EList _ports = componentInstance.getPorts();
        for (ServiceInstance port : _ports) {
            document.format((Object)port);
            Procedures.Procedure1 _function_4 = it -> it.setNewLines(1, 1, 2);
            document.append((EObject)port, _function_4);
        }
    }

    protected void _format(Connection connection, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.setNewLines(1, 1, 2);
        document.append((EObject)connection, _function);
    }

    public void format(Object componentInstance, IFormattableDocument document) {
        if (componentInstance instanceof XtextResource) {
            this._format((XtextResource)componentInstance, document);
            return;
        }
        if (componentInstance instanceof ComponentInstance) {
            this._format((ComponentInstance)componentInstance, document);
            return;
        }
        if (componentInstance instanceof Connection) {
            this._format((Connection)componentInstance, document);
            return;
        }
        if (componentInstance instanceof SystemComponentArchitecture) {
            this._format((SystemComponentArchitecture)componentInstance, document);
            return;
        }
        if (componentInstance instanceof EObject) {
            this._format((EObject)componentInstance, document);
            return;
        }
        if (componentInstance == null) {
            this._format(null, document);
            return;
        }
        if (componentInstance != null) {
            this._format(componentInstance, document);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(componentInstance, document).toString());
    }
}

