/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.system.componentArchitecture.formatting2;

import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentInstance;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentInstanceExtension;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.Connection;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ServiceInstance;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.SystemComponentArchitecture;
import org.eclipse.smartmdsd.xtext.service.roboticMiddleware.formatting2.RoboticMiddlewareFormatter;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class ComponentArchitectureFormatter extends RoboticMiddlewareFormatter {
  protected void _format(final SystemComponentArchitecture systemModel, @Extension final IFormattableDocument document) {
    final ISemanticRegion open = this.textRegionExtensions.regionFor(systemModel).keyword("{");
    final ISemanticRegion close = this.textRegionExtensions.regionFor(systemModel).keyword("}");
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.prepend(open, _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.append(open, _function_1);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    document.<ISemanticRegion, ISemanticRegion>interior(open, close, _function_2);
    EList<ComponentInstance> _components = systemModel.getComponents();
    for (final ComponentInstance componentInstance : _components) {
      document.<ComponentInstance>format(componentInstance);
    }
    EList<Connection> _connections = systemModel.getConnections();
    for (final Connection conn : _connections) {
      document.<Connection>format(conn);
    }
  }
  
  protected void _format(final ComponentInstance componentInstance, @Extension final IFormattableDocument document) {
    final ISemanticRegion ropen = this.textRegionExtensions.regionFor(componentInstance).keyword("{");
    final ISemanticRegion rclose = this.textRegionExtensions.regionFor(componentInstance).keyword("}");
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.prepend(ropen, _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.append(ropen, _function_1);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    document.<ISemanticRegion, ISemanticRegion>interior(ropen, rclose, _function_2);
    final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
      it.setNewLines(1, 1, 2);
    };
    document.<ComponentInstance>append(componentInstance, _function_3);
    EList<ComponentInstanceExtension> _extensions = componentInstance.getExtensions();
    for (final ComponentInstanceExtension ex : _extensions) {
      {
        document.<ComponentInstanceExtension>format(ex);
        final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it) -> {
          it.setNewLines(1, 1, 2);
        };
        document.<ComponentInstanceExtension>append(ex, _function_4);
      }
    }
    EList<ServiceInstance> _ports = componentInstance.getPorts();
    for (final ServiceInstance port : _ports) {
      {
        document.<ServiceInstance>format(port);
        final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it) -> {
          it.setNewLines(1, 1, 2);
        };
        document.<ServiceInstance>append(port, _function_4);
      }
    }
  }
  
  protected void _format(final Connection connection, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.setNewLines(1, 1, 2);
    };
    document.<Connection>append(connection, _function);
  }
  
  public void format(final Object componentInstance, final IFormattableDocument document) {
    if (componentInstance instanceof XtextResource) {
      _format((XtextResource)componentInstance, document);
      return;
    } else if (componentInstance instanceof ComponentInstance) {
      _format((ComponentInstance)componentInstance, document);
      return;
    } else if (componentInstance instanceof Connection) {
      _format((Connection)componentInstance, document);
      return;
    } else if (componentInstance instanceof SystemComponentArchitecture) {
      _format((SystemComponentArchitecture)componentInstance, document);
      return;
    } else if (componentInstance instanceof EObject) {
      _format((EObject)componentInstance, document);
      return;
    } else if (componentInstance == null) {
      _format((Void)null, document);
      return;
    } else if (componentInstance != null) {
      _format(componentInstance, document);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(componentInstance, document).toString());
    }
  }
}
